#ifndef INCLUDED_QBtWorkspace_h
#define INCLUDED_QBtWorkspace_h
/********************************************************************
 * Copyright (C) Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of Beesoft Differ.
 *
 * Beesoft Differ is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * Beesoft Differ is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Beesoft Differ; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 *-------------------------------------------------------------------
 * Project      : Beesoft Differ
 * File         : QBtWorkspace.h
 * Author       : Piotr Pszczolkowski
 * Contact      : piotr@beesoft.org
 * Creation date: 28.01.2008
 *******************************************************************/

/*------- include files:
-------------------------------------------------------------------*/
#include <QWidget>

/*------- forward declarations:
-------------------------------------------------------------------*/
class QComboBox;
class QPushButton;
class QBtSeparator;
class QBtBrowser;
class QScrollBar;
class QBtPointsButton;
class QBtIndicator;
class QBtOperator;

/*------- class declaration:
-------------------------------------------------------------------*/
class QBtWorkspace : public QWidget
{
   Q_OBJECT

//******* CONSTRUCTION / DESTRUCTION *******
public:
   QBtWorkspace( QWidget* = 0 );
   ~QBtWorkspace();
private:
   QBtWorkspace( const QBtWorkspace& );
   QBtWorkspace& operator=( const QBtWorkspace& );

//******* CONSTANTS *******
private:
   static const char* const NOT_FILE;
   static const char* const NO_SELECTED;
   static const char* const FILES_EQUAL;

//******* MEMBERS *******
private:
   QBtPointsButton* const lft_btn_;
   QBtPointsButton* const rgt_btn_;
   QComboBox*       const lft_fpath_;
   QComboBox*       const rgt_fpath_;
   QScrollBar*      const lft_sbar_;
   QScrollBar*      const rgt_sbar_;
   QBtBrowser*      const lft_browser_;
   QBtBrowser*      const rgt_browser_;
   QBtIndicator*    const lft_indicator_;
   QBtIndicator*    const rgt_indicator_;
   QBtOperator*     const lft_operator_;
   QBtOperator*     const rgt_operator_;
   QBtSeparator*    const separator_;
   QString                lft_dir_;
   QString                rgt_dir_;
   bool                   can_scroll_;

//******* METHODS *******
public:
   void lft_read_file  ( const QString& );
   void rgt_read_file  ( const QString& );
   void save           ();
   bool save_on_exit   ();
   void del_on_left    ();
   void del_on_right   ();
   void merge_to_left  ();
   void merge_to_right ();

private:
   void customEvent        ( QEvent* );
   void update_looks       ();
   void save_config        () const;
   void restore_config     ();
   void check_fpath_history( QComboBox* );
   void remove_no_selected ( QComboBox* );
   void remove_from_left   ( int, bool = true );
   void remove_from_right  ( int, bool = true );
   void move_from_left     ( int, bool = true );
   void move_from_right    ( int, bool = true );
   void change_from_left   ( int, bool = true );
   void change_from_right  ( int, bool = true );
   void update_all         ();
   void update_lft_cbox    ( bool = true );
   void update_rgt_cbox    ( bool = true );
   void befor_automation   ();
   void after_automation   ();
   void are_the_same       ();
private slots:
   void update_request();
   void lft_fpath_activated( const QString& );
   void rgt_fpath_activated( const QString& );
   void lft_file_selection();
   void rgt_file_selection();
   void ready();
   void lft_browser_scrolled( int );
   void rgt_browser_scrolled( int );
signals:
   void stat_total( int );
   void stat_chg  ( int );
   void stat_add  ( int );
   void stat_del  ( int );
};

#endif // INCLUDED_QBtWorkspace_h
