#ifndef INCLUDED_QBtConfigTextViewer_h
#define INCLUDED_QBtConfigTextViewer_h
/********************************************************************
 * Copyright (C) Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of Beesoft Differ.
 *
 * Beesoft Differ is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * Beesoft Differ is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Beesoft Differ; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 *-------------------------------------------------------------------
 * Project      : Beesoft Differ
 * File         : QBtConfigTextViewer.h
 * Author       : Piotr Pszczolkowski
 * Contact      : piotr@beesoft.org
 * Creation date: 21.02.2008
 *******************************************************************/

/*------- include files:
-------------------------------------------------------------------*/
#include "QBiConfigWidget.h"

/*------- forward declarations:
-------------------------------------------------------------------*/
class QBtColorDemo;
class QPushButton;

/*------- class declaration:
-------------------------------------------------------------------*/
class QBtConfigTextViewer : public QBiConfigWidget
{
   Q_OBJECT

//******* CONSTRUCTION / DESTRUCTION *******
public:
   QBtConfigTextViewer( QWidget* = 0 );
private:
   QBtConfigTextViewer( const QBtConfigTextViewer& );
   QBtConfigTextViewer& operator=( const QBtConfigTextViewer& );

//******* CONSTANTS *******
private:
   static const char* const BROWSER;
   static const char* const BACKGROUND;
   static const char* const FONT;
   static const char* const COLOR;
   static const char* const HIGHLIGHT;
   static const char* const CHANGED;
   static const char* const ADDED;
   static const char* const DELETED;

//******* MEMBERS *******
private:
   QBtColorDemo* const chg_color_demo_;
   QBtColorDemo* const add_color_demo_;
   QBtColorDemo* const del_color_demo_;
   QPushButton * const chg_color_btn_;
   QPushButton * const add_color_btn_;
   QPushButton * const del_color_btn_;
   QBtColorDemo* const browser_demo_;
   QPushButton * const bkg_color_btn_;
   QPushButton * const fnt_font_btn_;
   QPushButton * const fnt_color_btn_;

//******* METHODS *******
public:
   void apply();
private slots:
   void bkg_color();
   void fnt_font();
   void fnt_color();
   void chg_color();
   void add_color();
   void del_color();
};

#endif // INCLUDED_QBtConfigTextViewer_h

