/********************************************************************
 * Copyright (C) Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of Beesoft Differ.
 *
 * Beesoft Differ is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * Beesoft Differ is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Beesoft Differ; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 *-------------------------------------------------------------------
 * Project      : Beesoft Differ
 * File         : QBtConfigTextViewer.h
 * Author       : Piotr Pszczolkowski
 * Contact      : piotr@beesoft.org
 * Creation date: 21.02.2008
 *******************************************************************/

/*------- include files:
-------------------------------------------------------------------*/
#include "QBtConfigTextViewer.h"
#include "QBtColorDemo.h"
#include "QBtConfig.h"
#include "QBtSettings.h"
#include "QBtEventsController.h"
#include <QPushButton>
#include <QGridLayout>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QGroupBox>
#include <QLabel>
#include <QColorDialog>
#include <QFontDialog>

/*------- constants:
-------------------------------------------------------------------*/
const char* const QBtConfigTextViewer::BROWSER    = QT_TR_NOOP( "Browser" );
const char* const QBtConfigTextViewer::BACKGROUND = QT_TR_NOOP( "&Background" );
const char* const QBtConfigTextViewer::FONT       = QT_TR_NOOP( "&Font" );
const char* const QBtConfigTextViewer::COLOR      = QT_TR_NOOP( "C&olor" );
const char* const QBtConfigTextViewer::HIGHLIGHT  = QT_TR_NOOP( "Highlighting" );
const char* const QBtConfigTextViewer::CHANGED    = QT_TR_NOOP( "Cha&nged:" );
const char* const QBtConfigTextViewer::ADDED      = QT_TR_NOOP( "Add&ed:" );
const char* const QBtConfigTextViewer::DELETED    = QT_TR_NOOP( "&Deleted:" );


//*******************************************************************
// QBtConfigTextViewer                                   CONSTRUCTOR
//*******************************************************************
QBtConfigTextViewer::QBtConfigTextViewer( QWidget* const in_parent )
: QBiConfigWidget( in_parent )
, chg_color_demo_( new QBtColorDemo( true ) )
, add_color_demo_( new QBtColorDemo( true ) )
, del_color_demo_( new QBtColorDemo( true ) )
, chg_color_btn_ ( new QPushButton( QIcon( ":/img/colors.png" ), QString() ) )
, add_color_btn_ ( new QPushButton( QIcon( ":/img/colors.png" ), QString() ) )
, del_color_btn_ ( new QPushButton( QIcon( ":/img/colors.png" ), QString() ) )
, browser_demo_  ( new QBtColorDemo( true ) )
, bkg_color_btn_ ( new QPushButton( QIcon( ":/img/colors.png" ), tr( BACKGROUND ) ) )
, fnt_font_btn_  ( new QPushButton( QIcon( ":/img/fonts.png" ) , tr( FONT ) ) )
, fnt_color_btn_ ( new QPushButton( QIcon( ":/img/colors.png" ), tr( COLOR ) ) )
{
   QHBoxLayout* const btn_layout = new QHBoxLayout;
   btn_layout->addStretch();
   btn_layout->addWidget( bkg_color_btn_ );
   btn_layout->addWidget( fnt_font_btn_ );
   btn_layout->addWidget( fnt_color_btn_ );
   btn_layout->addStretch();
   QGroupBox* const browser_gbox = new QGroupBox( tr( BROWSER ) );
   QVBoxLayout* const browser_layout = new QVBoxLayout( browser_gbox );
   browser_layout->addWidget( browser_demo_ );
   browser_layout->addLayout( btn_layout );

   QLabel* const chg_lbl = new QLabel( tr( CHANGED ) );
   QLabel* const add_lbl = new QLabel( tr( ADDED ) );
   QLabel* const del_lbl = new QLabel( tr( DELETED ) );
   chg_lbl->setBuddy( chg_color_btn_ );
   add_lbl->setBuddy( add_color_btn_ );
   del_lbl->setBuddy( del_color_btn_ );
   QGroupBox* const hlight_gbox = new QGroupBox( tr( HIGHLIGHT ) );
   QGridLayout* const hlight_layout = new QGridLayout( hlight_gbox );
   hlight_layout->addWidget( chg_lbl        , 0, 0 );
   hlight_layout->addWidget( add_lbl        , 1, 0 );
   hlight_layout->addWidget( del_lbl        , 2, 0 );
   hlight_layout->addWidget( chg_color_demo_, 0, 1 );
   hlight_layout->addWidget( add_color_demo_, 1, 1 );
   hlight_layout->addWidget( del_color_demo_, 2, 1 );
   hlight_layout->addWidget( chg_color_btn_ , 0, 2 );
   hlight_layout->addWidget( add_color_btn_ , 1, 2 );
   hlight_layout->addWidget( del_color_btn_ , 2, 2 );
   
   QVBoxLayout* const main_layout = new QVBoxLayout;
   main_layout->addWidget( browser_gbox );
   main_layout->addWidget( hlight_gbox );
   setLayout( main_layout );


   const QBtConfig* const cfg = QBtConfig::instance();
   
   browser_demo_->set_color  ( cfg->bkg_color() );
   chg_color_demo_->set_color( cfg->chg_color() );
   add_color_demo_->set_color( cfg->add_color() );
   del_color_demo_->set_color( cfg->del_color() );

   browser_demo_->set_font_color( cfg->font_color() );
   chg_color_demo_->set_font_color( cfg->font_color() );
   add_color_demo_->set_font_color( cfg->font_color() );
   del_color_demo_->set_font_color( cfg->font_color() );
 
   browser_demo_->set_font( cfg->font() );
   chg_color_demo_->set_font( cfg->font() );
   add_color_demo_->set_font( cfg->font() );
   del_color_demo_->set_font( cfg->font() );
   
   connect( bkg_color_btn_, SIGNAL( clicked() ), this, SLOT( bkg_color() ) );
   connect( fnt_font_btn_ , SIGNAL( clicked() ), this, SLOT( fnt_font () ) );
   connect( fnt_color_btn_, SIGNAL( clicked() ), this, SLOT( fnt_color() ) );
   connect( chg_color_btn_, SIGNAL( clicked() ), this, SLOT( chg_color() ) );
   connect( add_color_btn_, SIGNAL( clicked() ), this, SLOT( add_color() ) );
   connect( del_color_btn_, SIGNAL( clicked() ), this, SLOT( del_color() ) );
}
// end of QBtConfigTextViewer

//*******************************************************************
// bkg_color                                            PRIVATE slot
//*******************************************************************
void QBtConfigTextViewer::bkg_color()
{
   const QColor old_color = browser_demo_->get_color();
   const QColor new_color = QColorDialog::getColor( old_color, this );
   if( new_color.isValid() ) {
      if( new_color != old_color ) {
         browser_demo_->set_color( new_color );
      }
   }
}
// end of bkg_color

//*******************************************************************
// fnt_font                                             PRIVATE slot
//*******************************************************************
void QBtConfigTextViewer::fnt_font()
{
   bool ok = bool();
   const QFont old_font = browser_demo_->get_font();
   const QFont new_font = QFontDialog::getFont( &ok, old_font, this );
   if( ok ) {
      if( old_font != new_font ) {
         browser_demo_->set_font( new_font );
         chg_color_demo_->set_font( new_font );
         add_color_demo_->set_font( new_font );
         del_color_demo_->set_font( new_font );
      }
   }
}
// end of fnt_font

//*******************************************************************
// fnt_color                                            PRIVATE slot
//*******************************************************************
void QBtConfigTextViewer::fnt_color()
{
   const QColor old_color = browser_demo_->get_font_color();
   const QColor new_color = QColorDialog::getColor( old_color, this );
   if( new_color.isValid() ) {
      if( new_color != old_color ) {
         browser_demo_->set_font_color( new_color );
         chg_color_demo_->set_font_color( new_color );
         add_color_demo_->set_font_color( new_color );
         del_color_demo_->set_font_color( new_color );
      }
   }
}
// end of fnt_color

//*******************************************************************
// chg_color                                            PRIVATE slot
//*******************************************************************
void QBtConfigTextViewer::chg_color()
{
   const QColor old_color = chg_color_demo_->get_color();
   const QColor new_color = QColorDialog::getColor( old_color, this );
   if( new_color.isValid() ) {
      if( new_color != old_color ) {
         chg_color_demo_->set_color( new_color );
      }
   }
}
// end of chg_color

//*******************************************************************
// add_color                                            PRIVATE slot
//*******************************************************************
void QBtConfigTextViewer::add_color()
{
   const QColor old_color = add_color_demo_->get_color();
   const QColor new_color = QColorDialog::getColor( old_color, this );
   if( new_color.isValid() ) {
      if( new_color != old_color ) {
         add_color_demo_->set_color( new_color );
      }
   }
}
// end of add_color

//*******************************************************************
// del_color                                            PRIVATE slot
//*******************************************************************
void QBtConfigTextViewer::del_color()
{
   const QColor old_color = del_color_demo_->get_color();
   const QColor new_color = QColorDialog::getColor( old_color, this );
   if( new_color.isValid() ) {
      if( new_color != old_color ) {
         del_color_demo_->set_color( new_color );
      }
   }
}
// end of del_color

//*******************************************************************
// apply                                            PUBLIC inherited
//*******************************************************************
void QBtConfigTextViewer::apply()
{
   QBtConfig* const cfg = QBtConfig::instance();
   cfg->bkg_color ( browser_demo_->get_color() );
   cfg->font_color( browser_demo_->get_font_color() );
   cfg->font      ( browser_demo_->get_font() );
   cfg->chg_color ( chg_color_demo_->get_color() );
   cfg->add_color ( add_color_demo_->get_color() );
   cfg->del_color ( del_color_demo_->get_color() );
   
   cfg->save_data();
   QBtEventsController::instance()->send_event( QBtEvent::BROWSER_CFG_CHANGED );
}
// end of apply
