/*
** Beaver's an Early AdVanced EditoR
** (C) 1999-2000 Marc Bevand, Damien Terrier and Emmanuel Turquin
**
** prefs.c
**
** Author<s>:   Emmanuel Turquin (aka "Ender") <turqui_e@epita.fr>
** Latest update: Wed Jan 10 20:30:44 2001
** Description:   Beaver preferences tool source
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <gtk/gtk.h>
#include <string.h>
#include <sys/stat.h>
#include "interface.h"
#include "msgbar.h"
#include "conf.h"
#include "editor.h"
#include "struct.h"
#include "main.h"
#include "filesops.h"
#include "prefs.h"


extern GtkWidget *MainWindow;
extern GtkWidget *MainNotebook;
extern GArray *FileProperties;
extern gint OpenedFilesCnt;
extern t_settings Settings;
static GtkWidget *example_text;

/* Makes sure that the setting values are sane */

static void normalize_settings (t_settings *set)
{
  PangoFontDescription *font_desc;
  
  font_desc = pango_font_description_from_string (set->font);
  if (pango_font_description_get_size (font_desc) == 0)
  {
    // bad font, let's reset it to something sane
    set->font = g_strdup ("Courier 12");
  }
  pango_font_description_free (font_desc);
}

t_settings init_settings (void)
{
  t_settings set;

  set.recent_files = get_int_conf ("General/RecentFiles/MaxNb");
  set.recent_files = MIN (set.recent_files, MAX_POSSIBLE_RECENT_FILES);
  set.main_window_size_autosave =
    get_bool_conf ("General/Window/Autosave");
  set.main_window_width = get_int_conf ("General/Window/Width");
  set.main_window_height = get_int_conf ("General/Window/Height");
  set.msgbar_display = get_bool_conf ("General/MsgBar/Display");
  set.msgbar_interval = get_int_conf ("General/MsgBar/Interval");
  set.toggle_wordwrap = get_bool_conf ("General/Editor/Wordwrap");
  set.toolbar_display = get_bool_conf ("General/ToolBar/Display");
  set.max_tab_label_length = get_int_conf ("General/Tabs/LabelLength");
  set.tab_position = get_int_conf ("General/Tabs/Position");
  set.scrollbar_position = get_int_conf ("General/ScrollBar/Position");
  set.complete_window_width =
    get_int_conf ("General/CompletionPopUp/Width");
  set.complete_window_height =
    get_int_conf ("General/CompletionPopUp/Height");
  set.backup = get_bool_conf ("General/AutoSave/Backup");
  set.backup_ext = get_string_conf ("General/AutoSave/BackupExt");
  set.autosave_delay = get_int_conf ("General/AutoSave/Delay");
  set.directory = get_string_conf ("General/RecentFiles/Directory");
  set.font = get_string_conf ("General/Editor/Font");
  set.print_cmd = get_string_conf ("General/Misc/PrintCommand");
  set.wordfile = get_string_conf ("General/Editor/Wordfile");
  set.bg[0] = get_int_conf ("General/Editor/BGRed");
  set.bg[1] = get_int_conf ("General/Editor/BGGreen");
  set.bg[2] = get_int_conf ("General/Editor/BGBlue");
  set.fg[0] = get_int_conf ("General/Editor/FGRed");
  set.fg[1] = get_int_conf ("General/Editor/FGGreen");
  set.fg[2] = get_int_conf ("General/Editor/FGBlue");
  set.selected_bg[0] = get_int_conf ("General/Editor/SelectedBGRed");
  set.selected_bg[1] = get_int_conf ("General/Editor/SelectedBGGreen");
  set.selected_bg[2] = get_int_conf ("General/Editor/SelectedBGBlue");
  set.selected_fg[0] = get_int_conf ("General/Editor/SelectedFGRed");
  set.selected_fg[1] = get_int_conf ("General/Editor/SelectedFGGreen");
  set.selected_fg[2] = get_int_conf ("General/Editor/SelectedFGBlue");
  set.beep = get_bool_conf ("General/Misc/Beep");
  set.syn_high = get_bool_conf ("General/Adv/SynHigh");
  set.syn_high_depth = get_int_conf ("General/Adv/SynHighDepth");
  set.auto_indent = get_bool_conf ("General/Adv/AutoIndent");
  set.auto_correct = get_bool_conf ("General/Adv/AutoCorrect");
  
  normalize_settings (&set);
  
  return (set);
}


void set_preferences_to_disk (t_settings *set, t_colors *col)
{
  START_FCN
  if (set)
    {
      if (set -> main_window_size_autosave)
	{
	  set_int_conf ("General/Window/Width",
			MainWindow -> allocation.width);
	  set_int_conf ("General/Window/Height",
			MainWindow -> allocation.height);
	}
    }
  (void)col; /* avoid the "unused parameter" warning */ 
  END_FCN
}

void toggle_sen (GtkWidget *Widget)
{
  if (GTK_WIDGET_SENSITIVE(Widget))
    gtk_widget_set_sensitive (Widget, FALSE);
  else
    gtk_widget_set_sensitive (Widget, TRUE);
}


gboolean text_preview (GtkWidget *Widget)
{
  PangoFontDescription *desc;
  GdkColor color;
  
  desc = pango_font_description_from_string (FONT);
  gtk_widget_modify_font (Widget, desc);
  pango_font_description_free (desc);
  color.red = SELECTED_BG_RED; color.green = SELECTED_BG_GREEN; color.blue = SELECTED_BG_BLUE;
  gtk_widget_modify_base (Widget, GTK_STATE_SELECTED, &color);
  color.red = SELECTED_FG_RED; color.green = SELECTED_FG_GREEN; color.blue = SELECTED_FG_BLUE;
  gtk_widget_modify_text (Widget, GTK_STATE_SELECTED, &color);
  color.red = BG_RED; color.green = BG_GREEN; color.blue = BG_BLUE;
  gtk_widget_modify_base (Widget, GTK_STATE_NORMAL, &color);
  color.red = FG_RED; color.green = FG_GREEN; color.blue = FG_BLUE;
  gtk_widget_modify_text (Widget, GTK_STATE_NORMAL, &color);
  
  return FALSE;
}


void apply_font (GtkFontSelectionDialog *fsd)
{
  PangoFontDescription *desc;
  int i;
  
  g_free (Settings.font);
  Settings.font = gtk_font_selection_dialog_get_font_name (fsd);
  set_string_conf ("General/Editor/Font", Settings.font);
  text_preview (example_text);
  desc = pango_font_description_from_string (Settings.font);
  for (i = 0; i < OpenedFilesCnt; i++)
  {
    gtk_widget_modify_font (FPROPS(i, Text), desc);
  }
  pango_font_description_free (desc);
}


void apply_wordfile_path (GtkWidget *filesel_button, GtkWidget *Widget)
{
  GtkWidget *filesel;
  const gchar *FileName;
  struct stat Stats;

  filesel = gtk_widget_get_toplevel (filesel_button);
  FileName = gtk_file_selection_get_filename (GTK_FILE_SELECTION(filesel));
  if (stat (FileName, &Stats) == -1) return;
  if ((Stats.st_mode & S_IFMT) == S_IFDIR) return;
  gtk_entry_set_text
  (GTK_ENTRY
   (gtk_container_children
    (GTK_CONTAINER(Widget -> parent)) -> next -> data), FileName);
  gtk_widget_destroy (filesel);
}


void apply_font_button (GtkWidget *Button)
{
  gchar *Text1, *Text2;

  Text1 = g_strndup (Settings.font, 40);
  Text2 = g_strconcat (Text1, "...", NULL);
  gtk_label_set_text (GTK_LABEL(GTK_BIN(Button) -> child), Text2);
  g_free (Text1);
  g_free (Text2);
}


void apply_color_button (GtkWidget *Widget, t_widgint *Data)
{
  GtkStyle *Style;
  guint16 Colors[3];
  gint i;
  
  if (Widget)
    {
      GdkColor color;
      
      gtk_color_selection_get_current_color
	(GTK_COLOR_SELECTION
	 (((GtkColorSelectionDialog *)
	   gtk_widget_get_toplevel(Widget)) -> colorsel), &color);
      Colors[0] = color.red;
      Colors[1] = color.green;
      Colors[2] = color.blue;
      switch (Data -> op)
	{
	case 1:
	  for (i = 0; i <= 2; i++)
	  {
	    Settings.fg[i] = Colors[i];
	  }
	  set_int_conf ("General/Editor/FGRed", Settings.fg[0]);
	  set_int_conf ("General/Editor/FGGreen", Settings.fg[1]);
	  set_int_conf ("General/Editor/FGBlue", Settings.fg[2]);
	  for (i = 0; i < OpenedFilesCnt; i++)
	  {
	    gtk_widget_modify_text (FPROPS(i, Text), GTK_STATE_NORMAL, &color);
	  }
	  break;
	case 2:
	  for (i = 0; i <= 2; i++)
	  {
	    Settings.bg[i] = Colors[i];
	  }
	  set_int_conf ("General/Editor/BGRed", Settings.bg[0]);
	  set_int_conf ("General/Editor/BGGreen", Settings.bg[1]);
	  set_int_conf ("General/Editor/BGBlue", Settings.bg[2]);
	  for (i = 0; i < OpenedFilesCnt; i++)
	  {
	    gtk_widget_modify_base (FPROPS(i, Text), GTK_STATE_NORMAL, &color);
	  }
	  break;
	case 3:
	  for (i = 0; i <= 2; i++)
	  {
	    Settings.selected_fg[i] = Colors[i];
	  }
	  set_int_conf ("General/Editor/SelectedFGRed", Settings.selected_fg[0]);
	  set_int_conf ("General/Editor/SelectedFGGreen", Settings.selected_fg[1]);
	  set_int_conf ("General/Editor/SelectedFGBlue", Settings.selected_fg[2]);
	  for (i = 0; i < OpenedFilesCnt; i++)
	  {
	    gtk_widget_modify_text (FPROPS(i, Text), GTK_STATE_SELECTED, &color);
	  }
	  break;
	case 4:
	  for (i = 0; i <= 2; i++)
	  {
	    Settings.selected_bg[i] = Colors[i];
	  }
	  set_int_conf ("General/Editor/SelectedBGRed", Settings.selected_bg[0]);
	  set_int_conf ("General/Editor/SelectedBGGreen", Settings.selected_bg[1]);
	  set_int_conf ("General/Editor/SelectedBGBlue", Settings.selected_bg[2]);
	  for (i = 0; i < OpenedFilesCnt; i++)
	  {
	    gtk_widget_modify_base (FPROPS(i, Text), GTK_STATE_SELECTED, &color);
	  }
	  break;
	}
	text_preview (example_text);
    }
  else
    {
      switch (Data -> op)
	{
	case 1:
	  for (i = 0; i <= 2; i++)
	    Colors[i] = Settings.fg[i];
	  break;
	case 2:
	  for (i = 0; i <= 2; i++)
	    Colors[i] = Settings.bg[i];
	  break;
	case 3:
	  for (i = 0; i <= 2; i++)
	    Colors[i] = Settings.selected_fg[i];
	  break;
	case 4:
	  for (i = 0; i <= 2; i++)
	    Colors[i] = Settings.selected_bg[i];
	  break;
	}
    }
  Style = gtk_style_copy (gtk_widget_get_style
			  (GTK_BIN(Data -> widget) -> child));
  Style -> base[GTK_STATE_NORMAL].red = Colors[0];
  Style -> base[GTK_STATE_NORMAL].green = Colors[1];
  Style -> base[GTK_STATE_NORMAL].blue = Colors[2];
  gtk_widget_set_style (GTK_BIN(Data -> widget) -> child, Style);
}


void refresh_prefs (GtkWidget *Widget, gchar *Data)
{
  int i;
  
  if (!strcmp (Data, "save_win_size"))
  {
    Settings.main_window_size_autosave = TRUE;
    set_bool_conf ("General/Window/Autosave", TRUE);
  }
  else if (!strcmp (Data, "fix_win_size"))
  {
    Settings.main_window_size_autosave = FALSE;
    set_bool_conf ("General/Window/Autosave", FALSE);
  }
  else if (!strcmp (Data, "win_width"))
  {
    Settings.main_window_width = gtk_spin_button_get_value_as_int
      (GTK_SPIN_BUTTON(Widget));
    set_int_conf ("General/Window/Width", Settings.main_window_width);
  }
  else if (!strcmp (Data, "win_height"))
  {
    Settings.main_window_height = gtk_spin_button_get_value_as_int
      (GTK_SPIN_BUTTON(Widget));
    set_int_conf ("General/Window/Height", Settings.main_window_height);
  }
  else if (!strcmp (Data, "tab_pos_1"))
  {
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				    (gtk_item_factory_get_widget
				     (MainFactory,
				      "<main>/View/Doc Tabs/Top")),
				    TRUE);
  }
  else if (!strcmp (Data, "tab_pos_2"))
  {
    Settings.tab_position = 2;
    set_int_conf ("General/Tabs/Position", 2);
    gtk_notebook_set_tab_pos (GTK_NOTEBOOK(MainNotebook), GTK_POS_BOTTOM);
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				    (gtk_item_factory_get_widget
				     (MainFactory,
				      "<main>/View/Doc Tabs/Bottom")),
				    TRUE);
  }
  else if (!strcmp (Data, "tab_pos_3"))
  {
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				    (gtk_item_factory_get_widget
				     (MainFactory,
				      "<main>/View/Doc Tabs/Left")),
				    TRUE);
  }
  else if (!strcmp (Data, "tab_pos_4"))
  {
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				    (gtk_item_factory_get_widget
				     (MainFactory,
				      "<main>/View/Doc Tabs/Right")),
				    TRUE);
  }
  else if (!strcmp (Data, "sb_pos_1"))
  {
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				    (gtk_item_factory_get_widget
				     (MainFactory,
				      "<main>/View/Scrollbar/Left")),
				    TRUE);
  }
  else if (!strcmp (Data, "sb_pos_2"))
  {
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				    (gtk_item_factory_get_widget
				     (MainFactory,
				      "<main>/View/Scrollbar/Right")),
				    TRUE);
  }
  else if (!strcmp (Data, "tab_len"))
  {
    Settings.max_tab_label_length = gtk_spin_button_get_value_as_int
      (GTK_SPIN_BUTTON(Widget));
    set_int_conf ("General/Tabs/LabelLength", Settings.max_tab_label_length);
    for (i = 0; i < OpenedFilesCnt; i++)
    {
      set_label (GTK_NOTEBOOK (MainNotebook), i);
    }
  }
  else if (!strcmp (Data, "msg_bar"))
    {
      if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(Widget)))
      {
        gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				    (gtk_item_factory_get_widget
				     (MainFactory,
				      "<main>/View/Statusbar")),
				    TRUE);
      }
      else
      {
        gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				    (gtk_item_factory_get_widget
				     (MainFactory,
				      "<main>/View/Statusbar")),
				    FALSE);
      }
    }
  else if (!strcmp (Data, "msg_len"))
  {
    Settings.msgbar_interval = gtk_spin_button_get_value_as_int
      (GTK_SPIN_BUTTON(Widget));
    set_int_conf ("General/MsgBar/Interval", Settings.msgbar_interval);
  }
  else if (!strcmp (Data, "beep"))
    {
      if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(Widget)))
      {
	Settings.beep = TRUE;
      }
      else
      {
	Settings.beep = FALSE;
      }
      
      set_bool_conf ("General/Misc/Beep", Settings.beep);
    }
  else if (!strcmp (Data, "print_cmd"))
  {
    g_free (Settings.print_cmd);
    Settings.print_cmd = g_strdup (gtk_entry_get_text (GTK_ENTRY(Widget)));
    set_string_conf ("General/Misc/PrintCommand", Settings.print_cmd);
  }
  else if (!strcmp (Data, "wordwrap"))
    {
      if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(Widget)))
      {
        gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				    (gtk_item_factory_get_widget
				     (MainFactory,
				      "<main>/Settings/Word-wrap")),
				    TRUE);
      }
      else
      {
        gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM
				    (gtk_item_factory_get_widget
				     (MainFactory,
				      "<main>/Settings/Word-wrap")),
				    FALSE);
      }
      
      set_bool_conf ("General/Editor/Wordwrap", Settings.toggle_wordwrap);
    }
  else if (!strncmp (Data, "color", 5))
    {
      gdouble colors[3];
      t_widgint *col_but;
      GtkColorSelectionDialog *csd;

      col_but = g_malloc (sizeof(t_widgint));
      col_but -> widget = Widget;
      switch (Data[5] - '0')
	{
	  gint i;
	 
	case 1:
	  col_but -> op = 1;
	  for (i = 0; i <= 2; i++)
	    colors[i] = (gdouble)Settings.fg[i]/0xffff;
	  break;
	case 2:
	  col_but -> op = 2;
	  for (i = 0; i <= 2; i++)
	    colors[i] = (gdouble)Settings.bg[i]/0xffff;
	  break;
	case 3:
	  col_but -> op = 3;
	  for (i = 0; i <= 2; i++)
	    colors[i] = (gdouble)Settings.selected_fg[i]/0xffff;
	  break;
	case 4:
	  col_but -> op = 4;
	  for (i = 0; i <= 2; i++)
	    colors[i] = (gdouble)Settings.selected_bg[i]/0xffff;
	  break;
	}
      csd = (GtkColorSelectionDialog *)gtk_color_selection_dialog_new
	("Select Color");
	gtk_window_set_modal(GTK_WINDOW(csd),TRUE);
      g_signal_connect_swapped (G_OBJECT(csd), "delete_event",
				 (GtkSignalFunc) gtk_widget_destroy,
				 G_OBJECT(csd));
      g_signal_connect_swapped (G_OBJECT(csd), "destroy",
				 (GtkSignalFunc) gtk_widget_destroy,
				 G_OBJECT(csd));
      gtk_color_selection_set_color (GTK_COLOR_SELECTION(csd -> colorsel),
				     colors);
      g_signal_connect (G_OBJECT(csd -> ok_button), "clicked",
			  (GtkSignalFunc)apply_color_button, col_but);
      g_signal_connect_swapped (G_OBJECT(csd -> ok_button), "clicked",
				 (GtkSignalFunc)gtk_widget_destroy,
				 G_OBJECT(csd));
      g_signal_connect_swapped (G_OBJECT(csd -> cancel_button), "clicked",
				 (GtkSignalFunc)gtk_widget_destroy,
				 G_OBJECT(csd));
      gtk_widget_hide (csd -> help_button);
      gtk_widget_show (GTK_WIDGET(csd));
      print_msg ("Display Color selection window...");
    }
  else if (!strcmp (Data, "font"))
    {
      GtkFontSelectionDialog *fsd;

      fsd = (GtkFontSelectionDialog *)gtk_font_selection_dialog_new
	("Select Font");
	  gtk_window_set_modal(GTK_WINDOW(fsd),TRUE);
      g_signal_connect_swapped (G_OBJECT(fsd), "delete_event",
				 (GtkSignalFunc) gtk_widget_destroy,
				 G_OBJECT(fsd));
      g_signal_connect_swapped (G_OBJECT(fsd), "destroy",
				 (GtkSignalFunc) gtk_widget_destroy,
				 G_OBJECT(fsd));
      gtk_font_selection_dialog_set_font_name (fsd, Settings.font);
      g_signal_connect_swapped (G_OBJECT(fsd -> ok_button), "clicked",
				 (GtkSignalFunc)apply_font, G_OBJECT(fsd));
      g_signal_connect_swapped (G_OBJECT(fsd -> ok_button), "clicked",
				 (GtkSignalFunc)apply_font_button,
				 G_OBJECT(Widget));
      g_signal_connect_swapped (G_OBJECT(fsd -> ok_button), "clicked",
				 (GtkSignalFunc)gtk_widget_destroy,
				 G_OBJECT(fsd));
      g_signal_connect_swapped (G_OBJECT(fsd -> cancel_button), "clicked",
				 (GtkSignalFunc)gtk_widget_destroy,
				 G_OBJECT(fsd));
      gtk_widget_show (GTK_WIDGET(fsd));
      print_msg ("Display Font selection window...");
    }
  else if (!strcmp (Data, "backup"))
    {
      if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(Widget)))
      {
	Settings.backup = TRUE;
      }
      else
      {
	Settings.backup = FALSE;
      }
      
      set_bool_conf ("General/AutoSave/Backup", Settings.backup);
    }
  else if (!strcmp (Data, "backup_ext"))
    {
      if (strlen(gtk_entry_get_text (GTK_ENTRY(Widget))))
      {
      	g_free (Settings.backup_ext);
	Settings.backup_ext = g_strdup(gtk_entry_get_text (GTK_ENTRY(Widget)));
	set_string_conf ("General/AutoSave/BackupExt", Settings.backup_ext);
      }
    }
  else if (!strcmp (Data, "autosave"))
  {
    Settings.autosave_delay = gtk_spin_button_get_value_as_int
      (GTK_SPIN_BUTTON(Widget));
    set_int_conf ("General/AutoSave/Delay", Settings.autosave_delay);
    autosave (Settings.autosave_delay);
  }
  else if (!strcmp (Data, "recent_files"))
  {
    Settings.recent_files = gtk_spin_button_get_value_as_int
      (GTK_SPIN_BUTTON(Widget));
    set_int_conf ("General/RecentFiles/MaxNb", Settings.recent_files);
    /*display_recent_files ();*/
  }
  else if (!strcmp (Data, "wordfile"))
    {
      if (strlen(gtk_entry_get_text (GTK_ENTRY(Widget))))
      {
      	g_free (Settings.wordfile);
	Settings.wordfile = g_strdup(gtk_entry_get_text (GTK_ENTRY(Widget)));
	set_string_conf ("General/Editor/Wordfile", Settings.wordfile);
      }
    }
  else if (!strcmp (Data, "word_browse"))
    {
      GtkWidget *FileSelector;
      GtkWidget *Button;
      
      FileSelector = gtk_file_selection_new ("Wordfile Path");
      gtk_window_set_modal(GTK_WINDOW(FileSelector),TRUE);
      gtk_file_selection_set_filename (GTK_FILE_SELECTION(FileSelector),
				       Settings.wordfile);
      g_signal_connect_swapped (G_OBJECT(FileSelector), "delete_event",
				 (GtkSignalFunc)gtk_widget_destroy,
				 G_OBJECT(FileSelector));
      g_signal_connect_swapped (G_OBJECT(FileSelector), "destroy_event",
				 (GtkSignalFunc)gtk_widget_destroy,
				 G_OBJECT(FileSelector));
      Button = GTK_FILE_SELECTION(FileSelector) -> ok_button;
      g_signal_connect (G_OBJECT(Button), "clicked",
			  (GtkSignalFunc)apply_wordfile_path,
			  Widget);
      Button = GTK_FILE_SELECTION (FileSelector) -> cancel_button;
      g_signal_connect_swapped (G_OBJECT(Button), "clicked",
				 (GtkSignalFunc)gtk_widget_destroy,
				 G_OBJECT(FileSelector));
      gtk_widget_show (FileSelector);
      print_msg ("Display Wordfile selection window...");
    }
  else if (!strcmp (Data, "comp_width"))
  {
    Settings.complete_window_width = gtk_spin_button_get_value_as_int
      (GTK_SPIN_BUTTON(Widget));
    set_int_conf ("General/CompletionPopUp/Width", Settings.complete_window_width);
  }
  else if (!strcmp (Data, "comp_height"))
  {
    Settings.complete_window_height = gtk_spin_button_get_value_as_int
      (GTK_SPIN_BUTTON(Widget));
    set_int_conf ("General/CompletionPopUp/Height", Settings.complete_window_height);
  }
  else if (!strcmp (Data, "syn_high"))
    {
      if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(Widget)))
      {
	Settings.syn_high = TRUE;
      }
      else
      {
	Settings.syn_high = FALSE;
      }
      set_bool_conf ("General/Adv/SynHigh", Settings.syn_high);
    }
  else if (!strcmp (Data, "syn_high_depth"))
    {
      Settings.syn_high_depth = gtk_spin_button_get_value_as_int
	(GTK_SPIN_BUTTON(Widget));
      set_int_conf ("General/Adv/SynHighDepth", Settings.syn_high_depth);
    }
  else if (!strcmp (Data, "auto_indent"))
    {
      if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(Widget)))
      {
	Settings.auto_indent = TRUE;
      }
      else
      {
	Settings.auto_indent = FALSE;
      }
      
      set_bool_conf ("General/Adv/AutoIndent", Settings.auto_indent);
    }
  else if (!strcmp (Data, "auto_correct"))
    {
      if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(Widget)))
      {
	Settings.auto_correct = TRUE;
      }
      else
      {
	Settings.auto_correct = FALSE;
      }
      
      set_bool_conf ("General/Adv/AutoCorrect", Settings.auto_correct);
    }
}


void display_general (GtkNotebook *Notebook)
{
  GtkWidget *VBox, *FrameVBox, *FrameHBox;
  GtkWidget *Frame;
  GtkWidget *Table;
  GtkWidget *Label;
  GSList *Group;
  GtkWidget *Button;
  GtkWidget *Menu;
  GtkWidget *MenuItem;
  GtkWidget *Entry;
  GtkObject *Size;

  VBox = gtk_vbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER(VBox), 10);

  Frame = gtk_frame_new ("Startup Window Size");
  gtk_box_pack_start (GTK_BOX(VBox), Frame, FALSE, FALSE, 0);
  FrameVBox = gtk_vbox_new (FALSE, 0);
  FrameHBox = gtk_hbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER(FrameVBox), 5);
  gtk_container_add (GTK_CONTAINER(Frame), FrameVBox);
  Button = gtk_radio_button_new_with_mnemonic (NULL, "Save when you _quit");
  g_signal_connect_swapped (G_OBJECT(Button), "toggled",
			     (GtkSignalFunc)toggle_sen, G_OBJECT(FrameHBox));
  g_signal_connect (G_OBJECT(Button), "toggled",
		      (GtkSignalFunc)refresh_prefs, "save_win_size");
  gtk_box_pack_start (GTK_BOX(FrameVBox), Button, FALSE, FALSE, 0);
  Group = gtk_radio_button_group (GTK_RADIO_BUTTON(Button));
  Button = gtk_radio_button_new_with_mnemonic (Group, "_Fix the size");
  g_signal_connect (G_OBJECT(Button), "toggled",
		      (GtkSignalFunc)refresh_prefs, "fix_win_size");
  gtk_box_pack_start (GTK_BOX(FrameVBox), Button, FALSE, FALSE, 0);
  if (!Settings.main_window_size_autosave)
    {
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(Button), TRUE);
      gtk_widget_set_sensitive (FrameHBox, TRUE);
    }
  else
      gtk_widget_set_sensitive (FrameHBox, FALSE);
  gtk_box_pack_start (GTK_BOX(FrameVBox), FrameHBox, FALSE, FALSE, 5);
  Label = gtk_label_new_with_mnemonic ("_Width:");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Label, FALSE, FALSE, 5);
  Size = gtk_adjustment_new (Settings.main_window_width, 10,
			     gdk_screen_width (), 1, 5, 0);
  Button = gtk_spin_button_new (GTK_ADJUSTMENT(Size), 1, 0);
  gtk_label_set_mnemonic_widget (GTK_LABEL (Label), Button);
  gtk_widget_set_size_request (Button, 60, -1);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON(Button), TRUE);
  gtk_entry_set_max_length (GTK_ENTRY(Button), 4);
  g_signal_connect (G_OBJECT(Button), "value-changed",
		      (GtkSignalFunc)refresh_prefs, "win_width");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Button, FALSE, FALSE, 0);
  Label = gtk_label_new ("");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Label, FALSE, FALSE, 40);
  Label = gtk_label_new_with_mnemonic ("_Height:");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Label, FALSE, FALSE, 5);
  Size = gtk_adjustment_new (Settings.main_window_height, 10,
			     gdk_screen_height (), 1, 5, 0);
  Button = gtk_spin_button_new (GTK_ADJUSTMENT(Size), 1, 0);
  gtk_label_set_mnemonic_widget (GTK_LABEL (Label), Button);
  gtk_widget_set_size_request (Button, 60, -1); 
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON(Button), TRUE);
  gtk_entry_set_max_length (GTK_ENTRY(Button), 4);
  g_signal_connect (G_OBJECT(Button), "value-changed",
		      (GtkSignalFunc)refresh_prefs, "win_height");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Button, FALSE, FALSE, 0);

  Frame = gtk_frame_new ("Tabs");
  gtk_box_pack_start (GTK_BOX(VBox), Frame, FALSE, FALSE, 5);
  Table = gtk_table_new (2, 2, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER(Table), 5);
  gtk_table_set_row_spacings (GTK_TABLE(Table), 5);
  gtk_table_set_col_spacings (GTK_TABLE(Table), 5);
  gtk_container_add (GTK_CONTAINER(Frame), Table);
  FrameHBox = gtk_hbox_new (FALSE, 0);
  gtk_table_attach_defaults (GTK_TABLE(Table), FrameHBox, 0, 1, 0, 1);
  Label = gtk_label_new_with_mnemonic ("_Tabs position");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Label, FALSE, FALSE, 5);
  FrameHBox = gtk_hbox_new (FALSE, 0);
  gtk_table_attach_defaults (GTK_TABLE(Table), FrameHBox, 0, 1, 1, 2);
  Menu = gtk_menu_new ();
  MenuItem = gtk_menu_item_new_with_label ("Top");
  g_signal_connect (G_OBJECT(MenuItem), "activate",
		      (GtkSignalFunc)refresh_prefs, "tab_pos_1");
  gtk_menu_append (GTK_MENU(Menu), MenuItem);
  MenuItem = gtk_menu_item_new_with_label ("Bottom");
  g_signal_connect (G_OBJECT(MenuItem), "activate",
		      (GtkSignalFunc)refresh_prefs, "tab_pos_2");
  gtk_menu_append (GTK_MENU(Menu), MenuItem);
  MenuItem = gtk_menu_item_new_with_label ("Left");
  g_signal_connect (G_OBJECT(MenuItem), "activate",
		      (GtkSignalFunc)refresh_prefs, "tab_pos_3");
  gtk_menu_append (GTK_MENU(Menu), MenuItem);
  MenuItem = gtk_menu_item_new_with_label ("Right");
  g_signal_connect (G_OBJECT(MenuItem), "activate",
		      (GtkSignalFunc)refresh_prefs, "tab_pos_4");
  gtk_menu_append (GTK_MENU(Menu), MenuItem);
  Button = gtk_option_menu_new ();
  gtk_label_set_mnemonic_widget (GTK_LABEL (Label), Button);
  gtk_option_menu_set_menu (GTK_OPTION_MENU(Button), Menu);
  gtk_option_menu_set_history (GTK_OPTION_MENU(Button),
			       Settings.tab_position - 1);
  gtk_table_attach_defaults (GTK_TABLE(Table), Button, 1, 2, 0, 1);
  Label = gtk_label_new_with_mnemonic ("Maximum tab _label width");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Label, FALSE, FALSE, 5);
  Size = gtk_adjustment_new (Settings.max_tab_label_length, 0, 99, 1, 5, 0);
  Button = gtk_spin_button_new (GTK_ADJUSTMENT(Size), 1, 0);
  gtk_label_set_mnemonic_widget (GTK_LABEL (Label), Button);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON(Button), TRUE);
  gtk_entry_set_max_length (GTK_ENTRY(Button), 2);
  g_signal_connect (G_OBJECT(Button), "value-changed",
		      (GtkSignalFunc)refresh_prefs, "tab_len");
  gtk_table_attach_defaults (GTK_TABLE(Table), Button, 1, 2, 1, 2);

  Frame = gtk_frame_new ("Statusbar");
  gtk_box_pack_start (GTK_BOX(VBox), Frame, FALSE, FALSE, 0);
  Table = gtk_table_new (2, 2, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER(Table), 5);
  gtk_table_set_row_spacings (GTK_TABLE(Table), 5);
  gtk_table_set_col_spacings (GTK_TABLE(Table), 5);
  gtk_container_add (GTK_CONTAINER(Frame), Table);
  Button = gtk_check_button_new_with_mnemonic ("Display _statusbar");
  if (Settings.msgbar_display)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(Button), TRUE);
  g_signal_connect (G_OBJECT(Button), "toggled",
		      (GtkSignalFunc)refresh_prefs, "msg_bar");
  gtk_table_attach_defaults (GTK_TABLE(Table), Button, 0, 1, 0, 1);
  FrameHBox = gtk_hbox_new (FALSE, 0);
  gtk_table_attach_defaults (GTK_TABLE(Table), FrameHBox, 0, 1, 1, 2);
  Label = gtk_label_new_with_mnemonic ("_Message display time (in ms)");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Label, FALSE, FALSE, 5);
  Size = gtk_adjustment_new (Settings.msgbar_interval, 0, 9999, 1, 10, 0);
  Button = gtk_spin_button_new (GTK_ADJUSTMENT(Size), 1, 0);
  gtk_label_set_mnemonic_widget (GTK_LABEL (Label), Button);
  gtk_entry_set_max_length (GTK_ENTRY(Button), 4);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON(Button), TRUE);
  g_signal_connect (G_OBJECT(Button), "value-changed",
		      (GtkSignalFunc)refresh_prefs, "msg_len");
  gtk_table_attach_defaults (GTK_TABLE(Table), Button, 1, 2, 1, 2);

  Frame = gtk_frame_new ("Miscellaneous");
  gtk_box_pack_start (GTK_BOX(VBox), Frame, FALSE, FALSE, 5);
  Table = gtk_table_new (2, 2, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER(Table), 5);
  gtk_table_set_row_spacings (GTK_TABLE(Table), 5);
  gtk_table_set_col_spacings (GTK_TABLE(Table), 5);
  gtk_container_add (GTK_CONTAINER(Frame), Table);
  Button = gtk_check_button_new_with_mnemonic ("Enable _beep");
  if (Settings.beep)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(Button), TRUE);
  g_signal_connect (G_OBJECT(Button), "toggled",
		      (GtkSignalFunc)refresh_prefs, "beep");
  gtk_table_attach_defaults (GTK_TABLE(Table), Button, 0, 1, 0, 1);
  FrameHBox = gtk_hbox_new (FALSE, 0);
  gtk_table_attach_defaults (GTK_TABLE(Table), FrameHBox, 0, 1, 1, 2);
  Label = gtk_label_new_with_mnemonic ("_Print command:");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Label, FALSE, FALSE, 5);
  Entry = gtk_entry_new ();
  gtk_label_set_mnemonic_widget (GTK_LABEL (Label), Entry);
  gtk_entry_set_text (GTK_ENTRY(Entry), Settings.print_cmd);
  g_signal_connect (G_OBJECT(Entry), "changed",
		      (GtkSignalFunc)refresh_prefs, "print_cmd");
  gtk_table_attach_defaults (GTK_TABLE(Table), Entry, 1, 2, 1, 2);

  Label = gtk_label_new ("General");
  gtk_notebook_append_page (Notebook, VBox, Label);
}


void display_document (GtkNotebook *Notebook)
{
  GtkWidget *VBox, *FrameHBox;
  GtkWidget *Frame;
  GtkWidget *Table;
  GtkWidget *Label;
  GtkWidget *Button;
  t_widgint *ColBut;
  GtkWidget *Menu;
  GtkWidget *MenuItem;
  GtkWidget *Entry;
  gchar *Text;

  VBox = gtk_vbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER(VBox), 10);

  Frame = gtk_frame_new ("Global Preferences");
  gtk_box_pack_start (GTK_BOX(VBox), Frame, FALSE, FALSE, 5);
  Table = gtk_table_new (2, 2, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER(Table), 5);
  gtk_table_set_row_spacings (GTK_TABLE(Table), 5);
  gtk_table_set_col_spacings (GTK_TABLE(Table), 5);
  gtk_container_add (GTK_CONTAINER(Frame), Table);
  Button = gtk_check_button_new_with_mnemonic ("_Word-wrap");
  if (Settings.toggle_wordwrap)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(Button), TRUE);
  g_signal_connect (G_OBJECT(Button), "toggled",
		      (GtkSignalFunc)refresh_prefs, "wordwrap");
  gtk_table_attach_defaults (GTK_TABLE(Table), Button, 0, 1, 0, 1); 
  FrameHBox = gtk_hbox_new (FALSE, 0);
  gtk_table_attach_defaults (GTK_TABLE(Table), FrameHBox, 0, 1, 1, 2);
  Label = gtk_label_new_with_mnemonic ("_Scrollbar position");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Label, FALSE, FALSE, 5);
  Menu = gtk_menu_new ();
  MenuItem = gtk_menu_item_new_with_label ("Left");
  g_signal_connect (G_OBJECT(MenuItem), "activate",
		      (GtkSignalFunc)refresh_prefs, "sb_pos_1");
  gtk_menu_append (GTK_MENU(Menu), MenuItem);
  MenuItem = gtk_menu_item_new_with_label ("Right");
  g_signal_connect (G_OBJECT(MenuItem), "activate",
		      (GtkSignalFunc)refresh_prefs, "sb_pos_2");
  gtk_menu_append (GTK_MENU(Menu), MenuItem);
  Button = gtk_option_menu_new ();
  gtk_label_set_mnemonic_widget (GTK_LABEL (Label), Button);
  gtk_option_menu_set_menu (GTK_OPTION_MENU(Button), Menu);
  gtk_option_menu_set_history (GTK_OPTION_MENU(Button),
			       Settings.scrollbar_position - 1);
  gtk_table_attach_defaults (GTK_TABLE(Table), Button, 1, 2, 1, 2);

  Frame = gtk_frame_new ("Colors and Font");
  gtk_box_pack_start (GTK_BOX(VBox), Frame, FALSE, FALSE, 0);
  Table = gtk_table_new (5, 3, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER(Table), 5);
  gtk_table_set_row_spacings (GTK_TABLE(Table), 5);
  gtk_table_set_col_spacings (GTK_TABLE(Table), 5);
  gtk_container_add (GTK_CONTAINER(Frame), Table);
  Label = gtk_label_new_with_mnemonic ("_Font :");
  gtk_table_attach_defaults (GTK_TABLE(Table), Label, 0, 1, 0, 1);
  Button = gtk_button_new_with_label ("");
  gtk_label_set_mnemonic_widget (GTK_LABEL (Label), Button);
  apply_font_button (Button);
  g_signal_connect (G_OBJECT(Button), "clicked",
		      (GtkSignalFunc)refresh_prefs, "font");
  gtk_table_attach_defaults (GTK_TABLE(Table), Button, 1, 3, 0, 1);
  FrameHBox = gtk_hbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER(FrameHBox), 10);
  gtk_table_attach_defaults (GTK_TABLE(Table), FrameHBox, 2, 3, 1, 5);
  example_text = gtk_text_view_new ();
  gtk_widget_set_size_request (example_text, 150, 140);
  gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW(example_text), GTK_WRAP_WORD);
  Text = g_strdup ("This is some sample text. Note that you may need to click "
		   "on it to refresh display after color or font changes.");
  text_preview (example_text);
  gtk_text_buffer_set_text (gtk_text_view_get_buffer(GTK_TEXT_VIEW(example_text)),
           Text, -1);
  g_free (Text);
  gtk_box_pack_start (GTK_BOX(FrameHBox), example_text, TRUE, TRUE, 0);
  ColBut = g_malloc (sizeof(t_widgint));
  ColBut -> widget = gtk_button_new ();
  ColBut -> op = 1;
  gtk_widget_set_size_request (ColBut -> widget, 40, 20);
  gtk_container_set_border_width (GTK_CONTAINER(ColBut -> widget), 5);
  Entry = gtk_text_view_new ();
  gtk_container_add (GTK_CONTAINER(ColBut -> widget), Entry);
  g_signal_connect (G_OBJECT(ColBut -> widget), "clicked",
		      (GtkSignalFunc)refresh_prefs, "color1");
  apply_color_button (NULL, ColBut);
  gtk_table_attach_defaults (GTK_TABLE(Table), ColBut -> widget, 0, 1, 1, 2);
  ColBut -> widget = gtk_button_new ();
  ColBut -> op = 2;
  gtk_widget_set_size_request (ColBut -> widget, 40, 20);
  gtk_container_set_border_width (GTK_CONTAINER(ColBut -> widget), 5);
  Entry = gtk_text_view_new ();
  gtk_container_add (GTK_CONTAINER(ColBut -> widget), Entry);
  g_signal_connect (G_OBJECT(ColBut -> widget), "clicked",
		      (GtkSignalFunc)refresh_prefs, "color2");
  apply_color_button (NULL, ColBut);
  gtk_table_attach_defaults (GTK_TABLE(Table), ColBut -> widget, 0, 1, 2, 3);
  ColBut -> widget = gtk_button_new ();
  ColBut -> op = 3;
  gtk_widget_set_size_request (ColBut -> widget, 40, 20);
  gtk_container_set_border_width (GTK_CONTAINER(ColBut -> widget), 5);
  Entry = gtk_text_view_new ();
  gtk_container_add (GTK_CONTAINER(ColBut -> widget), Entry);
  g_signal_connect (G_OBJECT(ColBut -> widget), "clicked",
		      (GtkSignalFunc)refresh_prefs, "color3");
  apply_color_button (NULL, ColBut);
  gtk_table_attach_defaults (GTK_TABLE(Table), ColBut -> widget, 0, 1, 3, 4);
  ColBut -> widget = gtk_button_new ();
  ColBut -> op = 4;
  gtk_widget_set_size_request (ColBut -> widget, 40, 20);
  gtk_container_set_border_width (GTK_CONTAINER(ColBut -> widget), 5);
  Entry = gtk_text_view_new ();
  gtk_container_add (GTK_CONTAINER(ColBut -> widget), Entry);
  g_signal_connect (G_OBJECT(ColBut -> widget), "clicked",
		      (GtkSignalFunc)refresh_prefs, "color4");
  apply_color_button (NULL, ColBut);
  gtk_table_attach_defaults (GTK_TABLE(Table), ColBut -> widget, 0, 1, 4, 5);
  FrameHBox = gtk_hbox_new (FALSE, 0);
  gtk_table_attach_defaults (GTK_TABLE(Table), FrameHBox, 1, 2, 1, 2);
  Label = gtk_label_new ("Text Foreground");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Label, FALSE, FALSE, 5);
  FrameHBox = gtk_hbox_new (FALSE, 0);
  gtk_table_attach_defaults (GTK_TABLE(Table), FrameHBox, 1, 2, 2, 3);
  Label = gtk_label_new ("Text Background");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Label, FALSE, FALSE, 5);
  FrameHBox = gtk_hbox_new (FALSE, 0);
  gtk_table_attach_defaults (GTK_TABLE(Table), FrameHBox, 1, 2, 3, 4);
  Label = gtk_label_new ("Highlighted Foreground");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Label, FALSE, FALSE, 5);
  FrameHBox = gtk_hbox_new (FALSE, 0);
  gtk_table_attach_defaults (GTK_TABLE(Table), FrameHBox, 1, 2, 4, 5);
  Label = gtk_label_new ("Highlighted Background");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Label, FALSE, FALSE, 5);

  Label = gtk_label_new ("Document");
  gtk_notebook_append_page (Notebook, VBox, Label);
}


void display_save (GtkNotebook *Notebook)
{
  GtkWidget *VBox, *FrameHBox;
  GtkWidget *Frame;
  GtkWidget *Table;
  GtkWidget *Label;
  GtkWidget *Button;
  GtkWidget *Entry;
  GtkObject *Size;

  VBox = gtk_vbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER(VBox), 10);

  Frame = gtk_frame_new ("Backup");
  gtk_box_pack_start (GTK_BOX(VBox), Frame, FALSE, FALSE, 0);
  Table = gtk_table_new (2, 2, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER(Table), 5);
  gtk_table_set_row_spacings (GTK_TABLE(Table), 5);
  gtk_table_set_col_spacings (GTK_TABLE(Table), 5);
  gtk_container_add (GTK_CONTAINER(Frame), Table);
  Button = gtk_check_button_new_with_mnemonic ("Write _backup files");
  if (Settings.backup)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(Button), TRUE);
  g_signal_connect (G_OBJECT(Button), "toggled",
		      (GtkSignalFunc)refresh_prefs, "backup");
  gtk_table_attach_defaults (GTK_TABLE(Table), Button, 0, 1, 0, 1);
  FrameHBox = gtk_hbox_new (FALSE, 0);
  gtk_table_attach_defaults (GTK_TABLE(Table), FrameHBox, 0, 1, 1, 2);
  Label = gtk_label_new_with_mnemonic ("E_xtension :");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Label, FALSE, FALSE, 5);
  Entry = gtk_entry_new ();
  gtk_label_set_mnemonic_widget (GTK_LABEL (Label), Entry);
  gtk_entry_set_text (GTK_ENTRY(Entry), Settings.backup_ext);
  g_signal_connect (G_OBJECT(Entry), "changed",
		      (GtkSignalFunc)refresh_prefs, "backup_ext");
  gtk_table_attach_defaults (GTK_TABLE(Table), Entry, 1, 2, 1, 2);

  Frame = gtk_frame_new ("Autosave");
  gtk_box_pack_start (GTK_BOX(VBox), Frame, FALSE, FALSE, 5);
  Table = gtk_table_new (1, 2, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER(Table), 5);
  gtk_table_set_row_spacings (GTK_TABLE(Table), 5);
  gtk_table_set_col_spacings (GTK_TABLE(Table), 5);
  gtk_container_add (GTK_CONTAINER(Frame), Table);
  FrameHBox = gtk_hbox_new (FALSE, 0);
  gtk_table_attach_defaults (GTK_TABLE(Table), FrameHBox, 0, 1, 0, 1);
  Label = gtk_label_new_with_mnemonic ("_Delay (s) (0 disables Autosave) :");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Label, FALSE, FALSE, 5);
  Size = gtk_adjustment_new (Settings.autosave_delay, 0, 9999, 1, 10, 0);
  Button = gtk_spin_button_new (GTK_ADJUSTMENT(Size), 1, 0);
  gtk_label_set_mnemonic_widget (GTK_LABEL (Label), Button);
  gtk_entry_set_max_length (GTK_ENTRY(Button), 4);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON(Button), TRUE);
  g_signal_connect (G_OBJECT(Button), "value-changed",
		      (GtkSignalFunc)refresh_prefs, "autosave");
  gtk_table_attach_defaults (GTK_TABLE(Table), Button, 1, 2, 0, 1);
  Frame = gtk_frame_new ("Recent Files Menu");
  gtk_box_pack_start (GTK_BOX(VBox), Frame, FALSE, FALSE, 0);
  Table = gtk_table_new (1, 2, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER(Table), 5);
  gtk_table_set_row_spacings (GTK_TABLE(Table), 5);
  gtk_table_set_col_spacings (GTK_TABLE(Table), 5);
  gtk_container_add (GTK_CONTAINER(Frame), Table);
  FrameHBox = gtk_hbox_new (FALSE, 0);
  gtk_table_attach_defaults (GTK_TABLE(Table), FrameHBox, 0, 1, 0, 1);
  Label = gtk_label_new_with_mnemonic ("_Maximum number of files :");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Label, FALSE, FALSE, 5);
  Size = gtk_adjustment_new (Settings.recent_files, 0, 50, 1, 10, 0);
  Button = gtk_spin_button_new (GTK_ADJUSTMENT(Size), 1, 0);
  gtk_label_set_mnemonic_widget (GTK_LABEL (Label), Button);
  gtk_entry_set_max_length (GTK_ENTRY(Button), 2);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON(Button), TRUE);
  g_signal_connect (G_OBJECT(Button), "value-changed",
		      (GtkSignalFunc)refresh_prefs, "recent_files");
  gtk_table_attach_defaults (GTK_TABLE(Table), Button, 1, 2, 0, 1);

  Label = gtk_label_new ("Save");
  gtk_notebook_append_page (Notebook, VBox, Label);
}


void display_advanced (GtkNotebook *Notebook)
{
  GtkWidget *VBox, *FrameHBox;
  GtkWidget *Frame;
  GtkWidget *Table;
  GtkWidget *Label;
  GtkWidget *Button;
  GtkWidget *Entry;
  GtkObject *Size;

  VBox = gtk_vbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER(VBox), 10);

  Frame = gtk_frame_new ("Wordfile Location");
  gtk_box_pack_start (GTK_BOX(VBox), Frame, FALSE, FALSE, 0);
  FrameHBox = gtk_hbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER(FrameHBox), 5);
  gtk_container_add (GTK_CONTAINER(Frame), FrameHBox);
  Label = gtk_label_new_with_mnemonic ("_Path :");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Label, FALSE, FALSE, 0);
  Entry = gtk_entry_new ();
  gtk_label_set_mnemonic_widget (GTK_LABEL (Label), Entry);
  gtk_entry_set_text (GTK_ENTRY(Entry), Settings.wordfile);
  g_signal_connect (G_OBJECT(Entry), "changed",
		      (GtkSignalFunc)refresh_prefs, "wordfile");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Entry, TRUE, TRUE, 5);
  Button = gtk_button_new_with_mnemonic ("_Browse");
  g_signal_connect (G_OBJECT(Button), "clicked",
		      (GtkSignalFunc)refresh_prefs, "word_browse");
  gtk_box_pack_end (GTK_BOX(FrameHBox), Button, FALSE, FALSE, 0);
  Frame = gtk_frame_new
    ("Syntax Highlighting, Auto-indentation and -correction");
  gtk_box_pack_start (GTK_BOX(VBox), Frame, FALSE, FALSE, 5);
  Table = gtk_table_new (2, 3, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER(Table), 5);
  gtk_table_set_row_spacings (GTK_TABLE(Table), 5);
  gtk_table_set_col_spacings (GTK_TABLE(Table), 5);
  gtk_container_add (GTK_CONTAINER(Frame), Table);
  Button = gtk_check_button_new_with_mnemonic ("Enable auto-_indentation");
  if (Settings.auto_indent)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(Button), TRUE);
  g_signal_connect (G_OBJECT(Button), "toggled",
		      (GtkSignalFunc)refresh_prefs, "auto_indent");
  gtk_table_attach_defaults (GTK_TABLE(Table), Button, 0, 1, 0, 1);
  Button = gtk_check_button_new_with_mnemonic ("Enable auto-co_rrection");
  if (Settings.auto_correct)
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(Button), TRUE);
  g_signal_connect (G_OBJECT(Button), "toggled",
		      (GtkSignalFunc)refresh_prefs, "auto_correct");
  gtk_table_attach_defaults (GTK_TABLE(Table), Button, 0, 1, 1, 2);
  FrameHBox = gtk_hbox_new (FALSE, 0);
  gtk_table_attach_defaults (GTK_TABLE(Table), FrameHBox, 0, 1, 2, 3);
  Label = gtk_label_new_with_mnemonic ("Highlighting _depth (characters) :");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Label, FALSE, FALSE, 5);
  Size = gtk_adjustment_new (Settings.syn_high_depth, 0, 99999, 1, 10, 0);
  Button = gtk_spin_button_new (GTK_ADJUSTMENT(Size), 1, 0);
  gtk_label_set_mnemonic_widget (GTK_LABEL (Label), Button);
  gtk_entry_set_max_length (GTK_ENTRY(Button), 5);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON(Button), TRUE);
  g_signal_connect (G_OBJECT(Button), "value-changed",
		      (GtkSignalFunc)refresh_prefs, "syn_high_depth");
  gtk_table_attach_defaults (GTK_TABLE(Table), Button, 1, 2, 2, 3);
  Frame = gtk_frame_new ("Completion Popup Size");
  gtk_box_pack_start (GTK_BOX(VBox), Frame, FALSE, FALSE, 5);
  FrameHBox = gtk_hbox_new (FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER(FrameHBox), 5);
  gtk_container_add (GTK_CONTAINER(Frame), FrameHBox);
  Label = gtk_label_new_with_mnemonic ("_Width:");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Label, FALSE, FALSE, 5);
  Size = gtk_adjustment_new (Settings.complete_window_width, 10,
			     gdk_screen_width (), 1, 5, 0);
  Button = gtk_spin_button_new (GTK_ADJUSTMENT(Size), 1, 0);
  gtk_label_set_mnemonic_widget (GTK_LABEL (Label), Button);
  gtk_widget_set_size_request (Button, 60, -1);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON(Button), TRUE);
  gtk_entry_set_max_length (GTK_ENTRY(Button), 4);
  g_signal_connect (G_OBJECT(Button), "value-changed",
		      (GtkSignalFunc)refresh_prefs, "comp_width");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Button, FALSE, FALSE, 0);
  Label = gtk_label_new ("");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Label, FALSE, FALSE, 40);
  Label = gtk_label_new_with_mnemonic ("_Height:");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Label, FALSE, FALSE, 5);
  Size = gtk_adjustment_new (Settings.complete_window_height, 10,
			     gdk_screen_height (), 1, 5, 0);
  Button = gtk_spin_button_new (GTK_ADJUSTMENT(Size), 1, 0);
  gtk_label_set_mnemonic_widget (GTK_LABEL (Label), Button);
  gtk_widget_set_size_request (Button, 60, -1); 
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON(Button), TRUE);
  gtk_entry_set_max_length (GTK_ENTRY(Button), 4);
  g_signal_connect (G_OBJECT(Button), "value-changed",
		      (GtkSignalFunc)refresh_prefs, "comp_height");
  gtk_box_pack_start (GTK_BOX(FrameHBox), Button, FALSE, FALSE, 0);

  Label = gtk_label_new ("Advanced");
  gtk_notebook_append_page (Notebook, VBox, Label);
}


void display_prefs (t_settings *set)
{
  GtkWidget *PrefsWindow;
  GtkWidget *PrefsNotebook;
  GtkWidget *Button;
  PrefsWindow = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW(PrefsWindow), "Beaver Preferences"); 
  gtk_window_set_policy (GTK_WINDOW(PrefsWindow), FALSE, FALSE, FALSE);
  /* this window is modal: users can't do anything with the rest of the program, while this window is active*/
  gtk_window_set_modal (GTK_WINDOW (PrefsWindow), TRUE);

  g_signal_connect_swapped (G_OBJECT(PrefsWindow), "delete-event",
			     (GtkSignalFunc) gtk_widget_destroy,
			     G_OBJECT(PrefsWindow));
  g_signal_connect_swapped (G_OBJECT (PrefsWindow), "destroy",
			     (GtkSignalFunc) gtk_widget_destroy,
			     G_OBJECT(PrefsWindow));
  PrefsNotebook = gtk_notebook_new ();
  gtk_notebook_set_homogeneous_tabs (GTK_NOTEBOOK(PrefsNotebook), TRUE);
  gtk_container_set_border_width (GTK_CONTAINER(PrefsNotebook), 10);
  /* WORK IN PROGRESS... */
  display_general (GTK_NOTEBOOK(PrefsNotebook));
  display_document (GTK_NOTEBOOK(PrefsNotebook));
  display_advanced (GTK_NOTEBOOK(PrefsNotebook));
  display_save (GTK_NOTEBOOK(PrefsNotebook));
  /* WORK IN PROGRESS... */
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(PrefsWindow) -> vbox),
		      PrefsNotebook, TRUE, TRUE, 0);
  Button = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
  g_signal_connect_swapped (G_OBJECT(Button), "clicked",
			     (GtkSignalFunc) gtk_widget_destroy,
			     G_OBJECT(PrefsWindow));
  GTK_WIDGET_SET_FLAGS (Button, GTK_CAN_DEFAULT);
  gtk_box_pack_start (GTK_BOX(GTK_DIALOG(PrefsWindow) -> action_area),
		      Button, TRUE, TRUE, 0);
  gtk_widget_grab_default (Button);
  gtk_widget_show_all (PrefsWindow);
  print_msg ("Display Preferences window...");
}
