/*
** Beaver's an Early AdVanced EditoR
** (C) 1999-2000 Marc Bevand, Damien Terrier and Emmanuel Turquin
**
** interface.h
**
** Author<s>:   Emmanuel Turquin (aka "Ender") <turqui_e@epita.fr>
** Latest update: Thu Nov  9 00:35:08 2000
** Description:   Beaver interface source header
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __INTERFACE_H__
#define __INTERFACE_H__

/* Menu entries for the main menubar and the toolbar */

#define NEW                  1
#define OPEN                 2
#define SAVE                 3
#define SAVE_ALL             4
#define SAVE_AS              5
#define PRINT                6
#define CLOSE                7
#define CLOSE_ALL            8
#define QUIT                 9
#define UNDO                10
#define REDO                11
#define CUT                 12
#define COPY                13
#define PASTE               14
#define CLEAR               15
#define SELECT_ALL          16
#define COMPLETE            17
#define FIND                18
#define REPLACE             19
#define LINE                20
#define READONLY            21
#define CONVERTER           22
#define COLOR               23
#define INSERT_TIME         24
#define TO_UPPER            25
#define TO_LOWER            26
#define CAPITALIZE          27
#define INVERT_CASE         28
#define DOS_UNIX            29
#define UNIX_DOS            30
#define DOS_MAC	            31
#define MAC_DOS	            32
#define MAC_UNIX      	    33
#define UNIX_MAC            34
#define FILE_INFO           35
#define TOOLBAR             36
#define MSGBAR              37
#define WORDWRAP            38
#define TAB_POS_TOP         39
#define TAB_POS_BOTTOM      40
#define TAB_POS_LEFT        41
#define TAB_POS_RIGHT       42
#define SCROLLBAR_POS_LEFT  43
#define SCROLLBAR_POS_RIGHT 44
#define PREFS               45
#define LANG                46
#define HELP                47
#define ABOUT               48

void menu_items_treatment (GtkWidget *Widget,
			   guint Op);
GtkWidget *menubar_new (GtkWidget *Window);
GtkWidget *popup_menu_new (void);
gboolean popup_menu_show (GtkMenu *PopUpMenu,
			  GdkEvent *Event);
void add_page_in_notebook (GtkNotebook *Notebook,
			   gchar *Filename);
void  set_label (GtkNotebook *Notebook,
		 gint CurrentPage);
void set_title (GtkNotebook *Notebook,
		GtkNotebookPage *Page,
		gint CurrentPage);
void command_line (gint argc,
		   gchar *argv[]);
void interface (gint argc,
		gchar *argv[]);
void about (void);

#endif
