// bbkeysconf - front end implementation
// vanRijn <vr@movingparts.net>
// check http://movingparts.net for more bbkeys info
// licensed under the GPL

#include <stdlib.h>
#include <ctype.h>
#include <iostream.h>
#include <fstream.h>

#include <qapplication.h>
#include <qmessagebox.h>
#include <qlayout.h>
#include <qstring.h>
#include <qmenubar.h>
#include <qfont.h>
#include <qframe.h>
#include <qlabel.h>
#include <qvbox.h>
#include <qhbox.h>
#include <qpushbutton.h>
#include <qevent.h>
#include <qfiledialog.h>
#include <qfile.h>
#include <qtextstream.h>

#include "gui.hh"

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>


FrontEnd::FrontEnd(QWidget * parent, const char *name)
:QWidget(parent, name)
{
    const char *title = "gooey bbkeys Conflaguration Device";
    const int height = 400;
    const int width = 500;
    capturing = false;

    setCaption(title);
    setFixedSize(width, height);

    // create the toplevel layout
    QBoxLayout *topLayout = new QVBoxLayout(this, 1);

    // create the menubar / add to the topLayout
    menubar = new QMenuBar(this, "menu");

    QPopupMenu *file = new QPopupMenu(menubar);
    file->insertItem("Open", this, SLOT(open()));
    file->insertItem("Save", this, SLOT(save()));
    file->insertItem("Save As", this, SLOT(saveAs()));
    file->insertSeparator();
    file->insertItem("Exit", qApp, SLOT(quit()));

    QPopupMenu *help = new QPopupMenu(menubar);
    help->insertItem("About", this, SLOT(helpscreen()));

    menubar->insertItem("File", file);
    menubar->insertSeparator();
    menubar->insertItem("Help", help);
    menubar->setMidLineWidth(1);
    menubar->setFrameStyle(QFrame::Box | QFrame::Sunken);
    menubar->setLineWidth(1);
    menubar->setSeparator(QMenuBar::InWindowsStyle);

    topLayout->setMenuBar(menubar);

    // ------------------------------------------------
    // Top label and separator
    QBoxLayout *vb = new QVBoxLayout(topLayout, 5);

    QLabel *toplabel =
	new QLabel("Welcome to Ye Olde BBKeys Conflagurator. "
		   "We do hope your stay is pleasant...",
		   this);
    toplabel->setAlignment(QLabel::AlignHCenter | QLabel::AlignVCenter);
    toplabel->setFont(QFont("helvetica", 12, 75));
    vb->addWidget(toplabel);

    QFrame *sep1 = new QFrame(this);
    sep1->setFrameStyle(QFrame::HLine | QFrame::Raised);
    sep1->setLineWidth(1);
    vb->addWidget(sep1);

    // ------------------------------------------------
    // second box--contains combobox and grab button
    QBoxLayout *hb = new QHBoxLayout(topLayout);

    QLabel *actionlabel = new QLabel(this);
    QString s;
    s.sprintf("Action:");
    actionlabel->setText(s);
    actionlabel->setAlignment(AlignCenter | AlignVCenter);
    hb->addWidget(actionlabel, 2);

    combobox = new QComboBox(FALSE, this, "read-only combo");
    // populate all our options, baybee!!
    combobox->insertItem("Close");
    combobox->insertItem("ExecCommand");
    combobox->insertItem("Lower");
    combobox->insertItem("MaximizeHorizontal");
    combobox->insertItem("MaximizeVertical");
    combobox->insertItem("MaximizeWindow");
    combobox->insertItem("Minimize");
    combobox->insertItem("NextWindow");
    combobox->insertItem("NextWorkspace");
    combobox->insertItem("PrevWindow");
    combobox->insertItem("PrevWorkspace");
    combobox->insertItem("Raise");
    combobox->insertItem("ShadeWindow");
    combobox->insertItem("StickWindow");
    combobox->insertItem("Workspace1");
    combobox->insertItem("Workspace2");
    combobox->insertItem("Workspace3");
    combobox->insertItem("Workspace4");
    combobox->insertItem("Workspace5");
    combobox->insertItem("Workspace6");
    combobox->insertItem("Workspace7");
    combobox->insertItem("Workspace8");
    combobox->insertItem("Workspace9");
    combobox->insertItem("Workspace10");
    combobox->insertItem("Workspace11");
    combobox->insertItem("Workspace12");

    combobox->insertItem("NudgeRight");
    combobox->insertItem("NudgeLeft");
    combobox->insertItem("NudgeUp");
    combobox->insertItem("NudgeDown");
    combobox->insertItem("BigNudgeRight");
    combobox->insertItem("BigNudgeLeft");
    combobox->insertItem("BigNudgeUp");
    combobox->insertItem("BigNudgeDown");
    combobox->insertItem("HorizontalIncrement");
    combobox->insertItem("VerticalIncrement");
    combobox->insertItem("HorizontalDecrement");
    combobox->insertItem("VerticalDecrement");

    hb->addWidget(combobox, 8);

    cmdgrab = new QPushButton("Grab Key.", this);
    connect(cmdgrab, SIGNAL(clicked()), this, SLOT(grabKey()));

    hb->addSpacing(5);
    hb->addWidget(cmdgrab, 0);
    hb->addSpacing(5);

    // ------------------------------------------------
    // time for the list view
    QBoxLayout *hb1 = new QHBoxLayout(topLayout);

    listview = new QListView(this);
    listview->setRootIsDecorated(false);
    listview->setAllColumnsShowFocus(true);
    listview->setMultiSelection(false);
    listview->setSorting(-1);
    listview->addColumn(" Yer Key:  ", -1);
    listview->addColumn(" Yer Modifier(s) ", -1);
    listview->addColumn(" You wanna do WHAT with that???", 325);
    listview->setColumnWidthMode(2, QListView::Maximum);
    listview->setGeometry(10, 60, 500, 200);
    listview->setMinimumSize(500, 180);
    connect(listview, SIGNAL(selectionChanged()), this,
	    SLOT(listviewclick()));

    hb1->addWidget(listview);

    QBoxLayout *hb2 = new QHBoxLayout(topLayout);
    rem = new QPushButton("Erm. Yeah, but not that one...", this);
    connect(rem, SIGNAL(clicked()), this, SLOT(nukeKeyGrab()));

    remall = new QPushButton("To the dungeon with them all!!", this);
    connect(remall, SIGNAL(clicked()), this, SLOT(clearList()));

    hb2->addWidget(rem);
    hb2->addWidget(remall);

    // ------------------------------------------------
    // separator below clist
    QFrame *sep2 = new QFrame(this);
    sep2->setFrameStyle(QFrame::HLine | QFrame::Raised);
    sep2->setLineWidth(1);
    topLayout->addWidget(sep2);

    // ------------------------------------------------
    // groupbox for editting ExecCommand stuff
    QBoxLayout *h3 = new QHBoxLayout(topLayout);

    editframe =
	new QGroupBox(2, Qt::Horizontal, "ExecCommand edit-foo", this);
    editframe->setEnabled(false);

    txtcmd = new QLineEdit(editframe, "txtbox");
    txtcmd->setMaxLength(500);
    connect(txtcmd, SIGNAL(returnPressed()), this, SLOT(updatetext()));

    cmdchangetext = new QPushButton("Yeah baybee!!", editframe);
    connect(cmdchangetext, SIGNAL(clicked()), this, SLOT(updatetext()));

    h3->addWidget(editframe);

    // ------------------------------------------------
    // closing buttons
    QHBox *hb3 = new QHBox(this);

    finsave = new QPushButton("Hey, wow! Save this puppy!", hb3);
    finsave->setMinimumWidth(200);
    connect(finsave, SIGNAL(clicked()), this, SLOT(save()));

    finnosave = new QPushButton("Let me out!!", hb3);
    finnosave->setMinimumWidth(200);
    connect(finnosave, SIGNAL(clicked()), qApp, SLOT(quit()));

    topLayout->addWidget(hb3);

    // ------------------------------------------------
    // throw in a status bar for good measure
    statusbar = new QLabel(this);
    statusbar->setText("Weehee!!  Welcome to bbkeys configQt tool!");
    statusbar->setFrameStyle(QFrame::Panel | QFrame::Sunken);
    // This widget will use all horizontal space, and have a fixed height.
    // put this into the class so we can send it messages
    topLayout->addWidget(statusbar);

    // ------------------------------------------------
    // done constructing our window.  Now to the real work. =:)

    rcfile = getenv("HOME");
    rcfile.append("/.bbkeysrc");

    readFile();
}

FrontEnd::~FrontEnd()
{
    delete menubar;
    delete statusbar;
    delete combobox;
    delete listview;
}

// SLOTS
void FrontEnd::helpscreen()
{
    QMessageBox::about(this, "bbkeys configuration utility",
		       "<p>Weehee!!  Strap on yer hip-huggers, baybee!!</p>"
		       "<p>This here is a little honey of an application "
		       "that I wrote to help configure bbkeys (a keybinding "
		       "application for "
		       "<a href='http://blackbox.alug.org'>"
		       "blackbox).</a></p>"
		       "<p>For more information, please visit "
		       "<a href='http://movingparts.net'>"
		       "http://movingparts.net</a>."
		       "Thanks y'all!!!</p>");
}

void FrontEnd::updatetext(void)
{
    QListViewItem *item = listview->selectedItem();

    if (item) {
	QString s;
	s.sprintf("ExecCommand {%s}",
		  (const char *) txtcmd->text().simplifyWhiteSpace());
	item->setText(2, s);
	grablist.remove(item);
	grablist.append(item);

	statusbar->
	    setText("Updated ExecCommand. Better watch it, pallie.");
    }
}

void FrontEnd::listviewclick(void)
{
    QListViewItem *item = listview->selectedItem();

    if (item) {
	QString s = item->text(2);
	int sB = 0, sE = 0;
	if (s.contains("ExecCommand", false)) {
	    editframe->setEnabled(true);
	    sB = s.find('{', 0) + 1;
	    sE = s.find('}', sB - 1);
	    txtcmd->setText(s.mid(sB, sE - sB));
	    txtcmd->setCursorPosition(0);
	    txtcmd->setEnabled(true);
	    cmdchangetext->setEnabled(true);
	} else {
	    editframe->setEnabled(false);
	    txtcmd->setText("");
	    txtcmd->setEnabled(false);
	    cmdchangetext->setEnabled(false);
	}
    }
}

void FrontEnd::clearList(void)
{
    listview->clear();
    grablist.clear();
    editframe->setEnabled(false);
    txtcmd->setText("");
    txtcmd->setEnabled(false);
    cmdchangetext->setEnabled(false);
    statusbar->setText("List cleared. Carry on, Pilgrim...");
}

void FrontEnd::nukeKeyGrab()
{
    QListViewItem *item = listview->selectedItem();

    if (item) {
	listview->removeItem(item);
	grablist.remove(item);
    }
    editframe->setEnabled(false);
    txtcmd->setText("");
    txtcmd->setEnabled(false);
    cmdchangetext->setEnabled(false);
    statusbar->setText("Okey dokey. That one went to /dev/null...");
}

void FrontEnd::grabKey()
{
    if (!capturing) {
	capturing = true;
	cmdgrab->setText("Cancel");
	statusbar->setText
	    ("Press your desired shortcut key(s) or "
	     "Cancel to stop capturing.");
	editframe->setEnabled(false);
	txtcmd->setText("");
	txtcmd->setEnabled(false);
	cmdchangetext->setEnabled(false);

	listview->setEnabled(false);
	combobox->setEnabled(false);
	menubar->hide();

	rem->setEnabled(false);
	remall->setEnabled(false);
	finsave->setEnabled(false);
	finnosave->setEnabled(false);
	//this->grabKeyboard();

    } else {
	// we should only hit this code when the user hits "Cancel"
	// the actual grabbing is done in keyPressEvent, baybee

	capturing = false;
	cmdgrab->setText("Grab Key");
	statusbar->
	    setText("Alllllllrighty then. Don't toy with me, man!!!");

	listview->setEnabled(true);
	combobox->setEnabled(true);
	menubar->show();

	rem->setEnabled(true);
	remall->setEnabled(true);
	finsave->setEnabled(true);
	finnosave->setEnabled(true);
	//this->releaseKeyboard();
    }
}

//void FrontEnd::keyPressEvent(QKeyEvent * k)
void FrontEnd::captureKeygrab(XEvent * e)
{
    if (!capturing)
	return;
    if ((XKeycodeToKeysym(qt_xdisplay(), e->xkey.keycode, 0)
	 >= XK_Shift_L
	 && XKeycodeToKeysym(qt_xdisplay(), e->xkey.keycode,
			     0) <= XK_Hyper_R) ||
	(XKeycodeToKeysym(qt_xdisplay(), e->xkey.keycode, 0)
	 == XK_Num_Lock))

	return;

    QString action = combobox->currentText();
    if (action.contains("ExecCommand", false)) {
	action.append(" {Wahoo! Edit me baybee!}");
    }

    QString mods;
    switch (e->xkey.state) {
    case ShiftMask:
	mods = "Shift";
	break;
    case ControlMask:
	mods = "Control";
	break;
    case Mod1Mask:
	mods = "Mod1";
	break;
    case Mod2Mask:
	mods = "Mod2";
	break;
    case Mod3Mask:
	mods = "Mod3";
	break;
    case Mod4Mask:
	mods = "Mod4";
	break;
    case Mod5Mask:
	mods = "Mod5";
	break;

	/* I know, it's not all the combinations, but hey... */
    case ControlMask | ShiftMask:
	mods = "Control+Shift";
	break;
    case ControlMask | Mod1Mask:
	mods = "Control+Mod1";
	break;
    case Mod1Mask | ShiftMask:
	mods = "Mod1+Shift";
	break;
    case ControlMask | ShiftMask | Mod1Mask:
	mods = "Control+Shift+Mod1";
	break;

    default:
	mods = "None";
	break;
    }

    QString
	w = XKeysymToString(XKeycodeToKeysym(qt_xdisplay(),
					     e->xkey.keycode, 0));


    /* Okay, we know what they want, but we need to make sure that they
     * don't already have something in the listview for either this action
     * or this key+modifiers.  If so, replace it....
     */

    bool gottaGoober = false;

    for (QListViewItem * it = listview->firstChild();
	 it; it = it->nextSibling()) {
	if ((it->text(0) == w && it->text(1) == mods)
	    || it->text(2) == action) {
	    gottaGoober = true;
	    listview->removeItem(it);
	    grablist.remove(it);
	}
    }

    grablist.append(new QListViewItem(listview, w, mods, action));
    listview->setCurrentItem(grablist.current());
    listview->ensureItemVisible(grablist.current());

    if (gottaGoober) {
	statusbar->setText("Found duplicate keys or action. Fixed.");
    } else {
	statusbar->setText("Yeah, baybee!! Groove with it, baybee!!");
    }

    capturing = false;
    cmdgrab->setText("Grab Key");

    listview->setEnabled(true);
    combobox->setEnabled(true);
    menubar->show();

    rem->setEnabled(true);
    remall->setEnabled(true);
    finsave->setEnabled(true);
    finnosave->setEnabled(true);
    //this->releaseKeyboard();

}

void FrontEnd::open()
{
    QString temp = rcfile;

    rcfile = QFileDialog::getOpenFileName();

    if (rcfile) {
	readFile();
	statusbar->setText("File opened. Let the games begin, baybee.");
    } else {
	statusbar->setText("Not opened.");
	rcfile = temp;
    }
}

void FrontEnd::save()
{
    writeFile();
    statusbar->setText("File saved.");
    exit(0);
}

void FrontEnd::saveAs()
{
    QString temp = rcfile;

    rcfile = QFileDialog::getSaveFileName();

    if (rcfile)
	save();
    else {
	statusbar->setText("Not saved.");
	rcfile = temp;
    }
}

// PRIVATE FUNCTIONS UNFIT FOR HUMAN CONSUMPTION
void FrontEnd::readFile()
{
    if (!grablist.isEmpty()) {
	listview->clear();
	grablist.clear();
    }

    QFile f(rcfile);
    if (f.open(IO_ReadOnly)) {	// file opened successfully
	QTextStream t(&f);	// use a text stream
	QString s;
	while (!t.eof()) {	// until end of file...
	    s = t.readLine();	// line of text excluding '\n'
	    s = s.simplifyWhiteSpace();
	    if (s.at(4) == '#' || !s.contains("WithModifier", false)) {
		continue;
	    }
	    QString key, mods, action, cmd;
	    int keyB, modsB, actionB, cmdB;
	    int keyE, modsE, actionE, cmdE;

	    keyB = s.find('(', 0, true);
	    keyE = s.find(')', keyB, true);
	    modsB = s.find('(', keyE, true);
	    modsE = s.find(')', modsB, true);
	    actionB = s.find('(', modsE, true);
	    actionE = s.find(')', actionB, true);

	    key = s.mid(keyB + 1, keyE - keyB - 1);
	    if (key.contains("iso_left_tab", false))
		key = "Tab";
	    mods = s.mid(modsB + 1, modsE - modsB - 1);
	    action = s.mid(actionB + 1, actionE - actionB - 1);

	    /* if we're supposed to having an execCommand and we do have
	     * something to put into it                                 */
	    if (s.contains("ExecCommand", false)) {
		cmdB = s.find('(', actionE, true);
		cmdE = s.find(')', cmdB, true);
		if (cmdB && cmdE) {
		    cmd = s.mid(cmdB + 1, cmdE - cmdB - 1);
		} else {
		    cmd = "Error in ExecCommand syntax";
		}
		action.append(" {");
		action.append(cmd);
		action.append("}");
	    }
	    if (!key.isEmpty() && !mods.isEmpty()
		&& !action.isEmpty()) {
		grablist.
		    append(new QListViewItem(listview, key, mods, action));
	    }
	}
	f.close();
	listview->setSorting(0, true);
    } else {
	QString stat;
	stat.sprintf
	    ("Hey now. I can't seem to open %s! Ya hate to see that!",
	     (const char *) rcfile);
	statusbar->setText(stat);

    }
}

void FrontEnd::writeFile()
{
    ofstream out(rcfile);

    for (QListViewItem * it = listview->firstChild();
	 it; it = it->nextSibling()) {
	if (!it->text(2).contains("ExecCommand", false)) {
	    out << "KeyToGrab(" << it->text(0) <<
		"), WithModifier(" << it->text(1) <<
		"), WithAction(" << it->text(2) << ")" << endl;
	} else {
	    QString s = it->text(2);
	    int sB = 0, sE = 0;
	    sB = s.find('{', 0) + 1;
	    sE = s.find('}', sB);
	    out << "KeyToGrab(" << it->text(0) <<
		"), WithModifier(" << it->text(1) <<
		"), WithAction(ExecCommand" <<
		"), DoThis(" << s.mid(sB, sE - sB) << ")" << endl;
	}
    }

    out.close();

}

#include "gui.moc"
