# - Try to find PulseAudioSimple
# Once done this will define
#
#  PULSEAUDIOSIMPLE_FOUND - system has PulseAudioSimple
#  PULSEAUDIOSIMPLE_INCLUDE_DIR - the PulseAudioSimple include directory
#  PULSEAUDIOSIMPLE_LIBRARIES - the libraries needed to use PulseAudioSimple
#  PULSEAUDIOSIMPLE_DEFINITIONS - Compiler switches required for using PulseAudioSimple
#
MESSAGE(STATUS "<** PulseAudio **>")
MESSAGE(STATUS "<---------------->")

IF(NO_PULSE_SIMPLE)
        message(status "<disabled per request>")
ELSE(NO_PULSE_SIMPLE)

IF (PULSEAUDIOSIMPLE_INCLUDE_DIR AND PULSEAUDIOSIMPLE_LIBRARIES)
   # in cache already
   SET(PULSEAUDIOSIMPLE_FIND_QUIETLY TRUE)
ENDIF (PULSEAUDIOSIMPLE_INCLUDE_DIR AND PULSEAUDIOSIMPLE_LIBRARIES)

IF (NOT WIN32)
   # use pkg-config to get the directories and then use these values
   # in the FIND_PATH() and FIND_LIBRARY() calls
   INCLUDE(UsePkgConfig)
   PKGCONFIG(libpulse-simple _PASIncDir _PASLinkDir _PASLinkFlags _PASCflags)
   SET(PULSEAUDIOSIMPLE_DEFINITIONS ${_PASCflags})
ENDIF (NOT WIN32)

FIND_PATH(PULSEAUDIOSIMPLE_INCLUDE_DIR pulse/simple.h
   PATHS
   ${_PASIncDir}
   PATH_SUFFIXES pulse
   )

FIND_LIBRARY(PULSEAUDIOSIMPLE_LIBRARIES NAMES pulse-simple libpulse-simple
   PATHS
   ${_PASLinkDir}
   )

IF (PULSEAUDIOSIMPLE_INCLUDE_DIR AND PULSEAUDIOSIMPLE_LIBRARIES)
   SET(PULSEAUDIOSIMPLE_FOUND TRUE)
ELSE (PULSEAUDIOSIMPLE_INCLUDE_DIR AND PULSEAUDIOSIMPLE_LIBRARIES)
   SET(PULSEAUDIOSIMPLE_FOUND FALSE)
ENDIF (PULSEAUDIOSIMPLE_INCLUDE_DIR AND PULSEAUDIOSIMPLE_LIBRARIES)

IF (PULSEAUDIOSIMPLE_FOUND)
   IF (NOT PULSEAUDIOSIMPLE_FIND_QUIETLY)
      MESSAGE(STATUS "Found PulseAudio Simple: ${PULSEAUDIOSIMPLE_LIBRARIES}")
   ENDIF (NOT PULSEAUDIOSIMPLE_FIND_QUIETLY)
   SET(USE_PULSE_SIMPLE 1)
ELSE (PULSEAUDIOSIMPLE_FOUND)
      MESSAGE(STATUS "Could NOT find LibXml2")
ENDIF (PULSEAUDIOSIMPLE_FOUND)

MARK_AS_ADVANCED(PULSEAUDIOSIMPLE_INCLUDE_DIR PULSEAUDIOSIMPLE_LIBRARIES)

ENDIf(NO_PULSE_SIMPLE)

