// Copyright 2000 by Kevin Atkinson under the terms of the LGPL

#include "emulation.hh"

namespace aspell {

  class Manager;

  class SuggestionList {
  public:
    typedef Emulation<const char *>    Emul;
    typedef VirEmulation<const char *> VirEmul;
    typedef const char *               Value;
    typedef int                        Size;

    virtual SuggestionList * clone() const = 0;
    virtual void assign(const SuggestionList *) = 0;
    
    virtual bool empty() const = 0;
    virtual Size size() const = 0;
    virtual VirEmul * elements() const = 0;
    virtual ~SuggestionList() {}
  };

  class Suggest {
  public:
    virtual void set_mode(const string &) = 0;
    virtual double score(const char *base, const char *other) = 0;
    virtual SuggestionList & suggest(const char * word) = 0;
    virtual ~Suggest() {}
  };
  
  Suggest * new_default_suggest(const Manager *);
}


