// Copyright 2000 by Kevin Atkinson under the terms of the LGPL

#ifndef __aspell_invalid_word__
#define __aspell_invalid_word__

#include "file_exceps.hh"
#include "data.hh"

namespace aspell {

  struct CompoundInfo;
  
  using namespace autil;

  struct InvalidFlag : public Exception, public RethrowWFile
  {
    string word;
    string flag;
    void rethrow_w_file(const string &f) const;
    InvalidFlag(const string & w, const string & fl);
    ~InvalidFlag() throw() {}
  protected:
    void add_message();
  };
  
  //  struct InvalidFlagInFile : public InvalidFlag, public WithFileException
  //{};

  struct ConflictingFlags : public Exception, public RethrowWFile
  {
    string word;
    string flag1;
    string flag2;
    void rethrow_w_file(const string &f) const;
    ConflictingFlags(const string & w, 
		     CompoundInfo f1, 
		     CompoundInfo f2,
		     const Language & l);
    ~ConflictingFlags() throw() {}
  protected:
    void add_message();
  };
  
}

#endif
