#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "globals.h"
#include "functions.h"

/* getobject() - check if token is a known object variable */
/* returns object type if found, or 0 (implies token is not a known object) */

int getobject(char *token, int *objidx)
{
  for ((*objidx)=0; (*objidx)<objectsptr; (*objidx)++)
  {
    if (strcasecmp(token,objects[*objidx])==0) break;
  }

  if ((*objidx)==objectsptr) return 0;

  printf("getobject/found: %s type=%s\n",token,objectstype[*objidx]);
  if (strcasestr_m(objectstype[*objidx],"ADODB.Connection")!=0) return OBJ_ADODB_CONNECTION;
  if (strcasestr_m(objectstype[*objidx],"ADODB.Execute")!=0) return OBJ_ADODB_RECORDSET;
  if (strcasestr_m(objectstype[*objidx],"ADODB.Command")!=0) return OBJ_ADODB_COMMAND;
  if (strcasestr_m(objectstype[*objidx],"ADODB.RecordSet")!=0) return OBJ_ADODB_RECORDSET;
  if (strcasestr_m(objectstype[*objidx],"Scripting.FileSystem")!=0) return OBJ_SCRIPTING_FILESYSTEM;
  if (strcasestr_m(objectstype[*objidx],"Scripting.FileSystemObject")!=0) return OBJ_SCRIPTING_FILESYSTEM;
  if (strcasestr_m(objectstype[*objidx],"JMail.SMTPMail")!=0) return OBJ_JMAIL_SMTPMAIL;
  if (strcasestr_m(objectstype[*objidx],"CDONTS.NewMail")!=0) return OBJ_CDONTS_NEWMAIL;
  if (strcasestr_m(objectstype[*objidx],"Scripting.Dictionary")!=0) return OBJ_SCRIPTING_DICTIONARY;

  return 0;
}


void parse_createobject(char *newtoken, int t)
{
int tokentype;
char token[TOKENSIZE];

#ifdef DEBUG
printf("parse_createobject()\n");
#endif
  tokentype=gettoken(token);
  if (strcmp(token,"(")!=0)
  { error(token,"(","CreateObject"); }

  tokentype=gettoken(token);
  if (tokentype!=TOK_DBLQT && tokentype!=TOK_SNGQT)
  { error(token,"String Literal","CreateObject"); }

  strcpy(objectstype[t],token);
  if (t==objectsptr) objectsptr++;

  tokentype=gettoken(token);
  if (strcmp(token,")")!=0)
  { error(token,")","CreateObject"); }
  sprintf(newtoken,"// $%s is of type %s",objects[t],objectstype[t]);
}


int parse_dictionary(char *newtoken, char *oldtoken)
{
int tokentype;
char token[TOKENSIZE];
char molecule[LINELENGTH];

  tokentype=gettoken(token);

#ifdef DEBUG
printf("parse_dictionary(): %s (type=%i)\n",token,tokentype);
#endif

  if (strcasecmp(token,"add")==0)
  {
    strcat(newtoken,"$");
    strcat(newtoken,oldtoken);
    strcat(newtoken,"[");
    eval_molecule(molecule);
    strcat(newtoken,molecule);
    strcat(newtoken,"]=");
    eval_molecule(molecule);
    strcat(newtoken,molecule);
    strcat(newtoken,";\n");
  }
    else
  if (strcasecmp(token,"exists")==0)
  {
    strcat(newtoken,"isset($");
    strcat(newtoken,oldtoken);
    convert_funct(newtoken,"1",16);
    strcat(newtoken,")");
  }
    else
  if (strcasecmp(token,"remove")==0)
  {
    strcat(newtoken,"unset($");
    strcat(newtoken,oldtoken);
    convert_funct(newtoken,"1",16);
    strcat(newtoken,")");
  }
    else
  if (strcasecmp(token,"comparemode")==0)
  {
    while((tokentype=gettoken(token))!=TOK_EOL && tokentype!=TOK_COLON);
    push(token,tokentype);
    printf("Warning: tried to set CompareMode for dictionary \"%s\" on line: %d (this is not supported)\n",oldtoken,line);
  }
    else
  if (strcasecmp(token,"(")==0)
  {
    strcat(newtoken,oldtoken);
    strcat(newtoken,"[");
    eval_molecule(molecule);
    strcat(newtoken,molecule);
    strcat(newtoken,"]");
  }
    else
  if (tokentype==TOK_EOL || strcasecmp(token,")")==0)
  {
    strcat(newtoken,"$");
    strcat(newtoken,oldtoken);
    push(token,tokentype);
  }
    else
  {
    fprintf(out,"%s",token); 
    eval_expression(" ");
    strcat(newtoken," // unknown dictionary method");
    printf("Unknown dictionary function \"%s\" on line: %d\n",token,line);
  }

  return 0;
}


void parse_object(char *newtoken, char *token, int t)
{
int tokentype;
char temptoken[TOKENSIZE];

#ifdef DEBUG
printf("parse_object(): %s (objtype=%i)\n",token,t);
#endif

  strcpy(temptoken,token);
  tokentype=gettoken(token);
#ifdef DEBUG
printf("parse_object/next token: %s (type=%i)\n",token,tokentype);
#endif
  if (strcmp(token,".")!=0)
  { push(token,tokentype); }
  if (strcmp(token,".")!=0 && strcmp(token,"(")!=0)
  {
    strcat(newtoken,"$");
    strcat(newtoken,temptoken);
    return;
  }

  strcase(temptoken);

  if (t==1) 
  { 
    switch (database_type)
    {
      case DB_MYSQL   : parse_adodb_connection_mysql(newtoken,temptoken); break;
      case DB_ODBC    : parse_adodb_connection_odbc(newtoken,temptoken); break;
      case DB_ORACLE  : parse_adodb_connection_oracle(newtoken,temptoken); break;
      case DB_SYBASE  : parse_adodb_connection_sybase(newtoken,temptoken); break;
      case DB_POSTGRES: parse_adodb_connection_pg(newtoken,temptoken); break;
    }
  }
    else
  if (t==2) 
  { 
    switch (database_type)
    {
      case DB_MYSQL   : parse_adodb_rs_mysql(newtoken,temptoken); break;
      case DB_ODBC    : parse_adodb_rs_odbc(newtoken,temptoken); break;
      case DB_ORACLE  : parse_adodb_rs_oracle(newtoken,temptoken); break;
      case DB_SYBASE  : parse_adodb_rs_sybase(newtoken,temptoken); break;
      case DB_POSTGRES: parse_adodb_rs_pg(newtoken,temptoken); break;
    }
  }
    else
  if (t==3) { parse_command_set(newtoken,temptoken); }
    else
  if (t==5) { parse_filesystem(newtoken,temptoken); }
    else
  if (t==6) { parse_mail(newtoken,temptoken); }
    else
  if (t==7) { parse_new_mail(newtoken,temptoken); }
    else
  if (t==8) { parse_dictionary(newtoken,temptoken); }

}

