#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "globals.h"
#include "functions.h"

int parse_condition()
{
char token[TOKENSIZE];
int tokentype;
char newtoken[LINELENGTH];
char comment[LINELENGTH];

  putc('(',out);
  comment[0]=0;

  /* while((tokentype=gettoken(token))!=TOK_EOL && tokentype!=TOK_UNDERSCORE) */
  while((tokentype=gettoken(token))!=TOK_EOL)
  {

#ifdef DEBUG
printf("parse_condition(): %s (type=%i)\n",token,tokentype);
#endif

    if (tokentype==TOK_EOF) { return 1; }

    if (tokentype==TOK_UNDERSCORE)
    {
      fprintf(out,"\n");
      autoindent();
      fprintf(out,"   ");
    }
      else
    if (tokentype==TOK_ENDCODE)
    { break; }
      else
    if (tokentype==TOK_COMMENT)
    {
      strcpy(comment,token);
      strcpy(token,"\n");
      tokentype=TOK_EOL;
      break;
    }
      else
    if (tokentype==TOK_ARITHOP)
    { fprintf(out,"%s",token); }
      else
/*
    if (tokentype==TOK_UNDERSCORE)
    { putc('\n',out); continue; }
      else
*/
    if (strcasecmp(token,"not")==0)
    { fprintf(out,"!"); }
      else
    if (strcasecmp(token,"and")==0)
    { fprintf(out," && "); }
      else
    if (strcasecmp(token,"then")==0 || tokentype==TOK_EOL)
    { break; }
      else
    if (strcasecmp(token,"=")==0 || strcasecmp(token,"is")==0)
    { fprintf(out,"=="); }
      else
    if (strcasecmp(token,"<>")==0)
    { fprintf(out,"!="); }
      else
    if (strcasecmp(token,"or")==0)
    { fprintf(out," || "); }
      else
    if (tokentype==TOK_DBLQT || tokentype==TOK_SNGQT)
    { fprintf(out,"%s",token); }
      else
    if (tokentype==TOK_AMP)
    { putc('.',out); }
      else
    if (tokentype==TOK_PAREN || tokentype==TOK_RELOP)
    { fprintf(out,"%s",token); }
      else
    if (tokentype==TOK_NUMBER)
    { fprintf(out,"%s",token); }
      else
    if (tokentype==TOK_KEYWORD)
    {
      eval_element(newtoken, tokentype, token);
      fprintf(out,"%s",newtoken);
    }

    if (spacer==1) putc(' ',out);
  }

  fprintf(out,")");
  push (token,tokentype);

  if (comment[0]!=0)
  {
    comment[strlen(comment)-1]=0;
    fprintf(out," %s",comment);
  }

  return 0;
}

int parse_select()
{
char token[TOKENSIZE];
char newtoken[LINELENGTH];
int t,c,tokentype;
int lasttype=0;

  tokentype=gettoken(token);
  if (strcasecmp(token,"case")!=0)
  { error(token,"case","Select"); }

  autoindent();
  fprintf(out,"switch ");
  c=parse_condition();
  putc('\n',out);
  autoindent();
  fprintf(out,"{\n");
  indent++;

  while(1)
  {
    tokentype=gettoken(token);
    if (tokentype==TOK_EOL || tokentype==TOK_COLON)
    { continue; }
      else
    if (tokentype==TOK_EOF || strcasecmp(token,"end")==0)
    { break; }
      else
    if (strcasecmp(token,"case")!=0)
    { error(token,"case","Select"); }

    while (1)
    {
      autoindent();
      tokentype=gettoken(token);

      if (strcasecmp(token,"else")==0)
      {
        fprintf(out,"default:\n");
        break;
      }

      push(token,tokentype);
      fprintf(out,"case ");
      lasttype=0;

      while (1)
      {
        tokentype=gettoken(token);

        if ((tokentype==TOK_DBLQT || (tokentype==TOK_SNGQT || tokentype==TOK_KEYWORD)) && lasttype==1)
        {
          push(token,tokentype);
          lasttype=2;
          break;
        }

        if ((tokentype==TOK_EOL || tokentype==TOK_COLON) || tokentype==TOK_ENDCODE)
        { break; }
          else
        if (strcmp(token,",")==0)
        { break; }
          else
        if (tokentype!=TOK_KEYWORD)
        { fprintf(out,"%s",token); }
          else
        if (isfunction(token)==1)
        {
          fprintf(out,"%s",token);
          t=gettoken(token);
          if (strcmp(token,"(")==0)
          {
            sprintf(newtoken,"(");
            push("(",TOK_PAREN);
            eval_funct(newtoken);
            strcat(newtoken,")");
          }
            else
          { error(token,"(","Select"); }
        }
          else
        { eval_token(tokentype,token); }

        if (tokentype==TOK_DBLQT || tokentype==TOK_SNGQT || tokentype==TOK_KEYWORD)
        { lasttype=1; }
          else
        { lasttype=0; }
      }

      if (tokentype==TOK_ENDCODE)
      {
        push(token,tokentype);
        fprintf(out,": ");
        break;
      }

      fprintf(out,":\n");

      if ((tokentype==TOK_EOL || tokentype==TOK_COLON) || lasttype==2)
      { break; }

      if (tokentype==TOK_ENDCODE)
      {
        push(token,tokentype);
        break;
      }
    }
    indent++;
    parse_body(0);
    autoindent();
    fprintf(out,"break;\n");
    indent--;

    tokentype=gettoken(token);
    if (strcasecmp(token,"select")==0)
    { break; }

    push(token,tokentype);
  }

  indent--;
  autoindent();
  fprintf(out,"} ");

  return 0;
}

int parse_if()
{
char token[255];
int tokentype;
int c;
static int cnt;

  cnt++;
#ifdef DEBUG
printf("parse_if #%i/before condition\n",cnt);
#endif

  autoindent();
  fprintf(out,"if ");

  c=parse_condition();

  c=gettoken(token);
  fprintf(out,"\n");
  autoindent();
  fprintf(out,"{\n");
  indent++;

  tokentype=gettoken(token);
#ifdef DEBUG
printf("parse_if #%i/after condition: %s (type=%i)\n",cnt,token,tokentype);
#endif

  if (tokentype==TOK_COMMENT)
  {
    fprintf(out,"%s",token);
    c=parse_body(0);
  }
    else
  if (tokentype==TOK_EOL || tokentype==TOK_ENDCODE)
  {
    push(token,tokentype);
    c=parse_body(0);
  }
    else
  {
    push(token,tokentype);
    c=parse_body(1);
  }

  indent--;
  autoindent();
  fprintf(out,"} ");

#ifdef DEBUG
printf("parse_if #%i/parse_body result=%i\n",cnt,c);
#endif

  if (c==1)
  {
    tokentype=gettoken(token);
    if (strcasecmp(token,"if")!=0)
    {
      push(token,tokentype);
    }
  }

  tokentype=gettoken(token);
  push(token,tokentype);

  if (tokentype!=TOK_ENDCODE)
  { fprintf(out,"\n"); }

  return 0;
}



