#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "globals.h"
#include "functions.h"

int parse_filesystem(char *newtoken, char *oldtoken)
{
int tokentype,l;
char token[TOKENSIZE];
char molecule[LINELENGTH];

  tokentype=gettoken(token);
  molecule[0]=0;

  if (strcasecmp(token,"folderexists")==0 || strcasecmp(token,"fileexists")==0)
  {
    strcat(newtoken,"file_exists");
    convert_funct(newtoken,"1",8);
    strcat(newtoken,";");
  }
    else
  if (strcasecmp(token,"createfolder")==0)
  {
    strcat(newtoken,"mkdir");
    convert_funct(newtoken,"1,@0777",8);
    strcat(newtoken,";");
  }
    else
  if (strcasecmp(token,"copyfolder")==0 || strcasecmp(token,"copyfile")==0)
  {
    strcat(newtoken,"copy");
    convert_funct(newtoken,"1",8);
    strcat(newtoken,";");
  }
    else
  if (strcasecmp(token,"movedir")==0 || strcasecmp(token,"movefile")==0)
  {
    strcat(newtoken,"rename");
    convert_funct(newtoken,"1",8);
    strcat(newtoken,";");
  }
    else
  if (strcasecmp(token,"delete")==0 || strcasecmp(token,"deletefile")==0)
  {
    strcat(newtoken,"unlink");
    convert_funct(newtoken,"1",8);
    strcat(newtoken,";");
  }
    else
  if (strcasecmp(token,"write")==0)
  {
    strcat(newtoken,"fputs($");
    strcat(newtoken,oldtoken);
    strcat(newtoken,",");
    convert_funct(newtoken,"1",1);
    strcat(newtoken,");");
  }
    else
  if (strcasecmp(token,"readall")==0)
  {
    strcat(newtoken,"fgets($");
    strcat(newtoken,oldtoken);
    strcat(newtoken,",65535);");
  }
    else
  if (strcasecmp(token,"close")==0)
  {
    strcat(newtoken,"fclose($");
    strcat(newtoken,oldtoken);
    strcat(newtoken,");");
  }
    else
  if (strcasecmp(token,"opentextfile")==0)
  {
    strcat(newtoken,"fopen(");
    convert_funct(molecule,"1,2",9);

    l=strlen(molecule);
    while(l>0)
    {
      if (molecule[l]==',') break;
      l--;
    }

    molecule[l++]=0;
    strcat(newtoken,molecule);

    while(molecule[l]!=0 && molecule[l]==' ') l++;

    if (molecule[l]=='1') strcat(newtoken,",\"r\"");
      else
    if (molecule[l]=='2') strcat(newtoken,",\"w\"");
      else
    if (molecule[l]=='8') strcat(newtoken,",\"a\"");
      else
    { strcat(newtoken,",\"r\""); }

    strcat(newtoken,");");

    tokentype=gettoken(token);
    push(token,tokentype);
  }
    else
  if (strcasecmp(token,"getfolder")==0)
  {
    strcat(newtoken,"readfile");
    convert_funct(newtoken,"1",8);
    strcat(newtoken,";");
  }
    else
  {
    strcat(newtoken,"// unknown filesystem method");
    eval_expression(" ");
    printf("Uknown filesystem function \"%s\" on line: %d\n",token,line);
  }

  return 0;
}

