#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <dirent.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "globals.h"

#define VERSION "asp2php 0.75.25 - November 23, 2001\n" \
    "Copyright 2001 By Michael Kohn (naken@naken.cc)\n"
#include "functions.h"

/* ASP to PHP converter           */
/* Copyright 2001 by Michael Kohn */

/*
Token Types:

0: EOF
1: number
2: keyword
3: _
4: identifier
5: EOL
6: %>
7: +,-,*,/
8: >,<,<=,>=,<>
9: &
10: "    "
11: '    '
12: (,)
13: :
14: .
15: comment
16: ,

*/

/*

DataBase Types:

1: MySQL
2: ODBC
3: Oracle 8
4: Sybase
5: Postgres

Object Types:

-1: Nothing

 1: ADODB.Connection
 2: ADODB.RecordSet
 3: ADODB.Command
 5: FileSystem Object
 6: JMail
 7: CDONTS.NewMail

*/

char tokenpush[TOKENSIZE]={ 0 };
int tokentypepush=0;
char tokenpush2[TOKENSIZE]={ 0 };
int tokentypepush2=0;
FILE *in,*out;
int pushback=-1;
int indent=0,line=1,column=0;
char objects[80][50];
char objectstype[80][50];
int objectsptr=0;
int database_type=0;
int setvar=0;
int add_isnum=0,add_session=0,BOF=0;
int infunct=0,functptr;
char funct[80][50];
char global_uid[70];
char global_passwd[70];
char global_database[70];
char global_address[70];
char global_dsn[70];
char sessionpool[256][200];
int sessionptr=0;
int pngs=0,y2k=1,casesense=0,php=0;
int html=0,spacer=0;
char aspextensions[20][10];
int aspextensions_ptr=0;
int includes=0;
int requestvar=0;
int javascript=0;
int loopcount=0;
int global_asa=0;

void convert(char *infile, char *outfile);

int copyfiles(char *sourcedir, char *targetdir)
{
DIR *dp_asp;
DIR *dp_php;
struct dirent *direntp;
struct stat statbuf;
char newdir[2048];
char filename_asp[1024];
char filename_php[1024];
int t;

  dp_asp=opendir(sourcedir);

  while ((direntp=readdir(dp_asp))!=NULL)
  {
    if (strcmp(direntp->d_name,".")==0) continue;
    if (strcmp(direntp->d_name,"..")==0) continue;

    sprintf(filename_asp,"%s/%s",sourcedir,direntp->d_name);
    printf("working on file: %s\n",filename_asp);

    if (stat(filename_asp,&statbuf)==-1)
    {
      printf("Error: Couldn't stat file: %s\n\n",sourcedir);
      return 1;
    }

    if (statbuf.st_mode & S_IFDIR)
    {
      sprintf(filename_php,"%s/%s",targetdir,direntp->d_name);
      sprintf(filename_asp,"%s/%s",sourcedir,direntp->d_name);

      dp_php=opendir(filename_php);

      if (dp_php==0)
      {
        /* sprintf(newdir,"mkdir -p \"%s\"",filename_php); */
        sprintf(newdir,"mkdir -p \"%s\"",filename_php);
	if (system(newdir)!=0)
        {
          printf("Error: Couldn't create dir: %s\n\n",filename_php);
	  return 1;
        }
      }
        else
      { closedir(dp_php); }

      if (copyfiles(filename_asp,filename_php)==1) return 1;
    }
      else
    {
      sprintf(filename_php,"%s/%s",targetdir,direntp->d_name);
      sprintf(filename_asp,"%s/%s",sourcedir,direntp->d_name);

      t=strlen(filename_php);

      if (is_asp_filename(filename_asp))
      {
        if (php==3) { change_extension(filename_php,".php3"); }
          else
        if (php==4) { change_extension(filename_php,".php4"); }
          else
        { change_extension(filename_php,".php"); }

        convert(filename_asp,filename_php);

        /* strcat(newdir,arguments); */

/* Why the fuck did i leave those 5 lines in?

        if (system(newdir)!=0)
	{
          printf("Error: Couldn't copy file: %s\n\n",filename_asp);
	  return 1;
	}
*/
      }
        else
      if (extcmp(filename_php,".htm")==1 || extcmp(filename_php,".html")==1)
      {
        if (html==1 && extcmp(filename_php,".htm")==1)
        {
          change_extension(filename_php,".html");
        }

        convert(filename_asp,filename_php);
      }
        else
      {
        if (pngs==1 && extcmp(filename_php,".gif")==1)
        {
          change_extension(filename_php,".png");
	  sprintf(newdir,"convert \"%s\" \"%s\"",filename_asp,filename_php);
        }
          else
	{ sprintf(newdir,"cp \"%s\" \"%s\"",filename_asp,filename_php); }

        if (system(newdir)!=0)
	{
          printf("Error: Couldn't copy file: %s\n\n",filename_asp);
	  return 1;
	}
      }
    }
  }

  closedir(dp_asp);
  return 0; 
}

void start (char *infile, char *outfile)
{
char sourcedir[2048];
char targetdir[2048];
char command[2048];
DIR *dp_asp;
DIR *dp_php;
int t;

/* if something looks redundant it's cause I took this code
   from GTKap2php and adapted it to work here :) */

  strcpy(sourcedir,infile);
  strcpy(targetdir,outfile);

  t=strlen(sourcedir);
  while (t>0 && sourcedir[t-1]=='/') { sourcedir[t-1]=0; t--; }
  t=strlen(targetdir);
  while (t>0 && targetdir[t-1]=='/') { targetdir[t-1]=0; t--; }

  dp_asp=opendir(sourcedir);
  if (dp_asp==0)
  {
    printf("Error: ASP Source Dir %s doesn't exist.\n\n",sourcedir);
    return;
  } 
  
  dp_php=opendir(targetdir);
  if (dp_php==0)
  {
    printf("Creating PHP target dir: %s\n\n",targetdir);

    sprintf(command,"mkdir -p \"%s\"",targetdir);
    t=system(command);

    if (t!=0)
    {
      printf("Error: Couldn't create PHP target dir\n\n");
      return;
    }

    // closedir(dp_php);
    dp_php=opendir(targetdir);

    if (dp_php==0)
    {
      printf("Error: Couldn't create PHP target dir\n");
      return;
    }
  }

  closedir(dp_asp);
  closedir(dp_php);

  printf("Source Dir: %s\n",sourcedir);
  printf("Target Dir: %s\n\n",targetdir);

  fflush(stdout);
/*  printf("copying files\n"); */

  if (copyfiles(sourcedir,targetdir)==1)
  { return; }

}

void convert(char *infile, char *outfile)
{
int t,tokentype,ch,lastchar;
char token[TOKENSIZE];
char temp[TOKENSIZE];

  add_session=0;
  objectsptr=0;
  infunct=0;
  functptr=0;
  indent=0;
  line=1;
  column=0;
  javascript=0;
  loopcount=0;

  if (strlen(outfile)==0)
  {
    strcpy(outfile,infile);
    t=strlen(outfile);
    while (outfile[t]!='.' && t>0) t--;
    if (t!=0) outfile[t]=0;

    if (php==0)
    { strcat(outfile,".php"); }
      else
    if (php==3)
    { strcat(outfile,".php3"); }
      else
    if (php==4)
    { strcat(outfile,".php4"); }
  }

  in=fopen(infile,"r");
  if (in==NULL)
  { printf("Error reading file: %s\n",infile); exit(1); }

  out=fopen(outfile,"w");
  if (out==NULL)
  { printf("Error opening output file: %s\n",outfile); exit(1); }

  printf("Opening file: %s\n",infile);
  printf("Creating file: %s\n\n",outfile);

  while((ch=getc(in))!=EOF)
  {
    if (lastchar=='<' && ch=='%')
    {
      while((tokentype=gettoken(token))!=0)
      {
	if (tokentype==6) break;
	if (strcasecmp(token,"isnumeric")==0) add_isnum=1;
	if (strcasecmp(token,"bof")==0) BOF=1;
	if (strcasecmp(token,"function")==0)
	{
	  tokentype=gettoken(token);
	  strcpy(funct[functptr++],token);
	}
	  else
	if (strcasecmp(token,"sub")==0)
	{
	  tokentype=gettoken(token);
	  strcpy(funct[functptr++],token);
	}

	if (strcasecmp(token,"end")==0)
        { tokentype=gettoken(token); }

	if (strcasecmp(token,"session")==0) 
	{
	  add_session=1;
	  tokentype=gettoken(token);
	  if (strcmp(token,"(")==0)
	  {
	    tokentype=gettoken(token);

	    if (tokentype==10 || tokentype==11)
	    {
	      t=gettoken(temp);

	      if (strcmp(temp,")")==0)
	      {
                for (t=0; t<sessionptr; t++)
                {
                  if (strcmp(token,sessionpool[t])==0) break;
                }
              }
                else
              { t=0; }

              if (sessionptr==t)
              {
                strcpy(sessionpool[sessionptr++],token);
              }
            }
	  }
	}
      }
    }
    lastchar=ch;
  }

  fclose(in);

  for (t=0; t<80; t++)
  { objects[t][0]=0; }

  in=fopen(infile,"r");
  if (in==NULL)
  { printf("Error reading file: %s\n",infile); exit(1); }

  if (add_session==1) insert_session();
  if (global_asa==1) { fprintf(out,"<? include('global.php'); ?>\n"); }

  line=1;
  parse();
/*
  if (parse()==1)
  { printf("Parse Error occurred\n"); }
*/
  putc('\n',out);

  printf("Done.\n");

  fclose(in);
  fclose(out);
}

int main(int argc, char *argv[])
{
char infile[2048];
char outfile[2048];
int supress=0,dirr=0,t;

  if (argc<2)
  {
    printf("Usage: asp2php <infile.asp> -o <output filename>\n");
    printf("          -dir (infile/outfile are dirs [READ DOCS!!])\n");
    printf("          -mysql -odbc -oracle -sybase -postgres (to select database)\n");
    printf("          -uid <database username>\n");
    printf("          -passwd <database password>\n");
    printf("          -database <database name or sid>\n");
    printf("          -address <database ip address or ip name>\n");
    printf("          -dsn <database ODBC dsn>\n");
    printf("          -pngs (for Unipiss mode [read docs])\n");
    printf("          -y2k (if your asp came from a non-y2k compliant NT Box)\n");
    printf("          -php3 or -php4 (change extension to .php3 or .php4 instead of .php)\n");
    printf("          -toupper (change all variables to uppercase)\n");
    printf("          -tolower (change all variables to lowercase)\n");
    printf("          -html (change all references from htm to html)\n");
    printf("          -includes (change #inludes to php requires())\n");
    printf("          -addextension .xxx (filenames with .xxx extension get asp2php translated)\n");
    printf("          -spacer (space things out more)\n");
    printf("          -global_asa (include global.php in all pages)\n\n");
    printf(VERSION);
    exit(1);
  }

  strcpy(infile,argv[1]);
  strcpy(outfile,"");

  global_uid[0]=0;
  global_passwd[0]=0;
  global_dsn[0]=0;
  global_database[0]=0;
  global_address[0]=0;

  strcpy(aspextensions[aspextensions_ptr++],".asp");
  strcpy(aspextensions[aspextensions_ptr++],".asa");

  for(t=2; t<argc; t++)
  {
    if (strcasecmp(argv[t],"-o")==0)
    { strcpy(outfile,argv[++t]); }
      else
    if (strcasecmp(argv[t],"-mysql")==0)
    { database_type=0; }
      else
    if (strcasecmp(argv[t],"-odbc")==0)
    { database_type=1; }
      else
    if (strcasecmp(argv[t],"-oracle")==0)
    { database_type=2; }
      else
    if (strcasecmp(argv[t],"-sybase")==0)
    { database_type=3; }
      else
    if (strcasecmp(argv[t],"-postgres")==0)
    { database_type=4; }
      else
    if (strcasecmp(argv[t],"-uid")==0)
    { strcpy(global_uid,argv[++t]); }
      else
    if (strcasecmp(argv[t],"-y2k")==0)
    { y2k=0; }
      else
    if (strcasecmp(argv[t],"-passwd")==0)
    { strcpy(global_passwd,argv[++t]); }
      else
    if (strcasecmp(argv[t],"-database")==0)
    { strcpy(global_database,argv[++t]); }
      else
    if (strcasecmp(argv[t],"-address")==0)
    { strcpy(global_address,argv[++t]); }
      else
    if (strcasecmp(argv[t],"-dsn")==0)
    { strcpy(global_dsn,argv[++t]); }
      else
    if (strcasecmp(argv[t],"-supress")==0)
    { supress=1; }
      else
    if (strcasecmp(argv[t],"-pngs")==0)
    { pngs=1; }
      else
    if (strcasecmp(argv[t],"-toupper")==0)
    { casesense=2; }
      else
    if (strcasecmp(argv[t],"-tolower")==0)
    { casesense=1; }
      else
    if (strcasecmp(argv[t],"-php3")==0)
    { php=3; }
      else
    if (strcasecmp(argv[t],"-php4")==0)
    { php=4; }
      else
    if (strcasecmp(argv[t],"-dir")==0)
    { dirr=1; }
      else
    if (strcasecmp(argv[t],"-html")==0)
    { html=1; }
      else
    if (strcasecmp(argv[t],"-spacer")==0)
    { spacer=1; }
      else
    if (strcasecmp(argv[t],"-requestvar")==0)
    { requestvar=1; }
      else
    if (strcasecmp(argv[t],"-includes")==0)
    { includes=1; }
      else
    if (strcasecmp(argv[t],"-addextension")==0)
    { strcpy(aspextensions[aspextensions_ptr++],argv[++t]); }
      else
    if (strcasecmp(argv[t],"-global_asa")==0)
    { global_asa=1; }
      else
    { printf("Unknown option: %s\n",argv[t]); }
  }

  if (supress==0)
  {
    printf("-----------------------------------------------------\n");
    printf(VERSION);
    printf("-----------------------------------------------------\n\n");
  }

  if (pngs==1)
  { printf("Unipiss mode: convert all gifs to pngs\n\n"); }

  if (dirr==1)
  { 
    printf("The following extensions will be treated as asp:\n\n");

    for (t=0; t<aspextensions_ptr; t++)
    {
      printf("-->  %s\n",aspextensions[t]);
    }

    if (outfile[0]==0)
    { printf("You must set the output dir with the -o option.\n\n"); }
      else
    { start(infile,outfile); }
  }
    else
  { convert(infile,outfile); }

  return 0;
}

