#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "globals.h"
#include "functions.h"


int parse()
{
char token[1024];
int tokentype;

  copyhtml();

  while((tokentype=gettoken(token))!=0)
  {
    if (add_isnum==1 && php==3)
    { insert_isnum(); }

    if (tokentype==15)
    { fprintf(out,"%s",token); }
      else
    if (tokentype==5)
    { fprintf(out,"\n"); }
      else
    if (tokentype==6)
    { 
      putc('?',out);
      putc('>',out);
      if (copyhtml()==1) return 0;
      continue;
    }
      else
    if (strcmp(token,"<")==0)
    {
      if (is_endscript()==1)
      {
        putc('?',out);
        putc('>',out);
        if (copyhtml()==1) return 0;
        continue;
      }
    }
      else
    if (tokentype==11)
    { eval_token(tokentype,token); }
      else
    { 
      if (tokentype==2 || strcmp(token,"=")==0) 
      eval_token(tokentype,token); 
    }
  }

  return 1;
}

int parse_body(int iflag)
{
char token[TOKENSIZE];
char tmptoken[TOKENSIZE];
char newtoken[LINELENGTH];
int tokentype,c,ch;

  while((tokentype=gettoken(token))!=0)
  {
    if (tokentype==5 && iflag==1)
    { break; }
      else
    if (tokentype==5)
    { putc('\n',out);  /* THIS MIGHT SUCK */  }
      else
    if (tokentype==6)
    {
      if (iflag==1)
      {
	tokentypepush=tokentype;
	strcpy(tokenpush,token);
	putc('\n',out);
	return 0;
      }

      fprintf(out,"?>"); copyhtml();
    }
      else
    if (strcasecmp(token,"case")==0)
    { strcpy(tokenpush,token); tokentypepush=tokentype; break; }
      else
    if ((strcasecmp(token,"loop")==0 || strcasecmp(token,"wend")==0) ||
         (strcasecmp(token,"end")==0 || strcasecmp(token,"next")==0))
    { break; }
      else
    if (strcasecmp(token,"elseif")==0)
    { 
      indent--;
      autoindent();
      fprintf(out,"}\n");
      autoindent();
      fprintf(out,"  else\n");
      autoindent();
      fprintf(out,"if ");

      parse_condition();
      tokentype=gettoken(token);

      fprintf(out,"\n");
      autoindent();
      fprintf(out,"{\n");
      indent++;
    }
      else
    if (strcasecmp(token,"session")==0)
    { parse_session(); }
      else
    if (strcasecmp(token,"else")==0)
    { 
      indent--;
      autoindent();
      fprintf(out,"}\n");
      autoindent();
      fprintf(out,"  else\n");
      autoindent();
      fprintf(out,"{\n");
      indent++;
    }
      else
    if (tokentype==15)
    { fprintf(out,"%s",token); }
      else
    if (tokentype==0)
    { return 0; }
      else
    if (isfunction(token)==1)
    {
      strcpy(tmptoken,token);
      c=gettoken(token);
      if (strcmp(token,"=")==0)
      {
        autoindent();
	fprintf(out,"return ");
	eval_expression(" ");
      }
	else
      if (strcmp(token,"(")==0)
      {
        autoindent();
	fprintf(out,"%s(",tmptoken);
        push(token,tokentype);
	eval_funct(newtoken);
	fprintf(out,"%s);",newtoken);
      }
	else
      {
	error(token,"= or (","body");
      }
    }
      else
    if (tokentype==2 || strcmp("=",token)==0) 
    { 
      eval_token(tokentype,token); 
    }
      else
    if (tokentype==11)
    {
      /* This kinda sucks but.. if token is 11 at the beginning of the line
      lets assume that it's a comment line.. this might cause problems..
      if you have problems, comment this crap out */
      fprintf(out,"//%s",&token[1]);
      ch=0;
      while (ch!='\r' && ch!='\n')
      {
        if (pushback!=-1)
        { ch=pushback; pushback=-1; }
          else
        { ch=getc(in); }
        if (ch==EOF) break;

        if (ch=='%')
        {
          ch=getc(in);
          if (ch=='>')
          {
            putc('?',out);
            putc('>',out);
            copyhtml();
            return 0;
          }
            else
          { putc('%',out);}
        }

        putc(ch,out);
      }
      line++;
      pushback=getc(in);
      if (pushback=='\n' || pushback=='\r')
      { if (ch!=pushback) pushback=-1; }
    }
   
    if (iflag==1) break;
  }
 
  if (tokentype==5) { putc('\n',out); }
  if (strcasecmp(token,"end")==0) return 1;

  return 0;
}

int parse_command_set(char *newtoken,char *variable)
{
int tokentype;
char token[TOKENSIZE];

  tokentype=gettoken(token);
  strcpy(newtoken,"");

  if (tokentype==2)
  {
    autoindent();
    fprintf(out,"$%s_%s=",variable,token);

    tokentype=gettoken(token);

    if (strcmp(token,"=")!=0)
    { error(token,"=","Command Object"); }
    eval_expression(" ");
  }

  return 0;
}

int parse_command(char *newtoken,char *variable)
{
int tokentype;
char token[TOKENSIZE];
char temp[1024];

  sprintf(newtoken,"%s",variable);

  while(1)
  {
    tokentype=gettoken(token);

    if (tokentype!=2)
    { push(token,tokentype); break; }

    sprintf(temp,"_%s",token);

    tokentype=gettoken(token);

    if (strcmp(token,".")!=0)
    { push(token,tokentype); break; }
  }

  return 0;
}

int parse_server(char *newtoken)
{
int tokentype;
char token[TOKENSIZE];
char temptoken[LINELENGTH];

  if ((tokentype=gettoken(token))!=14)
  {
    error(token,".","Server");
    return 0;
  }

  tokentype=gettoken(token);

  if (strcasecmp(token,"htmlencode")==0)
  { 
    strcat(newtoken,"htmlspecialchars("); 
    eval_funct(newtoken); 
    strcat(newtoken,")");
  } 
    else
  if (strcasecmp(token,"urlencode")==0)
  { 
    strcat(newtoken,"rawurlencode("); 
    eval_funct(newtoken); 
    strcat(newtoken,")");
  } 
    else
  if (strcasecmp(token,"scripttimeout")==0)
  {
    tokentype=gettoken(token);
    if (strcmp(token,"=")!=0)
    { error(token,"=","ScriptTimeOut"); }
    strcat(newtoken,"set_time_limit(");
    eval_molecule(temptoken);
    strcat(newtoken,temptoken);
    strcat(newtoken,");\n");
  } 
    else
  { strcat(newtoken,"// asp2php says 'huh'?: "); eval_expression(" "); }

  return 0;
}

int parse_set(char *newtoken)
{
int tokentype;
char token[TOKENSIZE];
char temptoken[TOKENSIZE];
char temp_spaces[100];
int t;

  temp_spaces[0]=0;
  tokentype=gettoken(token);

  for (t=0; t<objectsptr; t++)
  { if (strcasecmp(token,objects[t])==0) break; }

  strcpy(temptoken,token);

  if (t<objectsptr && getobject(token)==3)
  {
    tokentype=gettoken(token);
    if (strcmp(token,".")==0)
    {
      tokentype=gettoken(token);
      sprintf(newtoken,"$%s_%s=",temptoken,token);

      tokentype=gettoken(token);
      if (strcmp(token,"=")!=0)
      { error(token,"=","Set"); }

      tokentype=gettoken(token);
      if (getobject(token)==1)
      {
        strcat(newtoken,"$");
        strcat(newtoken,token);
      }

      while(tokentype!=5)
      { tokentype=gettoken(token); }

      strcat(newtoken,";");
      strcat(newtoken,"\n");

      return 0;
    }
      else
    { push(token,tokentype); }
  }

  strcpy(objects[t],token);
  strcpy(objectstype[t],"unkown");
  if (t==objectsptr) objectsptr++;

  tokentype=gettoken(token);
  if (strcmp(token,"=")!=0)
  { error(token,"=","Set"); }

  tokentype=gettoken(token);
  if (strcasecmp(token,"nothing")==0)
  { 
    add_indent(temp_spaces);
    sprintf(newtoken,"%s$%s=null;\n",temp_spaces,temptoken); 
  }
    else
  if (strcasecmp(token,"server")==0)
  {
    tokentype=gettoken(token);
    if (strcmp(token,".")!=0)
    { error(token,".","Server"); }

    tokentype=gettoken(token);
    if (strcasecmp(token,"createobject")==0)
    {
      tokentype=gettoken(token);
      if (strcmp(token,"(")!=0)
      { error(token,"(","CreateObject"); }

      tokentype=gettoken(token);
      if (tokentype!=10 && tokentype!=11)
      { error(token,"String Literal","CreateObject"); }

      strcpy(objectstype[t],token);
      if (t==objectsptr) objectsptr++;

      tokentype=gettoken(token);
      if (strcmp(token,")")!=0)
      { error(token,")","CreateObject"); }
      sprintf(newtoken,"// $%s is of type %s\n",objects[t],objectstype[t]);
    }
      else
    {
      setvar=t;
      eval_element(newtoken,tokentype,token);
      setvar=0;
      sprintf(newtoken,"// $%s is of type %s\n",objects[t],objectstype[t]);
    } 
    
  }
    else
  {
/* printf("Set NOT SERVER (eval_element): %s\n",token); */
    setvar=t;
    eval_element(newtoken,tokentype,token);
/* printf("came back: %s\n",newtoken); */
    setvar=0;
/*
    strcpy(tokenpush,token);
    tokentypepush=tokentype;
    eval_molecule(temptoken);
    sprintf(newtoken,"$%s=",objects[t]);
    strcat(newtoken,temptoken);
*/
  }

  return 0;
}

int parse_rem()
{
int ch;

  fprintf(out,"// ");

  while((ch=getc(in)))
  {
    if (ch=='\r') ch='\n';
    putc(ch,out);
    if (ch=='\n' || ch==EOF) return 0;
  }

  return 0;
}

int parse_dim()
{
char token[TOKENSIZE];
int tokentype;

  while((tokentype=gettoken(token))!=0)
  {
    if (tokentype==5 || tokentype==13) break;
  }
  return 0;

  while((tokentype=gettoken(token))!=0)
  {
    if (tokentype==6)
    {
      strcpy(tokenpush,token);
      tokentypepush=tokentype;
      return 0; 
    }
      else
    if (tokentype==5 || tokentype==13)
    { putc('\n',out); return 0; }
      else
    if (tokentype!=2 && tokentype!=16)
    { error(token,", or variable","Dim"); }
      else
    if (tokentype==2)
    { fprintf(out,"$%s=0; ",token); }
  } 

  return 0;
}

int parse_at()
{
int tokentype;
char token[TOKENSIZE];

  while((tokentype=gettoken(token))!=0)
  {
    if (tokentype==6)
    {
      strcpy(tokenpush,token);
      tokentypepush=tokentype;
      return 0; 
    }
      else
    if (tokentype==5 || tokentype==13)
    { break; }
      else
    if (strcasecmp(token,"language")==0)
    { fprintf(out,"// LANGUAGE = asp2php converted\n"); }
  }

  return 0;
}


int parse_randomize()
{
int tokentype;
char token[TOKENSIZE];

  while(tokentype!=5)
  {
    tokentype=gettoken(token);
  }

  autoindent();
  fprintf(out,"mt_srand((double)microtime()*1000000);\n");

  return 0;
}

