#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <sys/types.h>
#include <sys/stat.h>

int convert=0;
GtkWidget *File_asp_dir;
GtkWidget *File_php_dir;
GtkWidget *Text_aspdir;
GtkWidget *Text_phpdir;
GtkWidget *Status;
GtkWidget *Dialog_help;
GtkWidget *Combo_database;
GtkWidget *Combo_case;
GtkWidget *Combo_php;
int context_id,status_count=0;
int pngs=0;

char help_message[1024]={ "GTK ASP 2 PHP - By Michael Kohn\n\n"
                  "To use:\n"
                  "(1) Select source asp dir by clicking on 'Select ASP Dir' button\n"
                  "(2) Select target php dir by clicking on 'Select PHP Dir' button\n"
                  "(3) Press 'Start Convert' button\n\n"
                  "NOTE: If you type in a directory for PHP Target dir and it doesn't\n"
                  "exist, ASP 2 PHP will create all dirs needed to make the target exist\n\n"
                  "If you put GTK ASP 2 PHP into Unipiss mode (to convert GIFS to PNGS)\n"
                  "you must have ImageMagick's convert program in your path."};

void clear_status()
{

  while(status_count)
  {
    gtk_statusbar_pop(GTK_STATUSBAR(Status),(guint) &context_id);
    status_count--;
  }
}

void selected_asp (GtkWidget *widget, gpointer data)
{
  if (convert==0)
  {
    clear_status();
    gtk_widget_show (File_asp_dir);
  }
}

void selected_php (GtkWidget *widget, gpointer data)
{
  if (convert==0)
  {
    clear_status();
    gtk_widget_show (File_php_dir);
  }
}

int copyfiles(char *sourcedir, char *targetdir, char *arguments)
{
DIR *dp_asp;
DIR *dp_php;
struct dirent *direntp;
struct stat statbuf;
char newdir[2048];
char filename_asp[256];
char filename_php[256];
int t;

  dp_asp=opendir(sourcedir);

  while ((direntp=readdir(dp_asp))!=NULL)
  {
    if (convert==0) 
    {
      gtk_statusbar_push(GTK_STATUSBAR(Status),(guint) &context_id, "ASP2PHP Cancelled By User");
      status_count++;
      return 1;
    }

    if (strcmp(direntp->d_name,".")==0) continue;
    if (strcmp(direntp->d_name,"..")==0) continue;

    sprintf(filename_asp,"%s/%s",sourcedir,direntp->d_name);
    gtk_statusbar_push(GTK_STATUSBAR(Status),(guint) &context_id, filename_asp);
    status_count++;

    if (stat(filename_asp,&statbuf)==-1)
    {
      gtk_statusbar_push(GTK_STATUSBAR(Status),(guint) &context_id, "Error: Couldn't stat file");
      status_count++;
      return 1;
    }

    if (statbuf.st_mode & S_IFDIR)
    {
      sprintf(filename_php,"%s/%s",targetdir,direntp->d_name);
      sprintf(filename_asp,"%s/%s",sourcedir,direntp->d_name);

      dp_php=opendir(filename_php);

      if (dp_php==0)
      {
        sprintf(newdir,"mkdir -p \"%s\"",filename_php);
	if (system(newdir)!=0)
        {
          gtk_statusbar_push(GTK_STATUSBAR(Status),(guint) &context_id, "Error: Couldn't create dir");
          status_count++;
	  return 1;
        }
      }

      if (copyfiles(filename_asp,filename_php,arguments)==1) return 1;
    }
      else
    {
      sprintf(filename_php,"%s/%s",targetdir,direntp->d_name);
      sprintf(filename_asp,"%s/%s",sourcedir,direntp->d_name);

      t=strlen(filename_php);

      if (t>3 &&
          (tolower(filename_php[t-4])=='.' && tolower(filename_php[t-3])=='a') &&
          (tolower(filename_php[t-2])=='s' && tolower(filename_php[t-1])=='p'))
      {
        filename_php[t-3]='p';
        filename_php[t-2]='h';
        filename_php[t-1]='p';

        if (strcmp("-php3",gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(Combo_php)->entry)))==0)
        { filename_php[t]='3'; }
          else
        if (strcmp("-php4",gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(Combo_php)->entry)))==0)
        { filename_php[t]='4'; }
          else
        { filename_php[t]=0; }

        filename_php[t+1]=0;

        if (pngs==0)
	{ sprintf(newdir,"asp2php \"%s\" -o \"%s\"",filename_asp,filename_php); }
	  else
	{ sprintf(newdir,"asp2php \"%s\" -o \"%s\" -pngs",filename_asp,filename_php); }

        strcat(newdir,arguments);

        if (system(newdir)!=0)
	{
          gtk_statusbar_push(GTK_STATUSBAR(Status),(guint) &context_id, "Error: Couldn't copy file");
          status_count++;
	  return 1;
	}
      }
        else
      if (t>3 &&
          (tolower(filename_php[t-4])=='.' && tolower(filename_php[t-3])=='h') &&
          (tolower(filename_php[t-2])=='t' && tolower(filename_php[t-1])=='m'))
      {
        filename_php[t-3]='h';
        filename_php[t-2]='t';
        filename_php[t-1]='m';
        filename_php[t]='l';
        filename_php[t+1]=0;

        if (pngs==1)
	{ sprintf(newdir,"unipiss \"%s\" \"%s\"",filename_asp,filename_php); }
	  else
	{ sprintf(newdir,"cp \"%s\" \"%s\"",filename_asp,filename_php); }

        if (system(newdir)!=0)
	{
          gtk_statusbar_push(GTK_STATUSBAR(Status),(guint) &context_id, "Error: Couldn't copy file");
          status_count++;
	  return 1;
	}
      }
        else
      {
        if (((t>4 && pngs==1) && tolower(filename_php[t-5])=='.') &&
          (tolower(filename_php[t-4])=='h' && tolower(filename_php[t-3])=='t') &&
          (tolower(filename_php[t-2])=='m' && tolower(filename_php[t-1])=='l'))
        {
	  sprintf(newdir,"unipiss \"%s\" \"%s\"",filename_asp,filename_php);
        }
          else
        if ((t>3 && pngs==1) &&
          (tolower(filename_php[t-4])=='.' && tolower(filename_php[t-3])=='g') &&
          (tolower(filename_php[t-2])=='i' && tolower(filename_php[t-1])=='f'))
        {
          filename_php[t-3]='p';
          filename_php[t-2]='n';
          filename_php[t-1]='g';
          filename_php[t]=0;
	  sprintf(newdir,"convert \"%s\" \"%s\"",filename_asp,filename_php);
        }
          else
	{ sprintf(newdir,"cp \"%s\" \"%s\"",filename_asp,filename_php); }

        if (system(newdir)!=0)
	{
          gtk_statusbar_push(GTK_STATUSBAR(Status),(guint) &context_id, "Error: Couldn't copy file");
          status_count++;
	  return 1;
	}
      }

    }

    gtk_statusbar_pop(GTK_STATUSBAR(Status),(guint) &context_id);
    status_count--;
  }

  closedir(dp_asp);
  return 0; 
}

void start (GtkWidget *widget, gpointer data)
{
char sourcedir[2048];
char targetdir[2048];
char command[2048];
char arguments[2048];
DIR *dp_asp;
DIR *dp_php;
int t;

  convert=1;
  strcpy(sourcedir,gtk_entry_get_text(GTK_ENTRY(Text_aspdir)));
  strcpy(targetdir,gtk_entry_get_text(GTK_ENTRY(Text_phpdir)));

  strcpy(arguments,"");

  if (strcmp("none",gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(Combo_database)->entry)))!=0)
  {
    strcat(arguments," ");
    strcat(arguments,gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(Combo_database)->entry)));
  }

  if (strcmp("none",gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(Combo_case)->entry)))!=0)
  {
    strcat(arguments," ");
    strcat(arguments,gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(Combo_case)->entry)));
  }

  if (strcmp("-php3",gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(Combo_php)->entry)))==0)
  {
    strcat(arguments," ");
    strcat(arguments,gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(Combo_php)->entry)));
  }
    else
  if (strcmp("-php4",gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(Combo_php)->entry)))==0)
  {
    strcat(arguments," ");
    strcat(arguments,gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(Combo_php)->entry)));
  }

/*
  sprintf(arguments,"%s\n",gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(Combo_database)->entry)));
*/

  t=strlen(sourcedir);
  while (t>0 && sourcedir[t-1]=='/') { sourcedir[t-1]=0; t--; }
  t=strlen(targetdir);
  while (t>0 && targetdir[t-1]=='/') { targetdir[t-1]=0; t--; }

  gtk_statusbar_push(GTK_STATUSBAR(Status),(guint) &context_id, "Checking to see if directories exist");
  status_count++;
 
  dp_asp=opendir(sourcedir);
  if (dp_asp==0)
  {
    gtk_statusbar_push(GTK_STATUSBAR(Status),(guint) &context_id, "Error: ASP Source Dir doesn't exist");
    status_count++;
    convert=0;
    return;
  } 
  
  dp_php=opendir(targetdir);
  if (dp_php==0)
  {
    gtk_statusbar_push(GTK_STATUSBAR(Status),(guint) &context_id, "Creating PHP target dir");
    status_count++;

    sprintf(command,"mkdir -p \"%s\"",targetdir);
    t=system(command);

    if (t!=0)
    {
      gtk_statusbar_push(GTK_STATUSBAR(Status),(guint) &context_id, "Error: Couldn't create PHP target dir");
      status_count++;
      convert=0;
      return;
    }

    gtk_statusbar_pop(GTK_STATUSBAR(Status),(guint) &context_id);
    status_count--;

    closedir(dp_php);
    dp_php=opendir(targetdir);
    if (dp_php==0)
    {
      gtk_statusbar_push(GTK_STATUSBAR(Status),(guint) &context_id, "Error: Couldn't create PHP target dir");
      status_count++;
      convert=0;
      return;
    }
  }

  closedir(dp_asp);
  closedir(dp_php);

/*  printf("copying files\n"); */

  if (copyfiles(sourcedir,targetdir,arguments)==1)
  { convert=0; return; }

  gtk_statusbar_push(GTK_STATUSBAR(Status),(guint) &context_id, "Successfully copied/transformed files");
  status_count++;

  convert=0;
}

void stop (GtkWidget *widget, gpointer data)
{
  gtk_statusbar_push(GTK_STATUSBAR(Status),(guint) &context_id, "ASP 2 PHP stopped by user");
  status_count++;
  convert=0;
}

void help_close (GtkWidget *widget, gpointer data)
{
  gtk_widget_hide(Dialog_help);
}

void help (GtkWidget *widget, gpointer data)
{
  if (convert==0)
  {
    clear_status();
    gtk_widget_show (Dialog_help);
  }
}

void change_png (GtkWidget *widget, gpointer data)
{
  if (pngs==0)
  { pngs=1; }
    else
  { pngs=0; }
}

void quit (GtkWidget *widget, gpointer data)
{
  gtk_main_quit();
}

void selected_db (GtkWidget *widget, gpointer data)
{
  clear_status();
  g_print ("selected: %s\n",data);
  convert=0;
}

void asp_dir_selected(GtkWidget *widget, GtkFileSelection *fs)
{
  gtk_entry_set_text((GtkEntry *)Text_aspdir,gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));
  gtk_widget_hide (File_asp_dir); 
}

void asp_dir_hide(GtkWidget *widget, GtkFileSelection *fs)
{
  gtk_widget_hide (File_asp_dir); 
}

void php_dir_selected(GtkWidget *widget, GtkFileSelection *fs)
{
  gtk_entry_set_text((GtkEntry *)Text_phpdir,gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));
  gtk_widget_hide (File_php_dir); 
}

void php_dir_hide(GtkWidget *widget, GtkFileSelection *fs)
{
  gtk_widget_hide (File_php_dir); 
}

gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
  gtk_main_quit();
  return (TRUE);
}

void destroy (GtkWidget *widget, gpointer data)
{
  gtk_main_quit();
}

void set_status()
{
  context_id=gtk_statusbar_get_context_id(GTK_STATUSBAR(Status), "Statusbar");
  gtk_statusbar_push(GTK_STATUSBAR(Status),(guint) &context_id, "Copyright 2000 by Michael Kohn   License: GPL");
}

int main (int argc, char *argv[])
{
GtkWidget *window;
GtkWidget *Button_select_asp;
GtkWidget *Button_select_php;
GtkWidget *Button_start;
GtkWidget *Button_stop;
GtkWidget *Button_help;
GtkWidget *Button_quit;
GtkWidget *Box_right;
GtkWidget *Box_left;
GtkWidget *Box_main;
GtkWidget *Box_main_full;
GtkWidget *Label_aspdir;
GtkWidget *Label_phpdir;
GtkWidget *Label_database;
GtkWidget *Label_case;
GtkWidget *Label_php;
GtkWidget *pixmapwid;
GtkWidget *Dialog_button;
GtkWidget *Dialog_label;
GtkWidget *Check_png;
GtkStyle *style;
GdkBitmap *mask;
GdkPixmap *Pixmap_asp2php;
GList *dlist,*dlist_case,*dlist_php;

  gtk_init (&argc, &argv);
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), "GTK - ASP 2 PHP");

  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
                      GTK_SIGNAL_FUNC (delete_event), NULL);
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
                      GTK_SIGNAL_FUNC (destroy), NULL);
  gtk_container_border_width (GTK_CONTAINER (window), 10);

  Box_right=gtk_vbox_new(FALSE, 0);
  Box_left=gtk_vbox_new(FALSE, 0);
  Box_main=gtk_hbox_new(FALSE, 0);
  Box_main_full=gtk_vbox_new(FALSE, 0);

  gtk_container_border_width (GTK_CONTAINER (Box_left), 10);
  gtk_container_border_width (GTK_CONTAINER (Box_main), 10);

  Status=gtk_statusbar_new();
  set_status();

  Label_aspdir=gtk_label_new("ASP Dir (Source):");
  Label_phpdir=gtk_label_new("PHP Dir (Target)");
  Label_database=gtk_label_new("Database");
  Label_case=gtk_label_new("Variable Case Change");
  Label_php=gtk_label_new("PHP File Extension");

  Text_aspdir=gtk_entry_new_with_max_length(1024);
  Text_phpdir=gtk_entry_new_with_max_length(1024);

  Dialog_help=gtk_dialog_new();
  Dialog_button=gtk_button_new_with_label("Close Help");
  gtk_signal_connect (GTK_OBJECT (Dialog_button), "clicked",
                      GTK_SIGNAL_FUNC (help_close), NULL);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(Dialog_help)->action_area),
          Dialog_button, TRUE, TRUE, 0);
  Dialog_label=gtk_label_new(help_message);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(Dialog_help)->vbox),Dialog_label,
          TRUE,TRUE,0);
  gtk_container_border_width (GTK_CONTAINER (Dialog_help), 10);
  gtk_widget_show(Dialog_label);
  gtk_widget_show(Dialog_button);

  Combo_database=gtk_combo_new();
  dlist=NULL;
  dlist=g_list_prepend(dlist,"-sybase"); 
  dlist=g_list_prepend(dlist,"-oracle"); 
  dlist=g_list_prepend(dlist,"-odbc"); 
  dlist=g_list_prepend(dlist,"-mysql"); 
  dlist=g_list_prepend(dlist,"-postgres"); 
  dlist=g_list_prepend(dlist,"none"); 
  gtk_combo_set_popdown_strings((GtkCombo *)Combo_database, dlist);

  Combo_case=gtk_combo_new();
  dlist_case=NULL;
  dlist_case=g_list_prepend(dlist_case,"-toupper");
  dlist_case=g_list_prepend(dlist_case,"-tolower");
  dlist_case=g_list_prepend(dlist_case,"none");
  gtk_combo_set_popdown_strings((GtkCombo *)Combo_case, dlist_case);

  Combo_php=gtk_combo_new();
  dlist_php=NULL;
  dlist_php=g_list_prepend(dlist_php,"-php3");
  dlist_php=g_list_prepend(dlist_php,"-php4");
  dlist_php=g_list_prepend(dlist_php,"php");
  gtk_combo_set_popdown_strings((GtkCombo *)Combo_php, dlist_php);

/*
  gtk_signal_connect (GTK_OBJECT (Combo_database), "selection_changed",
                      GTK_SIGNAL_FUNC (selected_db), NULL);
*/

  File_asp_dir=gtk_file_selection_new("ASP Source Dir");
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(File_asp_dir)->ok_button),
                     "clicked",(GtkSignalFunc) asp_dir_selected, File_asp_dir);
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(File_asp_dir)->cancel_button),
                     "clicked",(GtkSignalFunc) asp_dir_hide, File_asp_dir);

  File_php_dir=gtk_file_selection_new("PHP Target Dir");
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(File_php_dir)->ok_button),
                     "clicked",(GtkSignalFunc) php_dir_selected, File_php_dir);
  gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(File_php_dir)->cancel_button),
                     "clicked",(GtkSignalFunc) php_dir_hide, File_php_dir);

  Check_png=gtk_check_button_new_with_label("Convert PNGs [Unipiss mode]");
  gtk_signal_connect (GTK_OBJECT (Check_png), "pressed",
                      GTK_SIGNAL_FUNC (change_png), NULL);


  Button_select_asp = gtk_button_new_with_label ("Select ASP Dir");
  gtk_signal_connect (GTK_OBJECT (Button_select_asp), "clicked",
                      GTK_SIGNAL_FUNC (selected_asp), NULL);

  Button_select_php = gtk_button_new_with_label ("Select PHP Dir");
  gtk_signal_connect (GTK_OBJECT (Button_select_php), "clicked",
                      GTK_SIGNAL_FUNC (selected_php), NULL);

  Button_start = gtk_button_new_with_label ("Start Convert");
  gtk_signal_connect (GTK_OBJECT (Button_start), "clicked",
                      GTK_SIGNAL_FUNC (start), NULL);

  Button_stop = gtk_button_new_with_label ("Stop Convert");
  gtk_signal_connect (GTK_OBJECT (Button_stop), "clicked",
                      GTK_SIGNAL_FUNC (stop), NULL);

  Button_help = gtk_button_new_with_label ("Help");
  gtk_signal_connect (GTK_OBJECT (Button_help), "clicked",
                      GTK_SIGNAL_FUNC (help), NULL);

  Button_quit = gtk_button_new_with_label ("Quit");
  gtk_signal_connect (GTK_OBJECT (Button_quit), "clicked",
                      GTK_SIGNAL_FUNC (quit), NULL);

  gtk_widget_show(window); 

  style=gtk_widget_get_style(window);
  Pixmap_asp2php=gdk_pixmap_create_from_xpm (window->window, &mask,
				&style->bg[GTK_STATE_NORMAL],
				(gchar *)"asp.xpm");

  pixmapwid=gtk_pixmap_new(Pixmap_asp2php, mask);

  gtk_widget_show(Check_png);

  gtk_container_add (GTK_CONTAINER (Box_right), Button_select_asp);
  gtk_container_add (GTK_CONTAINER (Box_right), Button_select_php);
  gtk_container_add (GTK_CONTAINER (Box_right), Button_start);
  gtk_container_add (GTK_CONTAINER (Box_right), Button_stop);
  gtk_container_add (GTK_CONTAINER (Box_right), Button_help); 
  gtk_container_add (GTK_CONTAINER (Box_right), Button_quit); 
  gtk_container_add (GTK_CONTAINER (Box_left), pixmapwid); 
  gtk_container_add (GTK_CONTAINER (Box_left), Label_aspdir);
  gtk_container_add (GTK_CONTAINER (Box_left), Text_aspdir);
  gtk_container_add (GTK_CONTAINER (Box_left), Label_phpdir);
  gtk_container_add (GTK_CONTAINER (Box_left), Text_phpdir);
  gtk_container_add (GTK_CONTAINER (Box_left), Label_database);
  gtk_container_add (GTK_CONTAINER (Box_left), Combo_database);
  gtk_container_add (GTK_CONTAINER (Box_left), Label_case);
  gtk_container_add (GTK_CONTAINER (Box_left), Combo_case);
  gtk_container_add (GTK_CONTAINER (Box_left), Label_php);
  gtk_container_add (GTK_CONTAINER (Box_left), Combo_php);
  gtk_container_add (GTK_CONTAINER (Box_left), Check_png);
  gtk_container_add (GTK_CONTAINER (Box_main), Box_left);
  gtk_container_add (GTK_CONTAINER (Box_main), Box_right);
  gtk_container_add (GTK_CONTAINER (Box_main_full), Box_main);
  gtk_container_add (GTK_CONTAINER (Box_main_full), Status);
  gtk_container_add (GTK_CONTAINER (window), Box_main_full);

  gtk_widget_show (Button_select_asp); 
  gtk_widget_show (Button_select_php); 
  gtk_widget_show (Button_start); 
  gtk_widget_show (Button_stop);
  gtk_widget_show (Button_help); 
  gtk_widget_show (Button_quit); 
  gtk_widget_show (pixmapwid); 
  gtk_widget_show (Label_aspdir);
  gtk_widget_show (Text_aspdir);
  gtk_widget_show (Label_phpdir);
  gtk_widget_show (Text_phpdir);
  gtk_widget_show (Label_database);
  gtk_widget_show (Combo_database); 
  gtk_widget_show (Label_case);
  gtk_widget_show (Combo_case); 
  gtk_widget_show (Label_php);
  gtk_widget_show (Combo_php); 
  gtk_widget_show (Box_right); 
  gtk_widget_show (Box_left); 
  gtk_widget_show (Box_main); 
  gtk_widget_show (Box_main_full); 
  gtk_widget_show (Status); 

  gtk_main ();
  return 0;
}



