#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "globals.h"
#include "functions.h"


int eval_token(int tokentype,char *token)
{
char temptoken[TOKENSIZE];
char newtoken[1024];
int t,ch;

  if (strcasecmp(token,"exit")==0)
  { 
    if (loopcount==0)
    { 
      autoindent();
      fprintf(out,"exit();"); 
    }
      else
    { 
      autoindent();
      fprintf(out,"break;"); 
    }
  }
    else
  if (strcasecmp(token,"do")==0)
  { parse_do(); }
    else
  if (strcasecmp(token,"while")==0)
  { parse_while(); }
    else
  if (strcasecmp(token,"select")==0)
  { parse_select(); }
    else
  if (strcasecmp(token,"if")==0)
  { parse_if(); }
    else
  if (strcasecmp(token,"rem")==0)
  { parse_rem(); }
    else
  if (strcasecmp(token,"randomize")==0)
  { parse_randomize(); }
    else
  if (strcasecmp(token,"dim")==0)
  { parse_dim(); }
    else
  if (strcasecmp(token,"redim")==0)
  { parse_dim(); }
    else
  if (strcasecmp(token,"option")==0)
  { fprintf(out,"// Option "); eval_expression(" ");  }
    else
  if (tokentype==2 && strcasecmp(token,"set")==0)
  {
    parse_set(newtoken);
    fprintf(out,"%s",newtoken);
  }
    else
  if (strcasecmp(token,"sub")==0)
  { parse_funct(2); }
    else
  if (strcasecmp(token,"function")==0)
  { parse_funct(1); }
    else
  if (strcasecmp(token,"session")==0)
  { parse_session(); }
    else
  if (strcasecmp(token,"response")==0)
  { parse_response(); }
    else
  if (strcasecmp(token,"const")==0)
  { 
    tokentype=gettoken(token);
    eval_expression(token); 
  }
    else
  if (strcasecmp(token,"server")==0)
  {
    parse_server(newtoken);
    fprintf(out,"%s",newtoken);
  }
    else
  if (strcasecmp(token,"for")==0)
  { parse_for(); }
    else
  if (strcmp(token,"@")==0)
  { parse_at(); }
    else
  if (strcmp(token,"=")==0)
  {
    autoindent();
    fprintf(out,"echo ");
    eval_expression(" ");
  }
    else
  if (tokentype==2 && ((t=getobject(token))!=0))
  {
    strcpy(temptoken,token);
    tokentype=gettoken(token);
    if (strcmp(token,".")!=0)
    {
      strcpy(tokenpush,token);
      tokentypepush=tokentype;
    }

    strcase(temptoken);

    if (t==1) 
    { 
      if (database_type==0)
      { parse_adodb_connection_mysql(newtoken,temptoken); }
        else
      if (database_type==1)
      { parse_adodb_connection_odbc(newtoken,temptoken); }
        else
      if (database_type==2)
      { parse_adodb_connection_oracle(newtoken,temptoken); }
        else
      if (database_type==3)
      { parse_adodb_connection_sybase(newtoken,temptoken); }
        else
      if (database_type==4)
      { parse_adodb_connection_pg(newtoken,temptoken); }
    }
      else
    if (t==2) 
    { 
      if (database_type==0)
      { parse_adodb_rs_mysql(newtoken,temptoken); }
        else
      if (database_type==1)
      { parse_adodb_rs_odbc(newtoken,temptoken); }
        else
      if (database_type==2)
      { parse_adodb_rs_oracle(newtoken,temptoken); }
        else
      if (database_type==3)
      { parse_adodb_rs_sybase(newtoken,temptoken); }
        else
      if (database_type==4)
      { parse_adodb_rs_pg(newtoken,temptoken); }
    }
      else
    if (t==3) { parse_command_set(newtoken,temptoken); }
      else
    if (t==6) { parse_mail(newtoken,temptoken); }

    autoindent();
    fprintf(out,"%s",newtoken);
  }
    else
  if (tokentype==11)
  {
    /* This kinda sucks but.. if token is 11 at the beginning of the line
    lets assume that it's a comment line.. this might cause problems..
    if you have problems, comment this crap out */
    fprintf(out,"//%s",&token[1]);
    ch=0;
    while (ch!='\r' && ch!='\n')
    {
      if (pushback!=-1)
      { ch=pushback; pushback=-1; }
        else
      { ch=getc(in); }
      if (ch==EOF) break;

      if (ch=='%')
      {
        ch=getc(in);
        if (ch=='>')
        {
          putc('?',out);
          putc('>',out);
          copyhtml();
          return 0;
        }
          else
        { putc('%',out);}
      }

      putc(ch,out);
    }
    line++;
    pushback=getc(in);
    if (pushback=='\n' || pushback=='\r')
    { if (ch!=pushback) pushback=-1; }
  }
    else
  { 
    if (isfunction(token)==1)
    {
      fprintf(out,"%s",token);
      t=gettoken(token);
      if (strcmp(token,"(")==0)
      {
        sprintf(newtoken,"(");
        push(token,tokentype);
        eval_funct(newtoken);
        strcat(newtoken,");");
        fprintf(out,"%s",newtoken);
      }
        else
      {
        push(token,tokentype);
        fprintf(out,"();");
      }

    }
     else
    { 
      eval_expression(token); 
    }
  }

  return 0;
}

int eval_molecule(char *newtoken)
{
char token[TOKENSIZE];
char temptoken[LINELENGTH];
int tokentype;
int isstring=0;
int r;
int paren=0;

  strcpy(newtoken,"");

  while((tokentype=gettoken(token))!=0)
  {
    if (strcmp(token,"(")==0) paren++;
      else
    if (strcmp(token,")")==0) paren--;

    if (paren<0) return 1;

    if (tokentype==10 || tokentype==11)
    { isstring=1; strcat(newtoken,token); }
      else
    if (tokentype==6)
    {
      tokentypepush=tokentype;
      strcpy(tokenpush,token);
      break;
    }
      else
    if (tokentype==5 || tokentype==13)
    { break; }
      else
    if (strcmp(token,"&")==0)
    { strcat(newtoken,"."); }
      else
    if (strcmp(token,",")==0)
    { break; }
      else
/*
    if (strcmp(token,"+")==0 && isstring==1)
    { strcat(newtoken,"."); }
      else
*/
    if (tokentype==2 && strcasecmp(token,"AND")==0)
    { strcat(newtoken,"&"); }
      else
    if (tokentype==2 && strcasecmp(token,"OR")==0)
    { strcat(newtoken,"|"); }
      else
    if (tokentype==1)
    { strcat(newtoken,token); }
      else
    if (tokentype==3)
    {
      strcat(newtoken,"\n");
      for (r=0; r<indent+1; r++) strcat(newtoken,"  ");
    }
      else
    if (tokentype!=2)
    { strcat(newtoken,token); }
      else
    {
      eval_element(temptoken,tokentype,token);
      strcat(newtoken,temptoken);
    }
  }

  return 0;
}

