/* Stolen almost verbatim from 
 * "C Interfaces and Implementations", 
 * David R. Hanson, Addison Wesley, 1996
 */

#ifndef HASHT_INCLUDED
#define HASHT_INCLUDED

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

/* hash table definition */

struct bucket {
  const void *key;
  void *value;
  struct bucket *next;
};

struct table {
  /* housekeeping */
  int size;
  int length;
  unsigned timestamp;
  
  /* the table */
  struct bucket **buckets;
  
  /* operations */
  int (*compare)(const void *x, const void *y);
  unsigned (*hash)(const void *key);
};

typedef struct table table_t;

/* global data */
extern int primes[];

/* prototypes */

/* create a new hash table */
struct table *t_new(int hint, 
		       int compare(const void *x, const void *y), 
		       unsigned hash(const void *key));

/* retrieve an item from a hash table */
void *t_get(struct table *table, const void *key);

/* stick an item in the hash table */
void *t_put(struct table *table, const void *key, void *value);

/* how many items are in the table? */
int t_length(struct table *table);

/* apply a function to each item in the table */
void t_map(struct table *table, 
	      void apply(const void *key, void **value, void *cl),
	      void *closure);

/* get an item from the table, and take it out of the table */
void *t_remove(struct table *table, const void *key);

/* return an array of { key, value } */
void **t_2array(struct table *table, void *end);

/* return the keys of a table */
void **t_keys(struct table *table);

/* return the items of a table */
void **t_values(struct table *table);

/* lose the table */
void t_free(struct table **table);

int tableCompareStrings(const void *x, const void *y);
unsigned tableHashStrings(const void *key);

#endif
