#include "arpcatch.h"

int main(int argc, char **argv) {
	struct ether_addr se, de, *ep;
	int fd;
	unsigned long si, di;
	char c;

	while((c = getopt(argc, argv, "s:S:d:D:")) != EOF) {
		switch(c) {
		case 's':
			si = inet_addr(optarg);
			break;

		case 'S':
			ep = ether_aton(optarg);
			memcpy(&se, ep, sizeof(se));
			break;

		case 'd':
			di = inet_addr(optarg);
			break;

		case 'D':
			ep = ether_aton(optarg);
			memcpy(&de, ep, sizeof(de));
			break;
		}
	}	

	argc -= optind;
	argv += optind;

	if(!*argv)
		fd = bpf_open("ep0");
	else
		fd = bpf_open(*argv);

	if(fd < 0) {
		perror("bpf");
		exit(errno);
	}

	if(arp_send(fd, si, di, &se, &de) < 0) {
		perror("send");
		exit(errno);
	}
}
