#ifndef ARPCATCH_INCLUDED
#define ARPCATCH_INCLUDED

/* 1997 Thomas Ptacek, EnterAct, L.L.C. */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <syslog.h>
#include <time.h>
#include <limits.h>
#include <fcntl.h>
#include <assert.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/time.h>

#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>

#include <net/bpf.h>
#include <net/if.h>
#include <net/ethernet.h>
#include <net/if_arp.h>
#include <netinet/if_ether.h>

#include "list.h"
#include "table.h"

struct arp_map {
	char *name;
	struct ether_addr *mac;
};

#define DEFAULT_DEVICE			"ep0"
#define DEFAULT_CONFIGFILE		"/usr/local/etc/proxyarp.conf"

#define MAX_BPF_DEVICES 		16
#define DEFAULT_BUFLEN			256

#define ETHERARP_FIXEDSZ		42
#define ETHERHEADER_FIXEDSZ		14
#define ETHERARP_DSIZE			20
#define ETHERADDR_FIXEDSZ		6
#define IPADDR_FIXEDSZ			4

#define ETHER_DST			0
#define ETHER_SRC			6
#define ARP_SHARD			(14 + 8)
#define ARP_SNET			(14 + 14)
#define ARP_THARD			(14 + 18)
#define ARP_TNET			(14 + 24)

struct etherarp_payload {
	u_char sha[ETHERADDR_FIXEDSZ];
	u_char spa[IPADDR_FIXEDSZ];
	u_char tha[ETHERADDR_FIXEDSZ];
	u_char tpa[IPADDR_FIXEDSZ];
};

/* XXX */

int bpf_open(char *);
int bpf_setfilter(int, struct bpf_insn *, int);
int bpf_setbuf(int, int);
int bpf_getbuf(int);
int bpf_flush(int);
int bpf_received(int);
int bpf_dropped(int);
int bpf_immediate(int, int);
int bpf_promisc(int, int);

table_t *read_config(char *);

#endif
