#include "arpcatch.h"

int init_bpf(char *device);
int read_loop(int fd, table_t *at);
void usage(void);

extern struct bpf_insn capture_arp[];
extern char *optarg;

int debug = 0;
int defer = 0;

int main(int argc, char **argv) {
	char c;
	char *configfile = DEFAULT_CONFIGFILE;
	char *device     = DEFAULT_DEVICE;
	table_t *at;
	int fd;
	
	while((c = getopt(argc, argv, "di:f:")) != EOF) {
		switch(c) {
		case 'd':
			debug++;
			break;

		case 'i':
			device = optarg;
			break;

		case 'f':
			configfile = optarg;
			break;
		
		default:
			usage();
			exit(-1);
		}
	}

	if(!(at = read_config(configfile))) {
		perror("config file read");
		exit(errno);
	}

	fd = init_bpf(device);

	if(!debug)
		daemon(0, 0);
	
	read_loop(fd, at);

	perror("read");
}	

/* needs cleaning up */

int read_loop(int fd, table_t *at) {
	u_char *buffer = calloc(1, 256);
	u_char *pkt;

	struct bpf_hdr 		*bh = (struct bpf_hdr *) buffer;
	struct ether_header 	*eh;
	struct ether_addr	*ea;
	struct ether_arp 	*ah;

	struct in_addr foo;

	for(;;) {
		struct in_addr ia;

		if(read(fd, buffer, 256) < 0) {
			switch(errno) {
			default:
				return(-1);
			}
		}

		pkt = (u_char *) bh + bh->bh_hdrlen;
		if(bh->bh_datalen < (sizeof(struct ether_header) +
				    sizeof(struct arphdr) +
				    ETHERARP_DSIZE)) 
			continue;
	
		eh = (struct ether_header *) pkt;
		ah = (struct ether_arp *)(pkt + sizeof(struct ether_header));

		if(ntohs(eh->ether_type) != ETHERTYPE_ARP)
			continue;

		switch(ntohs(ah->arp_op)) {
		case ARPOP_REQUEST:
			bcopy(ah->arp_tpa, &ia.s_addr, 4);
			ea = t_get(at, &ia);
			if(!ea)
				continue;

			if(arp_send(fd, (u_long *) ah->arp_tpa,
					(u_long *) ah->arp_spa,
					ea,
					(struct ether_addr *) 
						ah->arp_sha) < 0) {
				switch(errno) {
				default:
					continue;
				}
			}

			break;
		
		case ARPOP_REPLY:
			if(!defer)
				continue;

			ea = t_get(at, (struct in_addr *) &ah->arp_spa);
			if(ea) 
			 	t_remove(at, (struct in_addr *)
						&ah->arp_spa);
	
			break;

		default:
			continue;
		}
	}
}

int init_bpf(char *device) {
	int fd;
	
	fd = bpf_open(device);
	if(fd < 0) {
		perror("bpf open");
		exit(errno);
	}

	if(bpf_setfilter(fd, capture_arp, 6) < 0) {
		perror("bpf filter set");
		exit(errno);
	}

	if(bpf_immediate(fd, 1) < 0) {
		perror("bpf immediate mode");
		exit(errno);
	}

	return(fd);
}

void usage() {
	fprintf(stderr, "RTFS\n");
	return;
}
