#!/opt/local/bin/gnuplot -persist
#
#	G N U P L O T
#	Version 4.2 patchlevel 2 
#	last modified 31 Aug 2007
#	System: Darwin 9.2.0
#
#	Copyright (C) 1986 - 1993, 1998, 2004, 2007
#	Thomas Williams, Colin Kelley and many others
#
#	Type `help` to access the on-line reference manual.
#	The gnuplot FAQ is available from http://www.gnuplot.info/faq/
#
#	Send bug reports and suggestions to <http://sourceforge.net/projects/gnuplot>
#
#
reset
#
# Create simple barchart of Total Bytes by Protocol
# The racluster.dat file was generated using:
#
#     racluster -m proto -r argus.out -s proto spkts dpkts sbytes dbytes
#
# And is of the format:
#
# Proto  SrcPkts  DstPkts     SrcBytes     DstBytes 
#   pim    53267    18086     48793554      1085160
#  ospf     1764        0       213220            0
#  [more]
#
set termoption font "Verdana, 12"
set size square 0.90,0.90
set bmargin 4
set title "Total Load By Protocol" font "Verdana,22"
set style data histogram
set style histogram cluster gap 1
set style fill solid border -1
set tics font "Verdana,14"
set boxwidth 0.80
set grid
set ylabel "Log Total Bytes" font "Verdana,18"
set logscale y 10
set auto y
set label 1 "Generated by Argus using Gnuplot"
set label 1 at graph 1.02, 0.62 rotate by 90 font "Verdana,9"
#
set key autotitle columnhead
plot 'racluster.out' using 4:xticlabels(1) ti col, \
     ''              using 5 ti col
#
