/*
 * Argus Software
 * Copyright (c) 2000-2008 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* 
 * $Id: //depot/argus/argus-3.0/clients/include/dscodepoints.h#8 $
 * $DateTime: 2006/03/31 13:25:33 $
 * $Change: 793 $
 */


/* list of supported encapsulations for filter */


#ifndef  Encapsulations_h
#define Encapsulations_h

struct ArgusEncapsulationStruct {
   unsigned int code;
   char *label, *desc;
};

#if defined(ArgusUtil)
struct ArgusEncapsulationStruct argus_encapsulations [] = {
   { 0x01,   "mpls", "Multiprotocol Label Switching"},
   { 0x02,   "eth", "Ethernet"},
   { 0x04,   "802q", "802.1PQ"},
   { 0x08,   "llc", "Link Layer Control"},
   { 0x10,   "pppoe", "PPP Over Ethernet"},
   { 0x20,   "isl", "Inter-Switch Link"},
   { 0x40,   "gre", "Generic Routing Encapsulation"},
   { 0x80,   "ah", "Authentication Header"},
   { 0x100,  "ipnip", "IP Version 4"},
   { 0x200,  "ipnip6", "IP Version 6"},
   { 0x400,  "hdlc", "HDLC"},
   { 0x800,  "chdlc", "Cisco HDLC"},
   { 0x1000, "atm", "Atm"},
   { 0x2000, "sll", "Sll"},
   { 0x4000, "fddi", "Fddi"},
   { 0x8000, "slip", "Slip"},
   { 0x00, (char *) 0, (char *) 0 }, 
};

#else

extern struct ArgusEncapsulationStruct argus_encapsulations [];

#endif
#endif
