/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.resources;

import java.io.IOException;
import java.util.Locale;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.resources.DataSourceForm;

public final class SetUpDataSourceAction
extends Action {
    private MBeanServer mserver = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.mserver == null) {
            this.mserver = ((ApplicationServlet)this.getServlet()).getServer();
        }
        MessageResources resources = this.getResources(request);
        Locale locale = this.getLocale(request);
        String objectName = request.getParameter("objectName");
        String resourcetype = request.getParameter("resourcetype");
        String path = request.getParameter("path");
        String host = request.getParameter("host");
        String domain = request.getParameter("domain");
        DataSourceForm dataSourceForm = new DataSourceForm();
        dataSourceForm.setResourcetype(resourcetype);
        dataSourceForm.setPath(path);
        dataSourceForm.setHost(host);
        dataSourceForm.setDomain(domain);
        dataSourceForm.setType("javax.sql.DataSource");
        if (objectName == null) {
            dataSourceForm.setNodeLabel(resources.getMessage(locale, "resources.actions.datasrc.create"));
            dataSourceForm.setObjectName(null);
            dataSourceForm.setActive("4");
            dataSourceForm.setIdle("2");
            dataSourceForm.setWait("5000");
            dataSourceForm.setType("javax.sql.DataSource");
        } else {
            dataSourceForm.setNodeLabel(resources.getMessage(locale, "resources.actions.datasrc.edit"));
            dataSourceForm.setObjectName(objectName);
            String attribute = null;
            try {
                ObjectName oname = new ObjectName(objectName);
                try {
                    attribute = "name";
                    dataSourceForm.setJndiName((String)this.mserver.getAttribute(oname, attribute));
                    attribute = "url";
                    dataSourceForm.setUrl((String)this.mserver.getAttribute(oname, attribute));
                    attribute = "driverClassName";
                    dataSourceForm.setDriverClass((String)this.mserver.getAttribute(oname, attribute));
                    attribute = "username";
                    dataSourceForm.setUsername((String)this.mserver.getAttribute(oname, attribute));
                    attribute = "password";
                    dataSourceForm.setPassword((String)this.mserver.getAttribute(oname, attribute));
                    attribute = "validationQuery";
                    dataSourceForm.setQuery((String)this.mserver.getAttribute(oname, attribute));
                }
                catch (AttributeNotFoundException ex) {
                    // empty catch block
                }
                try {
                    attribute = "maxActive";
                    dataSourceForm.setActive((String)this.mserver.getAttribute(oname, attribute));
                }
                catch (AttributeNotFoundException e) {
                    dataSourceForm.setActive("4");
                }
                try {
                    attribute = "maxIdle";
                    dataSourceForm.setIdle((String)this.mserver.getAttribute(oname, attribute));
                }
                catch (AttributeNotFoundException e) {
                    dataSourceForm.setIdle("2");
                }
                try {
                    attribute = "maxWait";
                    dataSourceForm.setWait((String)this.mserver.getAttribute(oname, attribute));
                }
                catch (AttributeNotFoundException e) {
                    dataSourceForm.setWait("5000");
                }
            }
            catch (Exception e) {
                this.getServlet().log(resources.getMessage(locale, "users.error.attribute.get", (Object)attribute), (Throwable)e);
                response.sendError(500, resources.getMessage(locale, "users.error.attribute.get", (Object)attribute));
                return null;
            }
        }
        this.saveToken(request);
        request.setAttribute("dataSourceForm", (Object)dataSourceForm);
        return mapping.findForward("DataSource");
    }
}

