/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.perforce;

import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.perforce.P4Base;
import org.apache.tools.ant.taskdefs.optional.perforce.SimpleP4OutputHandler;

public class P4Submit
extends P4Base {
    public String change;

    public void setChange(String change) {
        this.change = change;
    }

    public void execute() throws BuildException {
        if (this.change == null) {
            throw new BuildException("No change specified (no support for default change yet....");
        }
        this.execP4Command("submit -c " + this.change, new P4SubmitAdapter(this));
    }

    public class P4SubmitAdapter
    extends SimpleP4OutputHandler {
        public P4SubmitAdapter(P4Base parent) {
            super(parent);
        }

        public void process(String line) {
            super.process(line);
            P4Submit.this.getProject().setProperty("p4.needsresolve", "0");
            if (P4Submit.this.util.match("/renamed/", line)) {
                try {
                    Vector myarray = new Vector();
                    P4Submit.this.util.split(myarray, line);
                    boolean found = false;
                    int counter = 0;
                    while (counter < myarray.size()) {
                        if (found) {
                            String chnum = (String)myarray.elementAt(counter + 1);
                            int changenumber = Integer.parseInt(chnum);
                            P4Submit.this.log("Perforce change renamed " + changenumber, 2);
                            P4Submit.this.getProject().setProperty("p4.change", "" + changenumber);
                            found = false;
                        }
                        if (myarray.elementAt(counter).equals("renamed")) {
                            found = true;
                        }
                        ++counter;
                    }
                }
                catch (Exception e) {
                    String msg = "Failed to parse " + line + "\n" + " due to " + e.getMessage();
                    throw new BuildException(msg, (Throwable)e, P4Submit.this.getLocation());
                }
            }
            if (P4Submit.this.util.match("/p4 submit -c/", line)) {
                P4Submit.this.getProject().setProperty("p4.needsresolve", "1");
            }
        }
    }
}

