/*
 * wordconst.h
 * Copyright (C) 1998,1999 A.J. van Os
 *
 * Description:
 * Types and constants for the interpretation of MS Word files
 */

#if !defined(__wordconst_h)
#define __wordconst_h 1

/*
 * A bit odd definition of the type Boolean, but RISC OS insists
 * on this and Unix doesn't mind.
 */
#if !defined(BOOL)
#define BOOL int
#define TRUE 1
#define FALSE 0
#endif /* !BOOL */

/* Block sizes */
#define HEADER_SIZE			768
#define BIG_BLOCK_SIZE			512
#define PROPERTY_SET_STORAGE_SIZE	128
#define SMALL_BLOCK_SIZE		 64
/* Switch size of Depot use */
#define MIN_SIZE_FOR_BBD_USE		0x1000
/* Table sizes */
#define TABLE_COLUMN_MAX		 31
/* Maximum number of tabs positions in a paragraph */
#define NUMBER_OF_TABS_MAX		 64
/* Font sizes (in half-points) */
#define MIN_FONT_SIZE			  8
#define DEFAULT_FONT_SIZE		 20
#define MAX_FONT_SIZE			240
/* Font styles */
#define FONT_REGULAR			0x00
#define FONT_BOLD			0x01
#define FONT_ITALIC			0x02
#define FONT_UNDERLINE			0x04
#define FONT_CAPITALS			0x08
#define FONT_SMALL_CAPITALS		0x10
#define FONT_STRIKE			0x20
#define FONT_HIDDEN			0x40
/* Font colours */
#define FONT_COLOUR_DEFAULT		 0
#define FONT_COLOUR_BLACK		 1
#define FONT_COLOUR_RED			 6
/* End of a block chain */
#define END_OF_CHAIN			(-2)
/* Types of lists */
#define LIST_ARABIC_NUM			0x00
#define LIST_ROMAN_NUM_UPPER		0x01
#define LIST_ROMAN_NUM_LOWER		0x02
#define LIST_UPPER_ALPHA		0x03
#define LIST_LOWER_ALPHA		0x04
#define LIST_BULLETS			0xff
/* Types of paragraph alignment */
#define ALIGNMENT_LEFT			0x00
#define ALIGNMENT_CENTER		0x01
#define ALIGNMENT_RIGHT			0x02
#define ALIGNMENT_JUSTIFY		0x03

/* Macros */
	/* Get macros */
#define ucGetByte(i,a)		((unsigned char)(a[i]))
#define usGetWord(i,a)		((unsigned short)(a[i+1])<<8|\
					(unsigned short)(a[i]))
#define ulGetLong(i,a)		((unsigned long)(a[i+3])<<24|\
					(unsigned long)(a[i+2])<<16|\
					(unsigned long)(a[i+1])<<8|\
					(unsigned long)(a[i]))
	/* Font style macros */
#define bIsBold(x)		(((x) & FONT_BOLD) == FONT_BOLD)
#define bIsItalic(x)		(((x) & FONT_ITALIC) == FONT_ITALIC)
#define bIsUnderline(x)		(((x) & FONT_UNDERLINE) == FONT_UNDERLINE)
#define bIsCapitals(x)		(((x) & FONT_CAPITALS) == FONT_CAPITALS)
#define bIsSmallCapitals(x)	(((x) & FONT_SMALL_CAPITALS) == FONT_SMALL_CAPITALS)
#define bIsStrike(x)		(((x) & FONT_STRIKE) == FONT_STRIKE)
#define bIsHidden(x)		(((x) & FONT_HIDDEN) == FONT_HIDDEN)
	/* Computation macros */
/* From Words half-points to draw units (plus a percentage) */
#define iWord2DrawUnits00(x)	((int)(x) * 320)
#define iWord2DrawUnits06(x)	(((int)(x) * 3392 + 5) / 10)
#define iWord2DrawUnits20(x)	((int)(x) * 384)
/* From twips (1/20 of a point) to draw units */
#define iTwips2DrawUnits(x)	((int)(x) * 32)
/* From twips (1/20 of a point) to millipoints */
#define iTwips2MilliPoints(x)	((int)(x) * 50)
/* From default characters (16 OS units wide) to millipoints */
#define iChar2MilliPoints(x)	((int)(x) * 6400)
#define iMilliPoints2Char(x)	(((int)(x) + 3200) / 6400)
#define iDrawUnits2Char(x)	(((int)(x) + 2048) / 4096)
/* From draw units (1/180*256 inch) to millipoints (1/72*1000 inch) */
#define iDrawUnits2MilliPoints(x)	(((int)(x) * 25 +  8) / 16)
#define iMilliPoints2DrawUnits(x)	(((int)(x) * 16 + 12) / 25)

/* Special characters */
#define IGNORE_CHAR		0x00	/* ^@ */
#define PICTURE			0x01	/* ^A */
#define FOOTNOTE_OR_ENDNOTE	0x02	/* ^B */
#define ANNOTATION		0x05	/* ^E */
#define TABLE_SEPARATOR		0x07	/* ^G */
#define FRAME			0x08	/* ^H */
#define TAB			0x09	/* ^I */
/* End of line characters */
#define HARD_RETURN		0x0b	/* ^K */
#define FORM_FEED		0x0c	/* ^L */
#define PAR_END			0x0d	/* ^M */
#define COLUMN_FEED		0x0e	/* ^N */
/* Embedded stuff */
#define START_EMBEDDED		0x13	/* ^S */
#define END_IGNORE		0x14	/* ^T */
#define END_EMBEDDED		0x15	/* ^U */
/* Special characters */
#if defined(DEBUG)
#define FILLER_CHAR		0xb7
#else
#define FILLER_CHAR		' '
#endif /* DEBUG */
#define TABLE_SEPARATOR_CHAR	'|'
/* Pseudo characters. Tese must be outside the Unicode range */
#define FOOTNOTE_CHAR		((int)USHRT_MAX + 1)
#define ENDNOTE_CHAR		((int)USHRT_MAX + 2)
#define UNKNOWN_NOTE_CHAR	((int)USHRT_MAX + 3)

/* Charactercodes as used by Word */
#define WORD_UNBREAKABLE_JOIN		0x1e
#define WORD_SOFT_HYPHEN		0x1f
/* Characters with non-standard values (0x80-0x9f) */
#define WORD_EURO_SIGN			0x80
#define WORD_CEDILLA			0x82
#define WORD_DUTCH_GUILDER_SIGN		0x83
#define WORD_LOW_DOUBLE_QUOTE		0x84
#define WORD_ELLIPSIS			0x85
#define WORD_DAGGER			0x86
#define WORD_DOUBLE_DAGGER		0x87
#define WORD_NON_SPACING_CIRCUMFLEX_ACCENT	0x88
#define WORD_PER_MILLE_SIGN		0x89
#define	WORD_LEFT_SINGLE_QMARK		0x8b
#define WORD_CAPITAL_LIGATURE_OE	0x8c
#define WORD_LEFT_SINGLE_QUOTE		0x91
#define WORD_RIGHT_SINGLE_QUOTE		0x92
#define WORD_OPENING_DOUBLE_QUOTE	0x93
#define WORD_CLOSING_DOUBLE_QUOTE	0x94
#define WORD_BULLET			0x95
#define WORD_EN_DASH			0x96
#define WORD_EM_DASH			0x97
#define WORD_NON_SPACING_TILDE		0x98
#define WORD_TRADEMARK			0x99
#define	WORD_RIGHT_SINGLE_QMARK		0x9b
#define WORD_SMALL_LIGATURE_OE		0x9c

/* Some Unicode characters that can be translated into ISO-8859-1 */
#define UNICODE_CAPITAL_W_CIRCUMFLEX_ACCENT	0x0174
#define UNICODE_SMALL_W_CIRCUMFLEX_ACCENT	0x0175
#define UNICODE_CAPITAL_Y_CIRCUMFLEX_ACCENT	0x0176
#define UNICODE_SMALL_Y_CIRCUMFLEX_ACCENT	0x0177
#define UNICODE_LEFT_SINGLE_QUOTE_ALT	0x1091
#define UNICODE_RIGHT_SINGLE_QUOTE_ALT	0x1092
#define UNICODE_HYPHEN			0x2010
#define UNICODE_NON_BREAKING_HYPHEN	0x2011
#define UNICODE_FIGURE_DASH		0x2012
#define UNICODE_EN_DASH			0x2013
#define UNICODE_EM_DASH			0x2014
#define UNICODE_HORIZONTAL_BAR		0x2015
#define UNICODE_DOUBLE_VERTICAL_LINE	0x2016
#define UNICODE_DOUBLE_LOW_LINE		0x2017
#define UNICODE_LEFT_SINGLE_QUOTE	0x2018
#define UNICODE_RIGHT_SINGLE_QUOTE	0x2019
#define UNICODE_OPENING_DOUBLE_QUOTE	0x201c
#define UNICODE_CLOSING_DOUBLE_QUOTE	0x201d
#define UNICODE_LOW_DOUBLE_QUOTE	0x201e
#define UNICODE_DAGGER			0x2020
#define UNICODE_DOUBLE_DAGGER		0x2021
#define UNICODE_BULLET			0x2022
#define UNICODE_ELLIPSIS		0x2026
#define UNICODE_HYPHENATION_POINT	0x2027
#define UNICODE_PER_MILLE_SIGN		0x2030
#define	UNICODE_LEFT_SINGLE_QMARK	0x2039
#define	UNICODE_RIGHT_SINGLE_QMARK	0x203a
#define UNICODE_FRACTION_SLASH		0x2044
#define UNICODE_EURO_SIGN		0x20ac
#define UNICODE_TRADEMARK		0x2122
#define UNICODE_WHITE_SMILING_FACE	0x263a
#define UNICODE_BLACK_SMILING_FACE	0x263b
#define UNICODE_DIAMOND			0xf075
#define UNICODE_BULLET_ALT		0xf0b7
#define UNICODE_COPYRIGHT		0xf0d3

/* Some Mac characters that can be translated into ISO-8859-1 */
#define MAC_CAPTAL_A_DIAERESIS		0x80
#define MAC_CAPTAL_A_RING_ABOVE		0x81
#define MAC_CAPTAL_C_CEDILLA		0x82
#define MAC_CAPTAL_O_ACUTE_ACCENT	0x83
#define MAC_CAPTAL_N_TILDE		0x84
#define MAC_CAPTAL_O_DIAERESIS		0x85
#define MAC_CAPTAL_U_DIAERESIS		0x86
#define MAC_SMALL_A_ACUTE_ACCENT	0x87
#define MAC_SMALL_A_GRAVE_ACCENT	0x88
#define MAC_SMALL_A_CIRCUMFLEX_ACCENT	0x89
#define MAC_SMALL_A_DIAERESIS		0x8a
#define MAC_SMALL_A_TILDE		0x8b
#define MAC_SMALL_A_RING_ABOVE		0x8c
#define MAC_SMALL_C_CEDILLA		0x8d
#define MAC_SMALL_E_ACUTE_ACCENT	0x8e
#define MAC_SMALL_E_GRAVE_ACCENT	0x8f
#define MAC_SMALL_E_CIRCUMFLEX_ACCENT	0x90
#define MAC_SMALL_E_DIAERESIS		0x91
#define MAC_SMALL_I_ACUTE_ACCENT	0x92
#define MAC_SMALL_I_GRAVE_ACCENT	0x93
#define MAC_SMALL_I_CIRCUMFLEX_ACCENT	0x94
#define MAC_SMALL_I_DIAERESIS		0x95
#define MAC_SMALL_N_TILDE		0x96
#define MAC_SMALL_O_ACUTE_ACCENT	0x97
#define MAC_SMALL_O_GRAVE_ACCENT	0x98
#define MAC_SMALL_O_CIRCUMFLEX_ACCENT	0x99
#define MAC_SMALL_O_DIAERESIS		0x9a
#define MAC_SMALL_O_TILDE		0x9b
#define MAC_SMALL_U_ACUTE_ACCENT	0x9c
#define MAC_SMALL_U_GRAVE_ACCENT	0x9d
#define MAC_SMALL_U_CIRCUMFLEX_ACCENT	0x9e
#define MAC_SMALL_U_DIAERESIS		0x9f
#define MAC_SMALL_SHARP_S		0xa7
#define	MAC_LEFT_DOUBLE_QMARK		0xc7
#define	MAC_RIGHT_DOUBLE_QMARK		0xc8
#define MAC_EN_DASH			0xd0
#define MAC_EM_DASH			0xd1
#define MAC_OPENING_DOUBLE_QUOTE	0xd2
#define MAC_CLOSING_DOUBLE_QUOTE	0xd3
#define MAC_LEFT_SINGLE_QUOTE		0xd4
#define MAC_RIGHT_SINGLE_QUOTE		0xd5

/* Local characters */
#if defined(__riscos)
#define OUR_CAPITAL_W_CIRCUMFLEX_ACCENT	0x81
#define OUR_SMALL_W_CIRCUMFLEX_ACCENT	0x82
#define OUR_CAPITAL_Y_CIRCUMFLEX_ACCENT	0x85
#define OUR_SMALL_Y_CIRCUMFLEX_ACCENT	0x86
#define OUR_ELLIPSIS			0x8c
#define OUR_TRADEMARK			0x8d
#define OUR_PER_MILLE_SIGN		0x8e
#define OUR_BULLET			0x8f
#define OUR_LEFT_SINGLE_QUOTE		0x90
#define OUR_RIGHT_SINGLE_QUOTE		0x91
#define OUR_LEFT_SINGLE_QMARK		0x92
#define OUR_RIGHT_SINGLE_QMARK		0x93
#define OUR_OPENING_DOUBLE_QUOTE	0x94
#define OUR_CLOSING_DOUBLE_QUOTE	0x95
#define OUR_LOW_DOUBLE_QUOTE		0x96
#define OUR_EN_DASH			0x97
#define OUR_EM_DASH			0x98
#define OUR_UNBREAKABLE_JOIN		0x99
#define OUR_CAPITAL_LIGATURE_OE		0x9a
#define OUR_SMALL_LIGATURE_OE		0x9b
#define OUR_DAGGER			0x9c
#define OUR_DOUBLE_DAGGER		0x9d
#define OUR_CEDILLA			0xb8
#else
#define OUR_CAPITAL_W_CIRCUMFLEX_ACCENT	'W'
#define OUR_SMALL_W_CIRCUMFLEX_ACCENT	'w'
#define OUR_CAPITAL_Y_CIRCUMFLEX_ACCENT	'Y'
#define OUR_SMALL_Y_CIRCUMFLEX_ACCENT	'y'
#define OUR_ELLIPSIS			'.'
#define OUR_TRADEMARK			'?'
#define OUR_PER_MILLE_SIGN		'?'
#define OUR_BULLET			'+'
#define OUR_LEFT_SINGLE_QUOTE		'\''
#define OUR_RIGHT_SINGLE_QUOTE		'\''
#define OUR_LEFT_SINGLE_QMARK		'\''
#define OUR_RIGHT_SINGLE_QMARK		'\''
#define OUR_OPENING_DOUBLE_QUOTE	'"'
#define OUR_CLOSING_DOUBLE_QUOTE	'"'
#define OUR_LOW_DOUBLE_QUOTE		'"'
#define OUR_EN_DASH			'-'
#define OUR_EM_DASH			'-'
#define OUR_UNBREAKABLE_JOIN		'-'
#define OUR_CAPITAL_LIGATURE_OE		'?'
#define OUR_SMALL_LIGATURE_OE		'?'
#define OUR_DAGGER			'-'
#define OUR_DOUBLE_DAGGER		'='
#define OUR_CEDILLA			','
#endif /* __riscos */

#define OUR_NON_SPACING_CIRCUMFLEX_ACCENT	'^'
#define OUR_EURO_SIGN			'E'	/* For the time being */
#define OUR_DUTCH_GUILDER_SIGN		'f'
#define OUR_NON_SPACING_TILDE		'~'
#define OUR_HYPHEN			'-'
#define OUR_DOUBLE_VERTICAL_LINE	'|'
#define OUR_DOUBLE_LOW_LINE		'_'
#define OUR_FRACTION_SLASH		'/'
#define OUR_DIAMOND			'-'
#define OUR_WHITE_SMILING_FACE		'#'
#define OUR_BLACK_SMILING_FACE		'#'

#define OUR_COPYRIGHT			0xa9
#define	OUR_LEFT_DOUBLE_QMARK		0xab
#define	OUR_RIGHT_DOUBLE_QMARK		0xbb
#define OUR_CAPTAL_A_DIAERESIS		0xc4
#define OUR_CAPTAL_A_RING_ABOVE		0xc5
#define OUR_CAPTAL_C_CEDILLA		0xc7
#define OUR_CAPTAL_O_ACUTE_ACCENT	0xc9
#define OUR_CAPTAL_N_TILDE		0xd1
#define OUR_CAPTAL_O_DIAERESIS		0xd6
#define OUR_CAPTAL_U_DIAERESIS		0xdc
#define OUR_SMALL_SHARP_S		0xdf
#define OUR_SMALL_A_GRAVE_ACCENT	0xe0
#define OUR_SMALL_A_ACUTE_ACCENT	0xe1
#define OUR_SMALL_A_CIRCUMFLEX_ACCENT	0xe2
#define OUR_SMALL_A_TILDE		0xe3
#define OUR_SMALL_A_DIAERESIS		0xe4
#define OUR_SMALL_A_RING_ABOVE		0xe5
#define OUR_SMALL_C_CEDILLA		0xe7
#define OUR_SMALL_E_GRAVE_ACCENT	0xe8
#define OUR_SMALL_E_ACUTE_ACCENT	0xe9
#define OUR_SMALL_E_CIRCUMFLEX_ACCENT	0xea
#define OUR_SMALL_E_DIAERESIS		0xeb
#define OUR_SMALL_I_GRAVE_ACCENT	0xec
#define OUR_SMALL_I_ACUTE_ACCENT	0xed
#define OUR_SMALL_I_CIRCUMFLEX_ACCENT	0xee
#define OUR_SMALL_I_DIAERESIS		0xef
#define OUR_SMALL_N_TILDE		0xf1
#define OUR_SMALL_O_GRAVE_ACCENT	0xf2
#define OUR_SMALL_O_ACUTE_ACCENT	0xf3
#define OUR_SMALL_O_CIRCUMFLEX_ACCENT	0xf4
#define OUR_SMALL_O_DIAERESIS		0xf6
#define OUR_SMALL_O_TILDE		0xf5
#define OUR_SMALL_U_GRAVE_ACCENT	0xf9
#define OUR_SMALL_U_ACUTE_ACCENT	0xfa
#define OUR_SMALL_U_CIRCUMFLEX_ACCENT	0xfb
#define OUR_SMALL_U_DIAERESIS		0xfc

#endif /* __wordconst_h */
