/*
 * unix.c
 * Copyright (C) 1998,1999 A.J. van Os
 *
 * Description:
 * Unix approximations of RISC-OS functions
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include "antiword.h"


/*
 * werr - write an error message and exit if needed
 */
void
werr(int iFatal, const char *szFormat, ...)
{
	va_list tArg;

	va_start(tArg, szFormat);
	vfprintf(stderr, szFormat, tArg);
	va_end(tArg);
	fprintf(stderr, "\n");
	if (iFatal != 0) {
		exit(iFatal);
	}
} /* end of werr */

void
visdelay_begin(void)
{
} /* end of visdelay_begin */

void
visdelay_end(void)
{
} /* end of visdelay_end */
