/*
 * main_u.c
 *
 * Released under GPL
 *
 * Copyright (C) 1998,1999 A.J. van Os
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Description:
 * The main program of 'antiword' (Unix version)
 */

#include <stdio.h>
#include <string.h>
#include "version.h"
#include "antiword.h"

/* The name of this program */
static char	*szTask = NULL;


static void
vUsage(void)
{
	fprintf(stderr, "\tName: %s\n", szTask);
	fprintf(stderr, "\tPurpose: "PURPOSESTRING"\n");
	fprintf(stderr, "\tAuthor: "AUTHORSTRING"\n");
	fprintf(stderr, "\tVersion: "VERSIONSTRING"\n");
	fprintf(stderr, "\tStatus: "STATUSSTRING"\n");
	fprintf(stderr,
		"\tUsage: %s [switches] wordfile1 [wordfile2 ...]\n", szTask);
	fprintf(stderr, "\tSwitches: [-t|-p papersize][-w #][-c|-g][-s]\n");
	fprintf(stderr, "\t\t-t ASCII text output (default)\n");
	fprintf(stderr, "\t\t-p <papersize> PostScript output\n");
	fprintf(stderr, "\t\t-w <width> in characters of ASCII text output\n");
	fprintf(stderr, "\t\t-g grayscale (PostScript only)\n");
	fprintf(stderr, "\t\t-c colour (default, PostScript only)\n");
	fprintf(stderr, "\t\t-s Show hidden (by Word) text\n");
} /* end of vUsage */

static void
vProcessFile(const char *szFilename, BOOL bLastFile)
{
	diagram_type	*pDiag;

	fail(szFilename == NULL || szFilename[0] == '\0');

	DBG_MSG(szFilename);

	if (!bIsSupportedWordFile(szFilename)) {
		if (bIsRtfFile(szFilename)) {
			werr(0, "%s is not a Word Document."
				" It is probably a Rich Text Format file",
				szFilename);
		} else if (bIsWord245File(szFilename)) {
			werr(0, "%s is not in a supported Word format."
				" It is probably from 'Word2, 4 or 5'",
				szFilename);
		} else {
			werr(0, "%s is not a Word Document.", szFilename);
		}
		return;
	}
	pDiag = pCreateDiagram(szTask, szFilename);
	if (pDiag != NULL) {
		vWord2Text(pDiag, szFilename);
		vDestroyDiagram(pDiag, bLastFile);
	}
} /* end of vProcessFile */

int
main(int argc, char **argv)
{
	options_type	tOptions;
	char	*szWordfile;
	int	iFirst, iIndex;
	BOOL	bUsage, bMultiple, bUsePlainText;

	if (argc <= 0) {
		return 1;
	}

	szTask = strrchr(argv[0], '/');
	if (szTask == NULL) {
		szTask = argv[0];
	} else {
		szTask++;
	}

	if (argc <= 1) {
		iFirst = 1;
		bUsage = TRUE;
	} else {
		iFirst = iReadOptions(argc, argv);
		bUsage = iFirst <= 0;
	}
	if (bUsage) {
		vUsage();
		return iFirst < 0 ? 1 : 0;
	}

	vGetOptions(&tOptions);

	bMultiple = argc - iFirst > 1;
	bUsePlainText = !tOptions.bUseOutlineFonts;

	for (iIndex = iFirst; iIndex < argc; iIndex++) {
		if (bMultiple && bUsePlainText) {
			szWordfile = strrchr(argv[iIndex], '/');
			if (szWordfile == NULL) {
				szWordfile = argv[iIndex];
			} else {
				szWordfile++;
			}
			fprintf(stdout, "::::::::::::::\n");
			fprintf(stdout, "%s\n", szWordfile);
			fprintf(stdout, "::::::::::::::\n");
		}
		vProcessFile(argv[iIndex], iIndex + 1 >= argc);
	}
	return 0;
} /* end of main */
