/*
 * antiword.h
 * Copyright (C) 1998,1999 A.J. van Os
 *
 * Description:
 * Generic include file for project 'AntiWord'
 */

#if !defined(__antiword_h)
#define __antiword_h 1

#include <stdio.h>
#if defined(__riscos)
#include "wimp.h"
#include "drawfobj.h"
#include "font.h"
#include "werr.h"
#else
#include <sys/types.h>
#endif /* __riscos */
#include "wordconst.h"
#include "wordtypes.h"
#include "fail.h"
#include "debug.h"

/* Constants */
#if defined(__riscos)
#define PATH_MAX		255
#endif /* __riscos */

/* The screen width */
#define MIN_SCREEN_WIDTH	 70
#define DEFAULT_SCREEN_WIDTH	 76
#define MAX_SCREEN_WIDTH	120

/* The scale factors as percentages */
#define MIN_SCALE_FACTOR	 25
#define DEFAULT_SCALE_FACTOR	100
#define MAX_SCALE_FACTOR	400

/* Filetypes */
#define FILETYPE_MSWORD		0xae6
#define FILETYPE_IMPDOC		0xbc5
#define FILETYPE_DRAW		0xaff
#define FILETYPE_POSCRIPT	0xff5
#define FILETYPE_TEXT		0xfff

/* The button numbers in the choices window */
#define CHOICES_DEFAULT_BUTTON		 3
#define CHOICES_SAVE_BUTTON		 2
#define CHOICES_CANCEL_BUTTON		 1
#define CHOICES_APPLY_BUTTON		 0
#define CHOICES_BREAK_BUTTON		 6
#define CHOICES_BREAK_WRITEABLE		 7
#define CHOICES_BREAK_UP_BUTTON		 8
#define CHOICES_BREAK_DOWN_BUTTON	 9
#define CHOICES_NO_BREAK_BUTTON		11
#define CHOICES_AUTOFILETYPE_BUTTON	14
#define CHOICES_HIDDEN_TEXT_BUTTON	21
#define CHOICES_OUTLINEFONT_BUTTON	17
#define CHOICES_SYSTEMFONT_BUTTON	18

/* The button numbers in the scale view window */
#define SCALE_CANCEL_BUTTON		 1
#define SCALE_SCALE_BUTTON		 0
#define SCALE_SCALE_WRITEABLE		 3
#define SCALE_50_PCT			 5
#define SCALE_75_PCT			 6
#define SCALE_100_PCT			 7
#define SCALE_150_PCT			 8

/* Margin for the PostSript version */
#define	PS_LEFT_MARGIN			(72 * 640)
#define PS_RIGHT_MARGIN			(43 * 640)
#define PS_TOP_MARGIN			(72 * 640)
#define PS_BOTTOM_MARGIN		(72 * 640)

/* Macros */
#define StrEq(x,y)	(*(x) == *(y) && strcmp(x,y) == 0)
#define StriEq(x,y)	(stricmp(x,y) == 0)
#define StrnEq(x,y,n)	(*(x) == *(y) && strncmp(x,y,n) == 0)
#define StrniEq(x,y,n)	(strnicmp(x,y,n) == 0)
#define elementsof(a)	(sizeof(a) / sizeof(a[0]))
#define max(x,y)	((x)>(y)?(x):(y))
#define min(x,y)	((x)<(y)?(x):(y))
#define odd(x)		((x)&0x01)
#define BIT(x)		((unsigned int)1 << (x))
#define MakeFour(x)	(((x)+3)&~0x03)

/* The name of the options file */
#if defined(__riscos)
#define TABLE_FONT	"Corpus.Medium"
#define OPTIONS_FILE_R	"<AntiWord$ChoicesFile>"
#define OPTIONS_FILE_W	"AntiWord$ChoicesSave"
#else
#define TABLE_FONT	"Courier"
#define OPTIONS_FILE_R	"~/.antiword/choices"
#define FONTNAMES_FILE	".antiword/fontnames"
#endif /* __riscos */
#define OPTIONS_COMMENT_CHAR	'#'

/* Prototypes */

/* blocklist.c */
extern void	vDestroyTextBlockList(void);
extern BOOL	bAdd2TextBlockList(text_block_type *);
extern void	vSplitBlockList(int, int, int, int, int, BOOL);
extern unsigned int	uiGetDocumentLength(void);
extern int	iNextChar(FILE *, list_id_enum, int *);
extern int	iTextOffset2FileOffset(int);
/* chartrans.c */
extern int	iTranslateCharacters(int, int, BOOL);
extern int	iToUpper(int);
/* depot.c */
extern void	vDestroySmallBlockList(void);
extern BOOL	bCreateSmallBlockList(int, const int *, int);
extern int	iDepotOffset(int, int);
/* draw.c & postscript.c */
extern diagram_type *pCreateDiagram(char *, const char *);
extern void	vAddFonts2Diagram(diagram_type *);
extern void	vMove2NextLine(diagram_type *, draw_fontref, int);
extern void	vSubstring2Diagram(diagram_type *,
			char *, int, int, int, unsigned char,
			draw_fontref, int, int);
extern void	vSetLeftIndentation(diagram_type *, int);
extern void	vEndOfParagraph2Diagram(diagram_type *, draw_fontref, int);
extern void	vEmptyLine2Diagram(diagram_type *, draw_fontref, int);
extern void	vEndOfPage2Diagram(diagram_type *, draw_fontref, int);
#if defined(__riscos)
extern BOOL	bVerifyDiagram(diagram_type *);
extern void	vShowDiagram(diagram_type *);
extern void	vMainEventHandler(wimp_eventstr *, void *);
extern void	vScaleOpenAction(diagram_type *);
extern void	vSetTitle(diagram_type *);
extern void	vScaleEventHandler(wimp_eventstr *, void *);
#else
extern void	vDestroyDiagram(diagram_type *, BOOL);
#endif /* __riscos */
/* fastsaved.c */
extern BOOL	bAddBlocks(int , int, BOOL, int, const int *, int);
extern text_info_enum	eGet6DocumentText(FILE *, BOOL, int,
				const int *, int, const unsigned char *);
extern text_info_enum	eGet8DocumentText(FILE *, const pps_info_type *,
				const int *, int, const int *, int,
				const unsigned char *);
/* fontlist.c */
extern void	vDestroyFontInfoList(void);
extern void	vAdd2FontInfoList(const font_block_type *);
extern void	vReset2FontInfoList(int);
extern const font_block_type	*pGetNextFontInfoListItem(
					const font_block_type *);
/* fonts.c */
extern int	iGetFontByNumber(unsigned char, unsigned char);
extern const char	*szGetOurFontname(int);
extern int	iFontname2Fontnumber(const char *, unsigned char);
extern void	vCreate6FontTable(FILE *, int,
			const int *, int, const unsigned char *);
extern void	vCreate8FontTable(FILE *, const pps_info_type *,
			const int *, int, const int *, int,
			const unsigned char *);
extern void	vDestroyFontTable(void);
extern void	vGetFontTranslationTable(font_table_type **, int *);
/* fonts_r.c & fonts_u.c */
extern FILE	*pOpenFontTableFile(void);
extern void	vCloseFont(void);
extern draw_fontref	tOpenFont(diagram_type *, unsigned char,
				unsigned char, int);
extern draw_fontref	tOpenTableFont(diagram_type *, int);
extern int	iComputeStringWidth(char *, int, draw_fontref, int);
/* fonts_u.c */
#if !defined(__riscos)
extern const char	*szGetFontname(draw_fontref);
#endif /* !__riscos */
/* icons.c */
#if defined(__riscos)
extern void	vUpdateIcon(wimp_w, wimp_icon *);
extern void	vUpdateRadioButton(wimp_w, wimp_i, BOOL);
extern void	vUpdateWriteable(wimp_w, wimp_i, char *);
extern void	vUpdateWriteableNumber(wimp_w, wimp_i, int);
#endif /* __riscos */
/* misc.c */
#if defined(__riscos)
extern int	iGetFiletype(const char *);
extern void	vSetFiletype(const char *, int);
extern BOOL	bISO_8859_1_IsCurrent(void);
#endif /* __riscos */
extern BOOL	bMakeDirectory(const char *);
extern off_t	tGetFilesize(const char *);
#if defined(DEBUG)
extern void	vPrintBlock(const char *, int, const unsigned char *, int);
extern BOOL	bCheckDoubleLinkedList(output_type *);
#endif /* DEBUG */
extern BOOL	bReadBytes(unsigned char *, size_t, long, FILE *);
extern BOOL	bReadBuffer(FILE *, int, const int *, int, int,
			unsigned char *, int, int);
extern int	iColour2Colour(unsigned char);
extern int	iFindSplit(const char *, int);
extern output_type *pSplitList(output_type *);
extern int	iInteger2Roman(int, BOOL, char *);
extern int	iInteger2Alpha(int, BOOL, char *);
extern char	*unicpy(char *, const char *);
/* notes.c */
extern void	vDestroyNotesInfoLists(void);
extern void	vGetNotesInfo(FILE *, const pps_info_type *,
			const int *, int, const int *, int,
			const unsigned char *, int);
extern notetype_enum eGetNotetype(int);
/* options.c */
extern int	iReadOptions(int, char **);
extern void	vGetOptions(options_type *);
#if defined(__riscos)
extern void	vChoicesOpenAction(wimp_w);
extern void	vChoicesMouseClick(wimp_mousestr *);
extern void	vChoicesKeyPressed(wimp_caretstr *);
#endif /* __riscos */
/* out2window.c */
extern void	vAlign2Window(diagram_type *, output_type *,
			int, unsigned char);
extern void	vJustify2Window(diagram_type *, output_type *,
			int, unsigned char);
extern void	vResetStyles(void);
extern int	iStyle2Window(char *, const style_block_type *);
extern void	vTableRow2Window(diagram_type *,
			output_type *, const row_block_type *);
/* paragraph.c */
extern void	vGetParagraphInfo(FILE *, const pps_info_type *,
			const int *, int, const int *, int,
			const unsigned char *, int);
/* rowlist.c */
extern void	vDestroyRowInfoList(void);
extern void	vAdd2RowInfoList(const row_block_type *);
extern BOOL	bGetNextRowInfoListItem(row_block_type *);
/* stylelist.c */
extern void	vDestroyStyleInfoList(void);
extern void	vAdd2StyleInfoList(const style_block_type *);
extern const style_block_type	*pGetNextStyleInfoListItem(void);
/* tabstop.c */
extern void	vSetDefaultTabWidth(FILE *, const pps_info_type *,
			const int *, int, const int *, int,
			const unsigned char *, int);
extern int	iGetDefaultTabWidth(void);
/* unix.c */
#if !defined(__riscos)
extern void	werr(int, const char *, ...);
extern void	visdelay_begin(void);
extern void	visdelay_end(void);
#endif /* !__riscos */
/* saveas.c */
extern void	vSaveTextfile(diagram_type *);
extern void	vSaveDrawfile(diagram_type *);
/* word2text.c */
extern void	vWord2Text(diagram_type *, const char *);
/* wordlib.c */
extern FILE	*pOpenDocument(const char *);
extern void	vCloseDocument(FILE *);
extern BOOL	bIsSupportedWordFile(const char *);
extern BOOL	bIsWord245File(const char *);
extern BOOL	bIsRtfFile(const char *);
extern BOOL	bFileFromTheMac(void);
/* xmalloc.c */
extern void 	*xmalloc(size_t);
extern void 	*xrealloc(void *, size_t);
extern char	*xstrdup(const char *);
extern void 	*xfree(void *);

#endif /* __antiword_h */
