/* features */
#include <stdio.h>
#include "segclass.h"
#include "feature_set.h"

static short *
get_array(struct feature_list *fl)
{
  if (fl->size == NR_EM_FEATURES) {
    return fl->u.index;
  }
  return fl->u.array;
}

static void
ensure_array(struct feature_list *fl, int nr)
{
}

void
anthy_feature_list_init(struct feature_list *fl)
{
  fl->nr = 0;
  fl->size = NR_EM_FEATURES;
}

void
anthy_feature_list_free(struct feature_list *fl)
{
}

void
anthy_feature_list_add(struct feature_list *fl, int f)
{
  if (fl->nr < NR_EM_FEATURES) {
    fl->u.index[fl->nr] = f;
    fl->nr++;
  }
}

int
anthy_feature_list_nr(struct feature_list *fl)
{
  return fl->nr;
}

int
anthy_feature_list_nth(struct feature_list *fl, int nth)
{
  return fl->u.index[nth];
}

void
anthy_feature_list_set_cur_class(struct feature_list *fl, int to)
{
  anthy_feature_list_add(fl, to);
}

void
anthy_feature_list_set_dep_word(struct feature_list *fl, int h)
{
  anthy_feature_list_add(fl, h + 40);
}

double
anthy_feature_list_inner_product(struct feature_list *fl, const double *v, int len)
{
  int i, nr = anthy_feature_list_nr(fl);
  double res = 0;
  /* Ѥ׻ */
  for (i = 0; i < nr; i++) {
    int f = anthy_feature_list_nth(fl, i);
    if (f >= len) {
      continue;
    }
    res += v[f];
  }
  return res;
}

void
anthy_feature_list_print(struct feature_list *fl)
{
  int i;
  printf("features=");
  for (i = 0; i < fl->nr; i++) {
    if (i) {
      printf(",");
    }
    printf("%d", fl->u.index[i]);
  }
  printf("\n");
}

void
anthy_init_features(void)
{
}
