/*
 * Ѵ󥸥ȤᡢտŪ
 * layer violation֤Ƥ롣
 *
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <anthy.h>
#include <convdb.h>
#include "segment.h"
#include "feature_set.h"
/**/
#include "../src-main/main.h"
#include "../src-splitter/wordborder.h"
#include "../src-worddic/dic_ent.h"


/* Ω° */
#define WORD_INDEP 0
#define WORD_DEP 1

/* ñ(Ωor°) */
struct word {
  /* WORD_* */
  int type;
  /* idϼΩλΤͭ */
  int id;
  /* °hash(WORD_INDEP)⤷Ѵʸhash(WORD_DEP) */
  int hash;
  /* ɤߤʸhash */
  int yomi_hash;
  /* Ѵʸ */
  xstr *raw_xs;
  /* Ѵʸ */
  xstr *conv_xs;
  /* Ѵʻ */
  const char *wt;
  /* ʸ᥯饹 */
  int seg_class;
};

static void
get_res(anthy_context_t ac, char *res_buf, int conv)
{
  struct anthy_conv_stat acs;
  int i;

  anthy_get_stat(ac, &acs);
  res_buf[0] = 0;
  if (!conv) {
    strcat(res_buf, "|");
  }
  for (i = 0; i < acs.nr_segment; i++) {
    char buf[1024];
    if (conv) {
      anthy_get_segment(ac, i, 0, buf, 1024);
      strcat(res_buf, buf);
    } else {
      anthy_get_segment(ac, i, NTH_UNCONVERTED_CANDIDATE, buf, 1024);
      strcat(res_buf, buf);
      strcat(res_buf, "|");
    }
  }
}

static struct conv_res *
do_find_conv_res(struct res_db *db, const char *src, const char *res)
{
  struct conv_res *cr;

  for (cr = db->res_list.next; cr; cr = cr->next) {
    if (((!cr->res_str && !res) ||
	 !strcmp(cr->res_str, res)) &&
	!strcmp(cr->src_str, src)) {
      return cr;
    }
  }
  cr = (struct conv_res *)malloc(sizeof(struct conv_res));
  cr->src_str = strdup(src);
  if (res) {
    cr->res_str = strdup(res);
  } else {
    cr->res_str = NULL;
  }
  cr->check = CHK_UNKNOWN;
  cr->used = 0;
  /**/
  db->tail->next = cr;
  cr->next = NULL;
  db->tail = cr;
  return cr;
}

struct conv_res *
find_conv_res(struct res_db *db, anthy_context_t ac,
	      const char *src, int conv)
{
  char res_buf[1024];
  get_res(ac, res_buf, conv);

  return do_find_conv_res(db, src, res_buf);
}

static void
chomp_line(char *buf)
{
  int len = strlen(buf);
  if (buf[len-1] == '\n') {
    buf[len-1] = 0;
  }
}

struct res_db *
create_db(void)
{
  struct res_db *db;

  db = malloc(sizeof(struct res_db));
  db->res_list.next = NULL;
  db->tail = &db->res_list;
  db->total = 0;
  db->res.unknown = 0;
  db->res.ok = 0;
  db->res.miss = 0;
  db->res.dontcare = 0;
  db->split.unknown = 0;
  db->split.ok = 0;
  db->split.miss = 0;
  db->split.dontcare = 0;

  return db;
}

void
read_db(struct res_db *db, const char *fn)
{
  FILE *fp;
  char line[1024];

  if (!fn) {
    return ;
  }
  fp = fopen(fn, "r");
  if (!fp) {
    return ;
  }
  while (fgets(line, 1024, fp)) {
    char src[1024], res[1024], check[1024];
    struct conv_res *cr;
    int nr;
    chomp_line(line);
    if (line[0] == '#' || line[0] == 0) {
      continue;
    }
    nr = sscanf(line, "%s %s %s", src, res, check);
    if (nr == 1) {
      cr = do_find_conv_res(db, src, NULL);
      cr->check = CHK_UNKNOWN;
      continue;
    }
    if (nr < 2) {
      continue;
    }
    cr = do_find_conv_res(db, src, res);
    if (nr == 2) {
      cr->check = CHK_OK;
      continue;
    }
    if (check[0] == 'O') {
      cr->check = CHK_OK;
    } else if (check[0] == 'X') {
      cr->check = CHK_MISS;
    } else if (check[0] == '*') {
      cr->check = CHK_DONTCARE;
    } else {
      cr->check = CHK_UNKNOWN;
    }
  }
}

static void
fill_conv_info(struct word *w, struct cand_elm *elm)
{
  /*w->conv_xs, w->wt*/
  struct dic_ent *de;
  if (elm->nth == -1 ||
      elm->nth >= elm->se->nr_dic_ents) {
    w->conv_xs = NULL;
    w->wt = NULL;
    return ;
  }
  if (!elm->se->dic_ents) {
    w->conv_xs = NULL;
    w->wt = NULL;
    return ;
  }
  de = elm->se->dic_ents[elm->nth];
  w->conv_xs = anthy_xstr_dup(&de->str);
  w->wt = de->wt_name;
  w->hash = anthy_xstr_hash(w->conv_xs);
}

static void
init_word(struct word *w, int type)
{
  w->type = type;
  w->raw_xs = NULL;
  w->conv_xs = NULL;
  w->wt = NULL;
  w->seg_class = -1;
}

static void
free_word(struct word *w)
{
  anthy_free_xstr(w->raw_xs);
  anthy_free_xstr(w->conv_xs);
}

/* Ω */
static void
fill_indep_word(struct word *w, struct cand_elm *elm)
{
  init_word(w, WORD_INDEP);
  /**/
  w->id = elm->id;
  /* Ѵɤߤ */
  w->raw_xs = anthy_xstr_dup(&elm->str);
  w->yomi_hash = anthy_xstr_hash(w->raw_xs);
  w->hash = 0;
  /**/
  fill_conv_info(w, elm);
}

/* ° */
static void
fill_dep_word(struct word *w, struct cand_elm *elm)
{
  init_word(w, WORD_DEP);
  /**/
  w->id = 0;
  w->hash = anthy_xstr_hash(&elm->str);
  w->yomi_hash = w->hash;
  w->raw_xs = anthy_xstr_dup(&elm->str);
}

static void
print_features(struct feature_list *fl)
{
  int i, nr;
  if (!fl) {
    return ;
  }
  nr = anthy_feature_list_nr(fl);
  if (nr == 0) {
    return ;
  }
  printf(" features=");
  for (i = 0; i < nr; i++) {
    if (i > 0) {
      printf(",");
    }
    printf("%d", anthy_feature_list_nth(fl, i));
  }
}

static void
print_word(struct word *w, struct feature_list *fl)
{
  if (w->type == WORD_DEP) {
    /* ° */
    printf("dep_word hash=%d ", w->hash);
    anthy_putxstrln(w->raw_xs);
    return ;
  }
  /* Ω */
  printf("indep_word id=%d hash=%d yomi_hash=%d",
	 w->id, w->hash, w->yomi_hash);
  if (w->seg_class > -1) {
    printf(" seg_class=%d", w->seg_class);
  }
  /**/
  if (fl) {
    print_features(fl);
  }
  /* ʻ */
  if (w->wt) {
    printf(" %s", w->wt);
  } else {
    printf(" null");
  }
  /* ʸ */
  if (w->conv_xs) {
    printf(" ");
    anthy_putxstr(w->conv_xs);
  } else {
    printf(" null");
  }
  printf(" ");
  anthy_putxstrln(w->raw_xs);
}

static int
get_seg_class(struct seg_ent *seg)
{
  struct cand_ent *ce;
  if (!seg) {
    return -1;
  }
  ce = seg->cands[0];
  if (ce->mw) {
    return ce->mw->seg_class;
  }
  return -1;
}

static void
set_features(struct feature_list *fl,
	     struct seg_ent *cur_seg)
{
  int cl;
  if (cur_seg) {
    cl = get_seg_class(cur_seg);
  } else {
    cl = SEG_TAIL;
  }
  anthy_feature_list_set_cur_class(fl, cl);
  if (cur_seg) {
    anthy_feature_list_set_dep_word(fl, cur_seg->cands[0]->dep_word_hash);
  }
}

static void
print_element(struct seg_ent *seg, struct cand_elm *elm,
	      struct feature_list *fl)
{
  struct word w;

  int seg_class = get_seg_class(seg);
  if (elm->str.len == 0) {
    return ;
  }
  if (elm->id != -1) {
    /* Ω */
    fill_indep_word(&w, elm);
    w.seg_class = seg_class;
    print_word(&w, fl);
  } else {
    /* ° */
    fill_dep_word(&w, elm);
    print_word(&w, NULL);
  }
  free_word(&w);
}

static void
print_unconverted(struct cand_ent *ce)
{
  printf("unknown ");
  anthy_putxstrln(&ce->str);
}

static void
print_eos(void)
{
  struct feature_list fl;
  anthy_feature_list_init(&fl);
  set_features(&fl, NULL);
  printf("eos seg_class=%d", SEG_TAIL);
  print_features(&fl);
  printf("\n");
  anthy_feature_list_free(&fl);
}

static void
print_segment(struct seg_ent *seg)
{
  int i;
  struct feature_list fl;
  struct cand_ent *ce = seg->cands[0];

  anthy_feature_list_init(&fl);
  set_features(&fl, seg);
  for (i = 0; i < ce->nr_words; i++) {
    print_element(seg, &ce->elm[i], &fl);
  }
  anthy_feature_list_free(&fl);
}

void
print_context_info(anthy_context_t ac)
{
  int i;

  printf("segments: %d\n", ac->seg_list.nr_segments);
  /* ʸФ */
  for (i = 0; i < ac->seg_list.nr_segments; i++) {
    struct seg_ent *seg = anthy_get_nth_segment(&ac->seg_list, i);
    struct cand_ent *ce = seg->cands[0];

    /* ǤФ */
    /* Ǥ̵ΤϤΤޤɽ */
    if (!ce->nr_words) {
      print_unconverted(ce);
    } else {
      print_segment(seg);
    }
    /**/
  }
  print_eos();
  printf("\n");
}
