#include "../include/animorph/ObjExporter.h"

using namespace std;
using namespace Animorph;

void ObjExporter::createOBJStream (ostringstream &out_stream, const string& basename, bool usemtl)
{
  VertexVector   &vertexvector   (mesh.getVertexVectorRef ());
  FaceVector     &facevector     (mesh.getFaceVectorRef ());
  MaterialVector &materialvector (mesh.getMaterialVectorRef ());
  TextureVector  &texturevector  (mesh.getTextureVectorRef ());

  // TODO: decide how much accracy we need
  //out_stream << setprecision (12);

  // write header
  out_stream << "# OBJ File" << endl;
  //out_stream << "# www..." << endl;

  if (usemtl)
  {
    out_stream << "mtllib " << basename << ".mtl" << endl;
  }

  out_stream << "o " << basename << endl; // name of mesh

  // write vertices
  for (unsigned int i = 0; i < vertexvector.size (); i++)
  {
    Vertex &vertex = vertexvector[i];

//    cout << "before: " << vertex.co << endl;
    Vector3f vector = vertex.co * tm;
//    cout << "after: " << vector << endl << endl;

    out_stream <<
    "v " << vector.x <<
    " "  << vector.y <<
    " "  << vector.z << endl;
  }

  // write texture UV coordinates
  if (facevector.size () == texturevector.size ())
  {
    for (unsigned int i = 0; i < facevector.size (); i++)
    {
      TextureFace &texture_face = texturevector[i];

      for (unsigned int n = 0; n < texture_face.size (); n++)
      {
        Vector2f &uv = texture_face[n];

        // the -uv.y+1.0 stuff is a hack for renderman input UV data
        // TODO: change renderman import UV data
        out_stream << "vt " << uv.x << " " << -uv.y << " 0.0" << endl;
      }
    }
  }
  else
  {
    cerr << "Couldn't export texture coordinates! "
    << facevector.size () << " != " << texturevector.size ()
    << endl;
  }

  // write faces
  int old_material_index = -1;
  int texture_number = 1;
  for (unsigned int i = 0; i < facevector.size (); i++)
  {
    const Face &face(facevector[i]);

    int material_index = face.getMaterialIndex ();

    if ((material_index != -1) && usemtl && (material_index != old_material_index))
    {
      // material reference
      out_stream << "usemtl " << materialvector[material_index].getName ()
      << endl;
    }

    if (face.getSize () > 0)
      out_stream << "f ";

    for (unsigned int j = 0; j < face.getSize(); j++)
    {
      int vertex_number = face.getVertexAtIndex(j);
      //cout << texture_number << endl;

      // face vertex geometry
      out_stream << vertex_number + 1;

      out_stream << "/";

      out_stream << texture_number << " ";

      texture_number++;
    }
    out_stream << endl;

    old_material_index = material_index;
  }
}

void ObjExporter::createMTLStream (ostringstream &out_stream, const string& basename)
{
  MaterialVector &materialvector = mesh.getMaterialVectorRef ();

  out_stream << "# Material file for " << basename << ".obj" << endl << endl;

  for (unsigned int i = 0; i < materialvector.size (); i++)
  {
    Material &material = materialvector[i];
    const Color &colRGB = material.getRGBCol ();

    out_stream << "newmtl " << material.getName () << endl;
    out_stream << "Kd "
    << colRGB.red () << " "
    << colRGB.green () << " "
    << colRGB.blue () << endl << endl;
  }
}

bool ObjExporter::exportFile (const string& filename)
{
    printf("ObjExporter::exportFile() : Trying to save file '%s'\n", filename.c_str());

  string file_ending_cut(cutFileEnding (filename, ".obj"));

  string bname = file_ending_cut.substr (filename.find_last_of (PATH_SEPARATOR)+1, filename.size ());

  FileWriter file_writer;
  file_writer.open (file_ending_cut + ".obj");

  if (file_writer)
  {
    std::ostringstream out_stream;
    createOBJStream (out_stream, bname);

    file_writer << out_stream.str ();
    file_writer.close ();

    file_writer.open (file_ending_cut + ".mtl");

    if (file_writer)
    {
      std::ostringstream out_stream;
      createMTLStream (out_stream, bname);

      file_writer << out_stream.str ();
      file_writer.close ();
    }
  }

  if (!file_writer)
    return false;

  return true;
}
