/* angst - signal.c
 * by Patroklos Argyroudis <argp@bsd.gr>
 *
 * Signal handling functions.
 *
 * $Id: signal.c,v 1.4 2001/02/04 04:33:43 argp Exp $
 */ 

#include "angst.h"

void
catcher(int signal)
{
 if((fflush(fp)) == EOF)
  xprintf("fflush error: %s\n", strerror(errno));
 if((fclose(fp)) == EOF)
  xprintf("fclose error: %s\n", strerror(errno));

 if((chmod(logfile, (S_IRUSR | S_IWUSR))) == -1)
  xprintf("chmod error: %s\n", strerror(errno));

 pcap_close(pd);
 exit(EXIT_SUCCESS);
}

void
sig_flood(int signal)
{
 /* call the MAC flooder */
 mac_flood();

 /* how often is the flooder() called */
 alarm(seconds);
 return;
}

void
sig_arp(int signal)
{
 arp_reply();
 
 /* how often is arp_reply() called */
 alarm(seconds);
 return;
}

/* EOF */
