/* angst - angst.h
 * by Patroklos Argyroudis <argp@bsd.gr>
 *
 * The main header of the program.
 *
 * $Id: angst.h,v 1.30 2001/02/05 03:22:57 argp Exp $
 */

#include <stdarg.h>
#include <sys/param.h>
#include <sys/sysctl.h>
#include <libnet.h>
#include <pcap.h>

/* the default bpf program expression, if you change it and you want
 * to use the ARP man-in-the-middle active sniffing method, be sure
 * to specify that you want to capture ARP packets too
 */
#define FILTER "arp or (tcp and (dst port 21 or dst port 23 or dst port 110 or dst port 143))"

#define SNAPLEN	3000	/* maximum number of bytes to capture */
#define TIMEOUT	1000	/* read timeout in milliseconds */

#define	BUFSIZE		8192	/* maximum captured bytes per connection */
#define	SMALBUF		256
#define	TOKENS		128
#define	EASIZE		30
#define MIBLEN		4	/* for sysctl() */

#define	FPORT		1
#define	LPORT		65535

/* every WAKETIME seconds the specified active sniffing method
 * is activated, this value is the default for both methods
 */
#define WAKETIME	300
#define	MACPKTS		1000	/* flood MACPKTS number of packets */

#define LOGFILE	"./angst.log"

typedef struct host Host;

struct host
{
 u_char tpa[4];			/* target protocol address */
 u_char sha[ETHER_ADDR_LEN];	/* sender hardware address */
 u_char spa[4];			/* sender protocol address */
 Host *prev;
 Host *next;
};

pcap_t *pd;			/* packet capture descriptor */
u_char *device;			/* pointer to the network device */
u_int hdrlen;			/* encapsulation header length */
int arp_flag;
int resolve_flag;
u_int seconds;			/* used for both active sniffing methods */
int pktcount;
char *logfile;			/* pathname of the log file */
u_char buffer[BUFSIZE];		/* to store the data of a connection */
FILE *fp;

Host *head;
Host *tail;

pcap_handler callback; 

void		xprintf(char *msg, ...);
void		init_buf(char x[], int size);
char *		build_expression(char *arg);
void		dissect(char *user, struct pcap_pkthdr *pkthdr, u_char *pkt);
void		mac_flood(void);
void		catcher(int signal);
void		sig_flood(int signal);
void		usage(char *name);
void		display_version(const char *ver);
int		find_header_length(int d);
int		daemonize(const char *path);
void		arp_reply(void);
void		sig_arp(int signal);
void		add_host(u_char tp[], u_char sh[], u_char sp[]);
#ifdef LINUX
void		linux_enable_ip_forwarding(void);
extern size_t	strlcat(char *dst, const char *src, size_t siz);
extern size_t	strlcpy(char *dst, const char *src, size_t siz);
#else /* {Free,Net,Open}BSD */
void		bsd_enable_ip_forwarding(void);
#endif /* LINUX */
#ifdef DEBUG
char *		format_hwaddr(u_char *ea);
#endif /* DEBUG */

/* EOF */
