/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: c_window.c,v 1.1.1.1 2003/08/14 03:28:52 cosine Exp $
 */

#include <stdlib.h>

#include "defs.h"
#include "main.h"
#include "msg.h"
#include "print.h"
#include "window.h"

/*
c_window()
  List/manipulate curses windows

Return: 0 upon failure
        1 upon success
*/

int
c_window(struct aldWorkspace *ws, int ac, char **av)

{
#ifdef USE_CURSES

  struct FrameInfo *fptr;
  char *endptr;
  long num;

  if (ac < 2)
  {
    /*
     * List all windows and their descriptions
     */
    Print(ws, P_COMMAND, "Listing window numbers");
    Print(ws,
          P_COMMAND,
          "Type \"window <num>\" or \"CTRL-W <num>\" to switch windows");
    Print(ws, P_COMMAND, "");

    for (fptr = Frames; fptr->frame; ++fptr)
      Print(ws, P_COMMAND, "%-10d %-20s", (*(fptr->frame))->number, fptr->desc);
  }
  else
  {
    num = strtol(av[1], &endptr, 0);
    if ((endptr == av[1]) || (*endptr != '\0'))
    {
      Print(ws, P_COMMAND, MSG_INVNUM, av[1]);
      return (0);
    }

    SwitchCurrentFrame((int) num);
  }

#endif /* USE_CURSES */

  return (1);
} /* c_window() */
