/*
 * Assembly Language Debugger
 *
 * Copyright (C) 2000 Patrick Alken
 * This program comes with absolutely NO WARRANTY
 *
 * Should you choose to use and/or modify this source code, please
 * do so under the terms of the GNU General Public License under which
 * this program is distributed.
 *
 * $Id: c_clear.c,v 1.1.1.1 2003/08/14 03:28:52 cosine Exp $
 */

#include <stdlib.h>

#include "main.h"
#include "msg.h"
#include "scroll.h"
#include "print.h"
#include "window.h"

/*
c_clear()
  Clear the current active window

Return: 0 upon failure
        1 upon success
*/

int
c_clear(struct aldWorkspace *ws, int ac, char **av)

{
#ifdef USE_CURSES

  struct Frame *frame;
  long winnum;
  char *endptr;

  if (ac < 2)
    frame = CurrentFrame;
  else
  {
    winnum = strtol(av[1], &endptr, 0);
    if ((endptr == av[1]) || (*endptr != '\0'))
    {
      Print(ws, P_COMMAND, MSG_INVNUM, av[1]);
      return (0);
    }

    if (!(frame = FindFrameByNumber(winnum)))
    {
      Print(ws,
            P_COMMAND,
            "Invalid window number: %d",
            winnum);
      return (0);
    }
  }

  ClearScrollWindow(frame);

#endif /* USE_CURSES */

  return (1);
} /* c_clear() */
