#!/usr/bin/perl


use strict;
use CPAN;

#Defaults:
my $interface="eth0";
my $daemon="0";
my $smb="0";
my $quiet="0";
my $useDB="0";
my $currentDir=`pwd`;
chomp($currentDir);
my $response="";
my $nodb=1;
my $useSyslog=0;
my $configLocation="/etc/aimsniff.config";
my $exeLocation="/usr/";
my $rcLocation="/etc/rc.d/init.d/aimsniff";
my $dumpHandles=0;
my ($dbname,$dbserver,$dbuser,$dbpwd,$result,$handlesfile,$useSyslog,$childCPUMaxPct,$fh)=undef;


my @req_modules=(qw(Net::Pcap 
	NetPacket::Ethernet 
	NetPacket::IP 
	NetPacket::TCP 
	NetPacket::UDP 
	DBI 
	DBD::mysql
	Unicode::String 
	Proc::Daemon 
	Proc::Simple 
	Unix::Syslog
	GDBM_File
	FileHandle));
	
print "\n\n###############################################################\n";
print "\tAIM Sniff v. 0.9b\n";
print "\t\tInstall Script v. 0.1\n";
print "###############################################################\n\n";
print 'Thank you for trying AIM Sniff.  Please read each prompt
carefully.  If you have problems with the installation please 
try the AIM Sniff forums for help first.  http://www.aimsniff.com/';

print "\n\nAre you ready to continue? (Y/N) [Y]: ";
$response=<STDIN>;
if($response=~/n/i){
	exit;
}



foreach my $modu(@req_modules){
	print "Checking for: $modu ...\t";
	eval "use $modu";
	if(!$@){
		print "Ok\n";
		next;
	}else{
		print "Failed\n";
		if($modu ne qw(Net::Pcap)){
			print "\n\nWould you like to try and install this package ($modu) through CPAN? (Y/N) [Y]:";
			$response=<STDIN>;
			if(($response=~/y/i) or ($response eq "\n")){
				if($modu eq qw(DBD::mysql)){
					print "\n\nDBD::mysql is a very difficult module to install but I will do my best.";
					print "Do you run Red Hat 9?: (Y/N) [Y]";
					$response=<STDIN>;
					if(($response=~/y/i) or ($response eq "\n")){
						`export LANG=C`;
					}
				}
				if($modu eq qw(DBI)){
					my $inst_obj = CPAN::Shell->install(qw(Bundle::Mysql));
				}else{
					my $inst_obj = CPAN::Shell->install($modu) ;
				}
				eval "use $modu";
				if($@){
					print "\n\nCould not install $modu for some reason.  Try it manually.";
					exit;
				}else{
					sleep(5);
					print "\n\nInstallation complete, continuing with setup\n";
				}
			}
		}else{
			print "\n\nDownloading Net-Pcap\n";
			`wget http://search.cpan.org/CPAN/authors/id/T/TI/TIMPOTTER/Net-Pcap-0.04.tar.gz`;
			`tar -xzvf Net-Pcap-0.04.tar.gz`;
			`cd ./Net-Pcap-0.04;perl ./Makefile.PL;make && make install`;
			eval "use $modu";
			if($@){
				print "\n\nCould not install $modu for some reason.  Try it manually.";
				exit;
			}else{
				print "\n\nInstallation complete, continuing with setup\n";
			}
		}
	}
}

print "\n\n####################################################################\n";
print "Looks like you have all the module dependencies for AIM Sniff.\n";
print "Continuing with install...\n";
print "####################################################################\n\n";

#Do you want to use mysql?
print "Do you want to use database-mysql (Y/N) [Y]: ";
$response=<STDIN>;
if(($response=~/y/i) or ($response eq "\n")){
	$nodb="0";
	print "Yes, I am going to use a database\n";
	print "Enter database name [aimsniff]: ";
	$dbname=<STDIN>;
	chomp($dbname);
	if(!$dbname){
		$dbname="aimsniff";
	}
	print "Enter database server [localhost]: ";
	$dbserver=<STDIN>;
	chomp($dbserver);
	if(!$dbserver){
		$dbserver="localhost";
	}
	print "Enter database user [aim_user]: ";
	$dbuser=<STDIN>;
	chomp($dbuser);
	if(!$dbuser){
		$dbuser="aim_user";
	}
	print "Enter database password for $dbuser: ";
	$dbpwd=<STDIN>;
	chomp($dbpwd);
	
	print "Would you like me to create the database (say no if this is an upgrade)? (Y/N) [N]: ";
	$response=<STDIN>;
	if($response=~/y/i){
		$result=`mysqladmin create $dbname`;
		$result=`mysql -f $dbname < $currentDir/table.struct`;
		$result=`echo 'GRANT ALL ON $dbname.* TO $dbuser\@localhost IDENTIFIED BY "$dbpwd"' | mysql $dbname`; 
	}
	
}

print "Do you want to use a handles file (Y/N) [Y]: ";
$response=<STDIN>;
if(($response=~/y/i) or ($response eq "\n")){
	print "What file name do you want to use (including path): ";
	$handlesfile=<STDIN>;
	chomp($handlesfile);
	$result=`touch $handlesfile`;
	if($result){
		print "Error: $result";
	}
	print "Do you want to dump your handles file at the start of each run of AIM Sniff? (Y/N) [Y]: ";
	$response=<STDIN>;
	if(($response=~/y/i) || ($response eq "\n")){
		$dumpHandles=1;
	}
	print "Handles files from versions < 0.9 are not compatible with this version, sorry for the inconvenience.\n";
}

print "Which network interface do you want to sniff on [eth0]: ";
$response=<STDIN>;
chomp($response);
$interface=$response if($response ne "");

#Check for SMB use
$result=`which nmblookup`;
if($result=!/no nmblookup/){
	print "Found nmblookup, Would you like support for SMB lookups (Y/N) [Y]: ";
	$response=<STDIN>;
	if(($response=~/y/i) or ($response eq "\n")){
		$smb="1";
	}
}else{
	print "Did not find nmblookup, if you want to use SMG lookups, install it and then add SMB=1 to your config file\n\n";
}


#Run as daemon
print "Do you want to run AS as a daemon (Y/N) [Y]: ";
$response=<STDIN>;
if(($response=~/y/i) or ($response eq "\n")){
	$daemon="1";
}

#Run quietly
print "Do you want to run AS in quiet mode(no messages to STDOUT) (Y/N) [Y]: ";
$response=<STDIN>;
if(($response=~/y/i) or ($response eq "\n")){
	$quiet="1";
}

#Use syslog?
print "Do you want to enable reporting to syslog? (Y/N) [Y]: ";
$response=<STDIN>;
if(($response=~/y/i) or ($response eq "\n")){
	$useSyslog="1";
}

#Get child process limits
print "At what cpu usage percentage would you like to restart AS (you shouldn't use anything higher than 80) ? (an integer) [80]: ";
$response=<STDIN>;
if($response=~/\d*/i){
	$childCPUMaxPct=chomp($response);
}elsif($response eq "\n"){
	$childCPUMaxPct=80;
}

print "Where would you like to store the config file [/etc/aimsniff.config]: ";
$response=<STDIN>;
chomp($response);
if($response){
	$configLocation=$response;
}


$fh=new FileHandle;
$fh->open(">$configLocation") or die "Could not open config file for writing: $^E\n";
print $fh "#dumpfile=./sampleLogins.pcap 
#packetCount=10
#filter='tcp and port 5190'
dumpHandles=$dumpHandles
dev=$interface
promisc=1
timeout=1000
SMB=$smb
daemon=$daemon
quiet=$quiet
nodb=$nodb
host=$dbserver
user=$dbuser
password=$dbpwd
database=$dbname
useSyslog=$useSyslog
parentPollTimeout=10
childCPUMaxPct=$childCPUMaxPct";

if($handlesfile){
	print $fh "\nhandlefile=$handlesfile\n";	
}
$fh->close;

print "Where would you like to store the AIM Sniff executable [/usr/]: ";
$response=<STDIN>;
chomp($response);
if($response){
	$exeLocation=$response;
}
$result=`cp $currentDir/aimSniff.pl $exeLocation`;

###Make and Copy rc file
print "Should I build an rc to start and stop AS as a service? (Y/N) [Y]: ";
$response=<STDIN>;
if(($response=~/y/i) or ($response eq "\n")){
	print "Where would you like to put it (full path) [/etc/rc.d/init.d/aimsniff]: ";
	$response=<STDIN>;
	chomp($response);
	if($response){
		$rcLocation=$response;
	}
	$fh->open(">$rcLocation") or die "Could not open $rcLocation for writing: $^E\n";
	print $fh '#!/bin/bash

case $1 in
start)
	echo Starting aimSniff...
	';
	print $fh $exeLocation . "aimSniff.pl -C=$configLocation";
	print $fh ';;
stop)
	if [ -r /var/run/aimsniff_parent.pid ]; then
		echo Stopping aimSniff...
		kill -QUIT `cat /var/run/aimsniff_parent.pid`
	fi
	;;
restart)
	$0 stop
	sleep 2
	$0 start
	;;
*)
	echo "Usage: $0 [start|stop|restart]"
	;;
esac';
	$fh->close;
}

$result=`chmod 755 $rcLocation`;


print "\n\n####################################################################\n";
print 'This completes the AIM Sniff setup process.  You can start AIM Sniff
by running `service aimsniff start`.  Some resources you should be aware of are:
	http://www.aimsniff.com  Official website of AIM Sniff including support forums
	http://shop.aimsniff.com Get your cool AIM Sniff gear
	aimsniff-announce@lists.sourceforge.net To be notified of new releases.

If you enjoy using this product, please post something in the AIM Sniff forums.

Thanks for trying AIM Sniff';
print "\n\n####################################################################\n";