#!/usr/bin/perl -w
#
# $Id: makeimages.pl,v 1.1 2003/03/03 11:39:38 kjc Exp $
#
# usage: makeimages.pl [-l logdir] timestamp [timestamp2 ...]
#
# create daily and weekly plot graphs under the current directory.
# timestamp should be "yyyymmdd".
# for example, if "20010806" is specified, it creates 4 png files,
# 2001/08/06/20010806.{saddr,daddr,sport,dport}.png, from
# "$agurilogdir/2001/08/06/??/*.agr".
#
use POSIX;

$agurilogdir  = ".";	# assume logdir is cur dir or use of -l option
$plotdata = "$agurilogdir/plotdata";
$aguri    = "/usr/local/bin/aguri";
$makeplot = "/usr/local/lib/aguri/makeplot.pl";
$gnuplot  = "/usr/local/bin/gnuplot";
$numflows = 15;
$create_weekimg = 1;

#
# usually, you don't need to edit below this line
#
umask(022);
chomp($cwd = `pwd`);

while ($tstamp = shift @ARGV) {
    if ($tstamp eq "-l") {
	$agurilogdir = shift @ARGV;
	$tstamp = shift @ARGV
    }

    chdir $cwd
	or die "can't cd to $cwd\n";

    $year  = substr $tstamp, 0, 4;
    $month = substr $tstamp, 4, 2;
    $day   = substr $tstamp, 6, 2;

    #
    # create directories if they don't exist.
    #
    mkdir "$year", 0755 unless -d "$year";
    mkdir "$year/$month", 0755 unless -d "$year/$month";
    mkdir "$year/$month/$day", 0755 unless -d "$year/$month/$day";

    chdir "$agurilogdir"
	or die "can't cd to $agurilogdir\n";
    chomp($agurilogdir = `pwd`);
    chdir "$year/$month/$day"
	or die "can't cd to $agurilogdir/$year/$month/$day\n";
    @agrfiles = glob("??/*.agr");
    unless ($#agrfiles >= 0) { die "can't find .agr files!\n"; }
    $agrs = join ' ', @agrfiles;

    # src address plot
    system "$aguri -P -xs -yM -n $numflows $agrs > $plotdata";
    system "$makeplot $plotdata | $gnuplot > $cwd/$year/$month/$day/$tstamp.saddr.png";
    system "$makeplot -3D $plotdata | $gnuplot > $cwd/$year/$month/$day/$tstamp.saddr-3d.png";

    # dst address plot
    system "$aguri -P -xd -yM -n $numflows $agrs > $plotdata";
    system "$makeplot $plotdata | $gnuplot > $cwd/$year/$month/$day/$tstamp.daddr.png";
    system "$makeplot -3D $plotdata | $gnuplot > $cwd/$year/$month/$day/$tstamp.daddr-3d.png";

    # src port plot
    system "$aguri -P -xS -yM -n $numflows $agrs > $plotdata";
    system "$makeplot $plotdata | $gnuplot > $cwd/$year/$month/$day/$tstamp.sproto.png";
    system "$makeplot -3D $plotdata | $gnuplot > $cwd/$year/$month/$day/$tstamp.sproto-3d.png";

    # dst port plot
    system "$aguri -P -xD -yM -n $numflows $agrs > $plotdata";
    system "$makeplot $plotdata | $gnuplot > $cwd/$year/$month/$day/$tstamp.dproto.png";
    system "$makeplot -3D $plotdata | $gnuplot > $cwd/$year/$month/$day/$tstamp.dproto-3d.png";

    #
    # create an index file
    #
    open(HOUT,"> $cwd/$year/$month/$day/index.html");
    print HOUT "<html>\n";
    print HOUT "<head>\n";
    print HOUT "<title>aguri data for $tstamp</title>\n";
    print HOUT "</head>\n\n";
    print HOUT "<body bgcolor=\"#FFFFFF\" text=\"#000000\" link=\"#330099\" alink=\"#FF9933\" vlink=\"#6666CC\">\n";
    print HOUT "<h3>aguri data for $tstamp</h3><hr>\n";
    print HOUT "<img src=$tstamp.saddr-3d.png alt=\"[src address plot]\">\n";
    print HOUT "<img src=$tstamp.daddr-3d.png alt=\"[dst address plot]\">\n";
    print HOUT "<img src=$tstamp.sproto-3d.png alt=\"[src proto plot]\">\n";
    print HOUT "<img src=$tstamp.dproto-3d.png alt=\"[dst proto plot]\">\n";
    print HOUT "<p><hr>\n";
    print HOUT "<img src=$tstamp.saddr.png alt=\"[src address plot]\">\n";
    print HOUT "<img src=$tstamp.daddr.png alt=\"[dst address plot]\">\n";
    print HOUT "<img src=$tstamp.sproto.png alt=\"[src proto plot]\">\n";
    print HOUT "<img src=$tstamp.dproto.png alt=\"[dst proto plot]\">\n";
    print HOUT "<p><hr>last update: " . localtime(time) . "\n";
    print HOUT "</body>\n";
    print HOUT "</html>\n";
    close(HOUT);

    #
    # create weekly plots
    #
    $nweek = 0;
    if ($create_weekimg != 0) {
	chdir "$agurilogdir/$year"
	    or die "can't cd to $agurilogdir/$year\n";

	$t = POSIX::mktime(0, 0, 1, $day, $month - 1, $year - 1900);
	($wday, $yday) = (localtime($t))[6,7];
	$nweek = int(($yday + 7 - $wday) / 7) + 1;

	@agrfiles = ();
	for ($i = $wday; $i >= 0; $i--) {
	    @tm = localtime($t - $i * 24*60*60);
	    $day2  = int($tm[3] / 10) . int($tm[3] % 10);
	    $mon2  = int(($tm[4] + 1) / 10) . int(($tm[4] + 1) % 10);

	    if (-d "$mon2/$day2") {
		push @agrfiles, glob("$mon2/$day2/*.agr");
	    }
	}
	unless ($#agrfiles >= 0) { die "can't find .agr files!\n"; }
	$agrs = join ' ', @agrfiles;

	# src address plot
	system "$aguri -P -xs -yM -n $numflows $agrs > $plotdata";
	system "$makeplot $plotdata | $gnuplot > $cwd/$year/week$nweek.saddr.png";
	system "$makeplot -3D $plotdata | $gnuplot > $cwd/$year/week$nweek.saddr-3d.png";
	# dst address plot
	system "$aguri -P -xd -yM -n $numflows $agrs > $plotdata";
	system "$makeplot $plotdata | $gnuplot > $cwd/$year/week$nweek.daddr.png";
	system "$makeplot -3D $plotdata | $gnuplot > $cwd/$year/week$nweek.daddr-3d.png";
	# src proto plot
	system "$aguri -P -xS -yM -n $numflows $agrs > $plotdata";
	system "$makeplot $plotdata | $gnuplot > $cwd/$year/week$nweek.sproto.png";
	system "$makeplot -3D $plotdata | $gnuplot > $cwd/$year/week$nweek.sproto-3d.png";
	# dst proto plot
	system "$aguri -P -xD -yM -n $numflows $agrs > $plotdata";
	system "$makeplot $plotdata | $gnuplot > $cwd/$year/week$nweek.dproto.png";
	system "$makeplot -3D $plotdata | $gnuplot > $cwd/$year/week$nweek.dproto-3d.png";

	#
	# create an index file
	#
	open(HOUT,"> $cwd/$year/week$nweek.html");
	print HOUT "<html>\n";
	print HOUT "<head>\n";
	print HOUT "<title>aguri data for week $nweek</title>\n";
	print HOUT "</head>\n\n";
	print HOUT "<body bgcolor=\"#FFFFFF\" text=\"#000000\" link=\"#330099\" alink=\"#FF9933\" vlink=\"#6666CC\">\n";
	print HOUT "<h3>aguri data for week $nweek</h3><hr>\n";
	print HOUT "<img src=week$nweek.saddr-3d.png alt=\"[src address plot]\">\n";
	print HOUT "<img src=week$nweek.daddr-3d.png alt=\"[dst address plot]\">\n";
	print HOUT "<img src=week$nweek.sproto-3d.png alt=\"[src proto plot]\">\n";
	print HOUT "<img src=week$nweek.dproto-3d.png alt=\"[dst proto plot]\">\n";
	print HOUT "<p><hr>\n";
	print HOUT "<img src=week$nweek.saddr.png alt=\"[src address plot]\">\n";
	print HOUT "<img src=week$nweek.daddr.png alt=\"[dst address plot]\">\n";
	print HOUT "<img src=week$nweek.sproto.png alt=\"[src proto plot]\">\n";
	print HOUT "<img src=week$nweek.dproto.png alt=\"[dst proto plot]\">\n";
	print HOUT "<p><hr>last update: " . localtime(time) . "\n";
	print HOUT "</body>\n";
	print HOUT "</html>\n";
	close(HOUT);
    }
}

#
# create a top index file
#
open(HOUT,"> $cwd/$year/index.html");
print HOUT "<html>\n";
print HOUT "<head>\n";
print HOUT "<title>aguri data</title>\n";
print HOUT "</head>\n\n";
print HOUT "<body bgcolor=\"#FFFFFF\" text=\"#000000\" link=\"#330099\" alink=\"#FF9933\" vlink=\"#6666CC\">\n";
print HOUT "<p>\n";
print HOUT "<h3>weekly plots</h3>\n";
$i = 0;
@windices = glob("$cwd/$year/week?.html");
push @windices, glob("$cwd/$year/week??.html");
while ($_ = shift @windices) {
    if (/.*\/week(\d+).html/) {
	print HOUT " <a href=week$1.html>week$1</a> \n";
	if ($i % 10 == 9) {
	    print HOUT "<br>\n";
	}
    }
    $i++;
}
print HOUT "<p><hr>\n";
print HOUT "<h3>daily plots</h3>\n"; 
$month = 0;
while (<$cwd/$year/??/??/index.html>) {
    if (/.*\/(\d{4})\/(\d{2})\/(\d{2})\/index\.html/) {
	if ($month != $2) {
	    $month = $2;
	    print HOUT "\n\n<br><b>$1/$month: </b>\n";
	}
	print HOUT " <a href=$2/$3/index.html>$3</a> \n";
    }
}
print HOUT "<p><hr>last update: " . localtime(time) . "\n";
print HOUT "</body>\n";
print HOUT "</html>\n";
close(HOUT);

exit 0;
