/* $Id */
/* $Log */
/* progress.c: uses interval timer to output % complete regularly
*/

char progress_RCSid[] = "$Revision: 1.1 $";

#include "agm.h"

void print_progress () {
  printf ("%02d\b\b", pct);
  fflush (stdout);
}

void arm_timer ()
{
  struct sigaction action;
  struct itimerval tmr;

  action.sa_handler = &print_progress;
  action.sa_mask = 0;
  action.sa_flags = 0;
  sigaction (SIGALRM, &action, NULL);
  
  tmr.it_interval.tv_sec = UPDATETIME;
  tmr.it_interval.tv_usec = 0;
  tmr.it_value.tv_sec = UPDATETIME;
  tmr.it_value.tv_usec = 0;
  setitimer (ITIMER_REAL, &tmr, NULL);
}

void disarm_timer ()
{
  struct sigaction action;
  struct itimerval tmr;

  tmr.it_interval.tv_sec = 0;
  tmr.it_interval.tv_usec = 0;
  tmr.it_value.tv_sec = 0;
  tmr.it_value.tv_usec = 0;
  setitimer (ITIMER_REAL, &tmr, NULL);

  action.sa_handler = SIG_DFL;
  action.sa_mask = 0;
  action.sa_flags = 0;
  sigaction (SIGALRM, &action, NULL);
}
