/*  $Id: Controller.h,v 1.11 2009/02/27 03:08:33 sarrazip Exp $
    Controller.h - Source of commands from the user.

    afternoonstalker - A robot-killing video game.
    Copyright (C) 2001-2009 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
    02111-1307, USA.
*/

#ifndef _H_Controller
#define _H_Controller

#include <flatzebra/KeyState.h>

#include <SDL.h>

#include <vector>


class Controller
{
public:

    Controller();

    ~Controller();

    void processKey(SDLKey keysym, bool pressed);

    bool isMenuRequested() const
    {
	return menuKS.isPressed() || jButtonJustPressed(pauseBI);
    }

    bool isRightRequested() const
    {
	return rightKS.isPressed() || xAxis > +AXIS_MIN;
    }

    bool isLeftRequested() const
    {
	return leftKS.isPressed() || xAxis < -AXIS_MIN;
    }

    bool isUpRequested() const
    {
	return upKS.isPressed() || yAxis < -AXIS_MIN;
    }

    bool isDownRequested() const
    {
	return downKS.isPressed() || yAxis > +AXIS_MIN;
    }

    bool isShootRequested() const
    {
	return shootKS.justPressed();
    }

    bool isShootRightRequested() const
    {
	return shootRightKS.justPressed() || jButtonJustPressed(shootRightBI);
    }

    bool isShootLeftRequested() const
    {
	return shootLeftKS.justPressed() || jButtonJustPressed(shootLeftBI);
    }

    bool isShootUpRequested() const
    {
	return shootUpKS.justPressed() || jButtonJustPressed(shootUpBI);
    }

    bool isShootDownRequested() const
    {
	return shootDownKS.justPressed() || jButtonJustPressed(shootDownBI);
    }

    bool isNextMenuEntryRequested() const
    {
	return rightKS.justPressed();
    }

    bool isPrevMenuEntryRequested() const
    {
	return leftKS.justPressed();
    }

    bool isMenuSelectionRequested() const
    {
	return selectKS.justPressed() || jButtonJustPressed(startBI);
    }

    bool isMenuReturnRequested() const
    {
	return menuKS.justPressed();
    }

    void update();

private:

    bool getJButton(int buttonNumber) const
    {
	if (buttonNumber < 0 || buttonNumber >= static_cast<int>(joystickButtons.size()))
	    return false;
	return SDL_JoystickGetButton(joystick, buttonNumber);
    }

    bool jButtonJustPressed(int buttonNumber) const
    {
	return getJButton(buttonNumber) && !joystickButtons[static_cast<size_t>(buttonNumber)];
    }

    enum { AXIS_MIN = 28000 };  // mininum absolute value of axis

    flatzebra::KeyState menuKS;
    flatzebra::KeyState leftKS;
    flatzebra::KeyState rightKS;
    flatzebra::KeyState upKS;
    flatzebra::KeyState downKS;
    flatzebra::KeyState selectKS;
    flatzebra::KeyState shootKS;
    flatzebra::KeyState pauseKS;
    flatzebra::KeyState shootLeftKS;
    flatzebra::KeyState shootRightKS;
    flatzebra::KeyState shootUpKS;
    flatzebra::KeyState shootDownKS;
    SDL_Joystick *joystick;
    std::vector<bool> joystickButtons;
    Sint16 xAxis;
    Sint16 yAxis;
    // Button indices:
    int shootLeftBI;
    int shootRightBI;
    int shootUpBI;
    int shootDownBI;
    int startBI;
    int pauseBI;
};


#endif  /* _H_Controller */
