/*  $Id: sdlmain.cpp,v 1.3 2002/01/07 03:18:19 sarrazip Exp $
    sdlmain.cpp - main() function for Afternoon Stalker

    afternoonstalker - A robot-killing video game.
    Copyright (C) 2001 Pierre Sarrazin <sarrazip@iname.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
    02111-1307, USA.
*/

#include "AfternoonStalkerEngine.h"

#include <stdlib.h>
#include <errno.h>
#include <time.h>
#include <stdio.h>

#ifdef __GNUG__
    #include <getopt.h>
#endif

#include <string>

using namespace std;


#ifdef __GNUG__
static struct option knownOptions[] =
{
    { "help",          no_argument,       NULL, 'h' },
    { "version",       no_argument,       NULL, 'v' },
    { "ms-per-frame",  required_argument, NULL, 'm' },
    { "no-sound",      no_argument,       NULL, 'n' },
    { "full-screen",   no_argument,       NULL, 'f' },

    { NULL, 0, NULL, 0 }  // marks the end
};


static void
displayVersionNo()
{
    printf("%s %s\n", PACKAGE, VERSION);
}


static void
displayHelp()
{
    printf("\n");

    displayVersionNo();

    printf(
"\n"
"Copyright (C) 2001 Pierre Sarrazin <sarrazip@iname.com>\n"
"This program is free software; you may redistribute it under the terms of\n"
"the GNU General Public License.  This program has absolutely no warranty.\n"
    );

    printf(
"\n"
"Known options:\n"
"--help             Display this help page and exit\n"
"--version          Display this program's version number and exit\n"
"--ms-per-frame=N   N milliseconds per animation frame [default is 55]\n"
"                   Min. 1, max. 1000.  50 ms means 20 frames per second\n"
"--no-sound         Disable sound effects [default is to enable them]\n"
"--full-screen      Attempt to use full screen mode [default is window mode]\n"
"\n"
    );
}
#endif  /* __GNUG__ */


int main(int argc, char *argv[])
{
    /*  Default game parameters:
    */
    int millisecondsPerFrame = 55;
    bool useSound = true;
    bool fullScreen = false;

    #ifdef __GNUG__

    /*  Interpret the command-line options:
    */
    int c;
    do
    {
	c = getopt_long(argc, argv, "", knownOptions, NULL);

	switch (c)
	{
	    case EOF:
		break;  // nothing to do

	    case 'm':
		{
		    errno = 0;
		    long n = strtol(optarg, NULL, 10);
		    if (errno == ERANGE || n < 1 || n > 1000)
		    {
			printf("Invalid number of ms per frame.\n");
			displayHelp();
			return EXIT_FAILURE;
		    }

		    millisecondsPerFrame = int(n);
		}
		break;
	    
	    case 'n':
		useSound = false;
		break;
	    
	    case 'f':
		fullScreen = true;
		break;

	    case 'v':
		displayVersionNo();
		return EXIT_FAILURE;

	    case 'h':
	    default:
		displayHelp();
		return EXIT_FAILURE;
	}
    } while (c != EOF && c != '?');

    #endif  /* __GNUG__ */


    /*  Initialize the random number generator:
    */
    const char *s = getenv("SEED");
    unsigned int seed = (s != NULL ? atol(s) : time(NULL));
    #ifndef NDEBUG
    fprintf(stderr, "seed = %u\n", seed);
    fprintf(stderr, "ms-per-frame = %d\n", millisecondsPerFrame);
    #endif
    srand(seed);


    try
    {
	string windowManagerCaption = string("Afternoon Stalker ") + VERSION;
	AfternoonStalkerEngine theAfternoonStalkerEngine(
				windowManagerCaption, useSound, fullScreen);
	theAfternoonStalkerEngine.run(millisecondsPerFrame);
    }
    catch (const string &s)
    {
	fprintf(stderr, "%s: engine init error: %s\n", PACKAGE, s.c_str());
	return EXIT_FAILURE;
    }
    catch (int e)
    {
	fprintf(stderr, "%s: init error # %d\n", PACKAGE, e);
	return EXIT_FAILURE;
    }

    return EXIT_SUCCESS;
}
