/*  $Id: SoundPlayer.h,v 1.4 2001/12/31 03:14:53 sarrazip Exp $
    SoundPlayer.h - SDL Sound effect player

    afternoonstalker - A robot-killing video game.
    Copyright (C) 2001 Pierre Sarrazin <sarrazip@iname.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
    02111-1307, USA.
*/

#ifndef _H_SoundPlayer
#define _H_SoundPlayer

#include <SDL_types.h>
#include <SDL_audio.h>

#include <string>

using namespace std;


class SoundPlayer
{
public:

    SoundPlayer();
    /*  Initializes the SDL sound system.
    */

    ~SoundPlayer();
    /*  Closes the SDL sound system.
    */

    class WavBuffer
    /*  Represents one sound effect.

	The .wav file should have a rate of 11025 samples per
	second, have 8 bit unsigned integers for each sample and
	use a single channel (i.e., mono).

	!Peeve: The sox(1) command, which can be used this way to
	convert .wav files to the format expected by this class:

	    sox orig.wav -r 11025 -c 1 -b -u converted.wav
    */
    {
    public:
	WavBuffer();
	WavBuffer(const string &wavFilename) throw(int);
	int init(const string &wavFilename);
	~WavBuffer();
	Uint32 getLength() const { return len; }
    
    private:
	friend class SoundPlayer;

	Uint32 len;
	Uint8 *buf;

	// Forbidden:
	WavBuffer(const WavBuffer &);
	WavBuffer &operator = (const WavBuffer &);
    };


    void playWavBuffer(WavBuffer &wb);
    /*  Starts playing the designated sound.
	Keeps a pointer to the WavBuffer object until the sound has been
	played completely.
	Locks the audio critical region.
    */


private:

    struct WavBufferIterator
    {
	const WavBuffer *wavBuffer;
	Uint32 offset;

	WavBufferIterator(const WavBuffer *wb = NULL, Uint32 o = 0)
	    : wavBuffer(wb), offset(o) {}
	bool isValid() const
	    { return wavBuffer != NULL && offset < wavBuffer->getLength(); }
    };

    enum { MAX_NUM_SOUNDS = 4 };

    SDL_AudioSpec     theDesiredAudioSpec;
    WavBufferIterator currentIterators[MAX_NUM_SOUNDS];
    size_t            numCurrentIterators;


    static void sdlAudioCallback(void *userdata, Uint8 *stream, int len);
    void callbackMethod(Uint8 *stream, int len);
    WavBuffer *getCurrentWavBuffer();
    void mute();
    void eraseSlot(size_t slotIndex);


    /*	Forbidden operations:
    */
    SoundPlayer(const SoundPlayer &x);
    SoundPlayer &operator = (const SoundPlayer &x);
};


#endif  /* _H_SoundPlayer */
