dnl	This option allows one to specify the RPM release number.
dnl	This value will be used as the "Release:" field in the .spec file.
dnl	The default is 1.
dnl	Uses the value of the RPM_RELEASE environment variable if it is
dnl	defined and non empty.

AC_DEFUN([WITH_RPM_RELEASE],
[
	AC_ARG_WITH(rpm-release,
	[[  --with-rpm-release=X    Specify RPM release number [1]]],
	[
		if test "_$withval" = "_no"; then  # --without-cxx
			RPM_RELEASE=1  # not supported; use default
		elif test "_$withval" = "_yes"; then  # --with-cxx (no arg)
			RPM_RELEASE=1  # use default
		else
			RPM_RELEASE=$withval
		fi
	],
	[
		# Option not given: use default if $RPM_RELEASE not set
		if test -z "$RPM_RELEASE"; then
			RPM_RELEASE=1
		fi
	])

	AC_SUBST(RPM_RELEASE)

	AC_MSG_RESULT([using $RPM_RELEASE as RPM release number])
])
