dnl	This option allows one to specifiy which command is to be used
dnl	as the C++ compiler.  If the option is not given, but the CXX
dnl	environment variable is defined to a non empty value, this value
dnl	will be used.  The default is "c++".

AC_DEFUN([WITH_CXX],
[
	CXXFLAGS="-g -Wall"  # default compilation options

	AC_ARG_WITH(cxx,
	[  --with-cxx=PROG               Specify program to use as C++ compiler [c++]],
	[
		# If some smart ass uses --without-cxx, then $withval is "no"
		# and we use the default value.
		if test "_$withval" = "_no"; then
			CXX=c++
		elif test "_$withval" = "_yes"; then
			CXX=c++
		else
			CXX=$withval
		fi
	],
	[
		# Option not given: nothing to do.  $CXX may already be set.
		true
	])

	# Check added on 2001-12-05:
	if test -z "$CXX"; then
		AC_MSG_RESULT([using system default as C++ compiler])
	else
		AC_MSG_RESULT([using $CXX as C++ compiler])
	fi
])
