/* aewm - a minimalistic X11 window manager. ------- vim:sw=4:et
 * Copyright (c) 1998-2001 Decklin Foster <decklin@red-bean.com>
 * Free software! Please see README for details and license.  */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>

#define BUF_SIZE 1024

void add_cmd_buttons(void (*make_cmd_button)(char *, char *))
{
    char buf[BUF_SIZE], rc_file[BUF_SIZE], *label, *cmd;
    FILE *rc;

    snprintf(rc_file, sizeof rc_file, "%s/.paletterc", getenv("HOME"));

    if (!(rc = fopen(rc_file, "r"))) {
        printf("can't find $HOME/.paletterc; exiting...\n");
        exit(EXIT_FAILURE);
    }

    while (fgets(buf, sizeof buf, rc)) {
        if (buf[0] == '#' || buf[0] == '\n' || buf[0] == '@') continue;
        label = strtok(buf, "=");
        cmd = strtok(NULL, "\n");
        if (cmd) make_cmd_button(label, strdup(cmd));
    }

    fclose(rc);
}

void fork_exec(char *cmd)
{
    pid_t pid = fork();

    switch (pid) {
        case 0:
            execlp("/bin/sh", "sh", "-c", cmd, NULL);
            fprintf(stderr, "exec failed, cleaning up child\n");
            exit(1);
        case -1:
            fprintf(stderr, "can't fork\n"); break;
    }
}
