/* aewm - a minimalistic X11 window manager. ------- vim:sw=4:et
 * Copyright (c) 1998-2001 Decklin Foster <decklin@red-bean.com>
 * Free software! Please see README for details and license.  */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include "menu-misc.h"

#ifdef REGEX
#include <regex.h>
#endif

#define BUF_SIZE 1024

static void build_menu_recursively(FILE *, menu_t,
    void (*)(menu_t, char *, char *),
    menu_t (*)(menu_t, char *));

Display *dpy;

void build_menu(menu_t menu,
    void (*add_menu_item)(menu_t, char *, char *),
    menu_t (*add_sub_menu)(menu_t, char *))
{
    FILE *rc;
    char rc_file[BUF_SIZE];

    snprintf(rc_file, sizeof rc_file, "%s/.paletterc", getenv("HOME"));

    if (!(rc = fopen(rc_file, "r"))) {
        printf("can't find $HOME/.paletterc; exiting...\n");
        exit(1);
    }

    build_menu_recursively(rc, menu, add_menu_item, add_sub_menu);

    fclose(rc);
}

static void build_menu_recursively(FILE *rc, menu_t menu,
    void (*add_menu_item)(menu_t, char *, char *),
    menu_t (*add_sub_menu)(menu_t, char *))
{
    char buf[BUF_SIZE], *label, *cmd;

    while (fgets(buf, sizeof buf, rc)) {
        if (strncmp(buf, "@endsub", 7) == 0) return;
        if (buf[0] == '#' || buf[0] == '\n') continue;
        if (strncmp(buf, "@submenu", 8) == 0) {
            menu_t newmenu;
            label = strtok(buf, " ");
            cmd = strtok(NULL, "\n");
            newmenu = add_sub_menu(menu, cmd);
            build_menu_recursively(rc, newmenu, add_menu_item, add_sub_menu);
        } else {
            label = strtok(buf, "=");
            cmd = strtok(NULL, "\n");
            if (cmd) add_menu_item(menu, label, strdup(cmd));
        }
    }
}
