/* aewm - a minimalistic X11 window manager. ------- vim:sw=4:et
 * Copyright (c) 1998-2001 Decklin Foster <decklin@red-bean.com>
 * Free software! Please see README for details and license.  */

#include <stdio.h>
#include <X11/Xlib.h>
#include <gdk/gdkx.h>
#include <gtk/gtk.h>
#include "lib/switch-misc.h"

#define SPACING 4
#define NAME_SIZE 80

void make_client_button(Window);
void raise_win_cb(GtkWidget *, Window);
GtkWidget *toplevel, *bbox, *button;

int main(int argc, char *argv[])
{
    gtk_init(&argc, &argv);
    dpy = GDK_DISPLAY();
    root = GDK_ROOT_WINDOW();
    wm_state = XInternAtom(dpy, "WM_STATE", False);

    toplevel = gtk_window_new(GTK_WINDOW_DIALOG);
    gtk_container_set_border_width(GTK_CONTAINER(toplevel), SPACING);
    gtk_signal_connect(GTK_OBJECT(toplevel), "destroy",
        GTK_SIGNAL_FUNC(gtk_main_quit), NULL);

    bbox = gtk_vbox_new(FALSE, SPACING);
    gtk_container_add(GTK_CONTAINER(toplevel), bbox);

    update_clients(root, make_client_button, NULL);

    gtk_widget_show_all(toplevel);
    gtk_main();
    return 0;
}

void make_client_button(Window w)
{
    GtkWidget *button;
    char buf[NAME_SIZE];

    get_wm_name(w, buf, sizeof buf);
    button = gtk_button_new_with_label(buf);

    gtk_signal_connect(GTK_OBJECT(button), "clicked",
        GTK_SIGNAL_FUNC(raise_win_cb), (gpointer) w);
    gtk_object_set_user_data(GTK_OBJECT(button), (gpointer) w);
    gtk_box_pack_end(GTK_BOX(bbox), button, FALSE, FALSE, 0);
    gtk_widget_show(button);
}

void raise_win_cb(GtkWidget *widget, Window w)
{
    raise_win(w);
    gtk_main_quit();
}
