/* aewm - a minimalistic X11 window manager. ------- vim:sw=4:et
 * Copyright (c) 1998-2001 Decklin Foster <decklin@red-bean.com>
 * Free software! Please see README for details and license.  */

#include <stdio.h>
#include <X11/Xlib.h>
#include <gdk/gdkx.h>
#include <gtk/gtk.h>
#include "lib/switch-misc.h"

#define NAME_SIZE 80

void make_client_button(Window);
void raise_win_cb(GtkWidget *, Window);
GtkWidget *menu;

int main(int argc, char **argv)
{
    gtk_init(&argc, &argv);
    dpy = GDK_DISPLAY();
    root = GDK_ROOT_WINDOW();
    wm_state = XInternAtom(dpy, "WM_STATE", False);

    menu = gtk_menu_new();
    update_clients(root, make_client_button, NULL);
    gtk_signal_connect_object(GTK_OBJECT(menu), "deactivate",
        GTK_SIGNAL_FUNC(gtk_main_quit), (gpointer)NULL);
    gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL, 0, 0);

    gtk_main();
    return 0;
}

void make_client_button(Window w)
{
    GtkWidget *item;
    char buf[NAME_SIZE];

    get_wm_name(w, buf, sizeof buf);

    item = gtk_menu_item_new_with_label(buf);
    gtk_menu_append(GTK_MENU(menu), item);
    gtk_signal_connect(GTK_OBJECT(item), "activate",
        GTK_SIGNAL_FUNC(raise_win_cb), (gpointer) w);
    gtk_widget_show(item);
}

void raise_win_cb(GtkWidget *widget, Window w)
{
    raise_win(w);
    gtk_main_quit();
}
