/* aewm - a minimalistic X11 window manager. ------- vim:sw=4:et
 * Copyright (c) 1998-2001 Decklin Foster <decklin@red-bean.com>
 * Free software! Please see README for details and license.  */

#include <string.h>
#include <gtk/gtk.h>
#include "lib/panel-misc.h"

void make_cmd_button(char *, char *);
void fork_exec_cb(GtkWidget *, char *);
GtkWidget *menu;

int main(int argc, char **argv)
{
    gtk_init(&argc, &argv);

    menu = gtk_menu_new();
    add_cmd_buttons(make_cmd_button);
    gtk_signal_connect_object(GTK_OBJECT(menu), "deactivate",
        GTK_SIGNAL_FUNC(gtk_main_quit), (gpointer)NULL);
    gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL, 0, 0);

    gtk_main();
    return 0;
}

void make_cmd_button(char *label, char *cmd)
{
    GtkWidget *item;

    item = gtk_menu_item_new_with_label(label);
    gtk_menu_append(GTK_MENU(menu), item);
    gtk_signal_connect(GTK_OBJECT(item), "activate",
        GTK_SIGNAL_FUNC(fork_exec_cb), cmd);
    gtk_widget_show(item);
}

void fork_exec_cb(GtkWidget *widget, char *data)
{
    fork_exec(data);
    gtk_main_quit();
}
