/*  Copyright 1999 Enhanced Software Technologies Inc.
 * Released for public use under a BSD-style Open Source license.
 * See file "LICENSE" for more information. 

 * dstring.h -- dynamically allocated string functions. 
 *
 * RCS CHANGE LOG
 * Revision 1.2  2000/04/05 22:09:19  eric
 * Daily checkin...
 *
 * Revision 1.1  2000/03/28 23:54:28  eric
 * Initial checkin -- aescrypt/aesget
 *
 * Revision 1.4  1999/09/28 19:34:13  eric
 * added d_lpad and d_rpad routines.
 *
 * Revision 1.3  1999/09/13 16:08:44  eric
 * Added Ocotillo licensing info
 *
 * Revision 1.2  1999/08/27 20:52:26  eric
 * Whoops! changed d_split1 to d_split to match the actual code!
 *
 * Revision 1.1  1999/08/25 22:08:48  eric
 * Initial revision, dynamic string routines for "C".
 *
 */

#ifndef DSTRING_H
#define DSTRING_H 1

#include <stdio.h>

struct d_split_array {  /* result of d_split */
  char *str1;
  char *str2;
};
struct d_split2_array {  /* result of d_split2 */
  char *str1;
  char *str2;
  char *str3;
};

char *d_getline(FILE *file,int limit); /* get a line, malloc'ing a string. */
char *d_trim(char *src);               /* trim whitespace. */ 

char *d_lpad(char *src,int ch, int len); /* left pad with char to a length. */
char *d_rpad(char *src,int ch, int len); /* right pad with char to a length */

char *d_dup(char *src);                /* return malloc'ed duplicate */
char *d_cat(char *src1, char *src2);   /* return malloc'ed concatenation */
struct d_split_array *d_split(char *src, int ch);     /* split line into 2 pieces */
struct d_split2_array *d_split2(char *src,int ch); /* split line into THREE pieces */

#endif




