/* Copyright 2000 Enhanced Software Technologies Inc.
   All Rights Reserved.

   Released under a BSD-style license. See file LICENSE for details.

   dorandom.c -- read /dev/urandom.

RCS CHANGE LOG:
$Log: dorandom.c,v $
Revision 1.1.1.1  2001/05/17 17:11:01  elgreen
Initial checkin

Revision 1.5  2000/12/12 16:41:21  eric
aescrypt 0.6 (large patch by Peter Pentchev).

Revision 1.4  2000/04/24 19:46:57  eric
More autoconf tweaks. Changed to using Counterpane's TwoFish rather than
Dr. Gladman's TwoFish in an attempt to fix the big endian/little endian
problems once and for all.

Revision 1.2  2000/04/05 22:09:19  eric
Daily checkin...

Revision 1.1  2000/03/28 23:54:28  eric
Initial checkin -- aescrypt/aesget

$Date: 2001/05/17 17:11:01 $

*/


#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>

#include "dorandom.h"

static int infile;

int urand_seed(char *filename) {
  char *name;

  if (filename) {
    name=filename;
  } else {
    name=URAND_NAME;
  }

  infile=open(name,O_RDONLY);
  if (infile <= 0) {
    return 1; /* could not open! */
  }
  return 0; /* all okay! */
}

char *urand_get(int numbytes) {
  char *retval;
  int result;

  retval=(char *)malloc(numbytes);
  if (!retval) {
    fprintf(stderr,"dorandom:urand_get:error:out of memory.");
    exit(1); /* sorry :-(. */
  }
  
  
  result=read(infile,retval,numbytes);
  if (result < numbytes) {
    free(retval);
    return NULL; /* couldn't do it :-( */
  }

  return retval;
}

